/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.net;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.net.netJDBCConnection;
import com.pointbase.net.netJDBCPrimitives;
import com.pointbase.net.netJDBCResultSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class netJDBCStatement
extends netJDBCPrimitives
implements Statement {
    public static final int RETURN_GENERATED_KEYS = 1;
    public static final int NO_GENERATED_KEYS = 2;
    private String m_Resource = "com.pointbase.resource.resourceNetJDBCStatement";
    protected DataOutputStream m_dos;
    protected DataInputStream m_dis;
    protected netJDBCConnection m_cnx;
    protected boolean m_bClosed = false;
    protected String m_sql = null;
    protected ResultSet m_result = null;

    public netJDBCStatement(netJDBCConnection netJDBCConnection2, DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n) {
        this.m_cnx = netJDBCConnection2;
        this.m_dos = dataOutputStream;
        this.m_dis = dataInputStream;
        this.setObjectId(n);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            this.m_sql = string;
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.m_result = null;
                this.m_bClosed = false;
                Object[] objectArray = new Serializable[]{string};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeQuery(java.lang.String)", objectArray);
                int n = this.handleJDBCObjectResponse(this.m_dis);
                if (n == -10) {
                    ResultSet resultSet = this.m_result;
                    return resultSet;
                }
                ResultSet resultSet = this.m_result = new netJDBCResultSet(this.m_cnx, this, this.m_dos, this.m_dis, n);
                return resultSet;
            }
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        int n = 0;
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.m_bClosed = false;
                Object[] objectArray = new Serializable[]{string};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeUpdate(java.lang.String)", objectArray);
                n = (Integer)this.handlePrimitiveResponse(this.m_dis);
                this.m_cnx.condCommit();
                if ((n == -1000 || n == -1001) && this.isServerShutdown()) {
                    this.m_bClosed = true;
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
        return n;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        int n2 = 0;
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.m_bClosed = false;
                Object[] objectArray = new Serializable[]{string, new Integer(n)};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeUpdate(java.lang.String, $int)", objectArray);
                n2 = (Integer)this.handlePrimitiveResponse(this.m_dis);
                this.m_cnx.condCommit();
                if ((n2 == -1000 || n2 == -1001) && this.isServerShutdown()) {
                    this.m_bClosed = true;
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
        return n2;
    }

    public boolean execute(String string) throws SQLException {
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                boolean bl = false;
                this.m_result = null;
                this.m_bClosed = false;
                Object[] objectArray = new Serializable[]{string};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "execute( java.lang.String )", objectArray);
                bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                if (this.isServerShutdown()) {
                    this.m_bClosed = true;
                }
                if (bl) {
                    this.m_cnx.condCommit();
                }
                boolean bl2 = bl;
                return bl2;
            }
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                boolean bl = false;
                this.m_result = null;
                this.m_bClosed = false;
                Object[] objectArray = new Serializable[]{string, new Integer(n)};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "execute( java.lang.String, $int )", objectArray);
                bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                if (this.isServerShutdown()) {
                    this.m_bClosed = true;
                }
                if (!bl) {
                    this.m_cnx.condCommit();
                }
                boolean bl2 = bl;
                return bl2;
            }
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.rsClose();
            int[] nArray = null;
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeBatch()", null);
                nArray = (int[])this.handlePrimitiveResponse(this.m_dis);
            }
            return nArray;
        }
        catch (dbexcpException dbexcpException2) {
            this.m_cnx.condRollback();
            throw dbexcpException2.getSQLException();
        }
        catch (SQLException sQLException) {
            this.m_cnx.condRollback();
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        if (!this.isServerShutdown() && !this.m_bClosed) {
            if (!this.m_cnx.isClosed()) {
                this.rsClose();
                Object object = this.m_cnx.getMonitor();
                synchronized (object) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "close()", null);
                    this.handlePrimitiveResponse(this.m_dis);
                }
            }
            this.m_bClosed = true;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            if (this.m_result != null) {
                ResultSet resultSet = this.m_result;
                return resultSet;
            }
            int n = 0;
            Object object2 = this.m_cnx.getMonitor();
            synchronized (object2) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "getResultSet()", null);
                n = this.handleJDBCObjectResponse(this.m_dis);
            }
            if (n == -10) {
                ResultSet resultSet = this.m_result = null;
                return resultSet;
            }
            ResultSet resultSet = this.m_result = new netJDBCResultSet(this.m_cnx, this, this.m_dos, this.m_dis, n);
            return resultSet;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        int n = 0;
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getGeneratedKeys()", null);
            n = this.handleJDBCObjectResponse(this.m_dis);
        }
        if (n == -10) {
            return null;
        }
        return new netJDBCResultSet(this.m_cnx, this, this.m_dos, this.m_dis, n);
    }

    public int getUpdateCount() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getUpdateCount()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public boolean getMoreResults() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getMoreResults()", null);
            this.m_result = null;
            boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
            return bl;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getMaxFieldSize()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setMaxFieldSize( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public int getMaxRows() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getMaxRows()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setMaxRows(int n) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setMaxRows( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Boolean(bl)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setEscapeProcessing( $boolean )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public int getQueryTimeout() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getQueryTimeout()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setQueryTimeout( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public void cancel() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "cancel()", null);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        try {
            throw new dbexcpException(86009, new Object[]{"setCursorName"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void addBatch(String string) throws SQLException {
        Object[] objectArray = new Serializable[]{string};
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "addBatch(java.lang.String)", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public void clearBatch() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "clearBatch()", null);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_cnx;
    }

    public int getResultSetConcurrency() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getResultSetConcurrency()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public int getResultSetType() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getResultSetType()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public int getFetchDirection() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getFetchDirection()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setFetchDirection( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public int getFetchSize() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getFetchSize()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setFetchSize( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.functionUnsupported("getMoreResults");
        return false;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.functionUnsupported("executeUpdate");
        return -1;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.functionUnsupported("executeUpdate");
        return -1;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.functionUnsupported("execute");
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.functionUnsupported("execute");
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        this.functionUnsupported("getResultSetHoldability");
        return -1;
    }

    protected void functionUnsupported(String string) throws SQLException {
        try {
            throw new dbexcpException(86009, "p_Function");
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    protected void rsClose() throws SQLException {
        if (this.m_result != null) {
            this.m_result.close();
        }
    }

    void validate() throws SQLException {
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.m_cnx.validate();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_bClosed) {
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "finalizeCalled()", null);
                this.handlePrimitiveResponse(this.m_dis);
            }
        }
        this.m_bClosed = true;
    }
}

