/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.net;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.file.fileTempFileInputStream;
import com.pointbase.jdbc.jdbcBlob;
import com.pointbase.jdbc.jdbcClob;
import com.pointbase.net.BindEntry;
import com.pointbase.net.netBufferedInputStream;
import com.pointbase.net.netJDBCConnection;
import com.pointbase.net.netJDBCPrimitives;
import com.pointbase.net.netJDBCResultSetMetaData;
import com.pointbase.net.netJDBCStatement;
import com.pointbase.net.netLengthedInputStream;
import com.pointbase.net.netLengthedReader;
import com.pointbase.util.utilInputStreamFromReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class netJDBCResultSet
extends netJDBCPrimitives
implements ResultSet {
    private String m_Resource = "com.pointbase.resource.resourceNetJDBCResultSet";
    private DataOutputStream m_dos = null;
    private DataInputStream m_dis = null;
    private netJDBCResultSetMetaData m_rsmd = null;
    private netJDBCConnection m_cnx = null;
    private netJDBCStatement m_stmt = null;
    private Object[] m_CurrentRow = null;
    private Object[] m_OriginalRow = null;
    private Vector m_RowCache = new Vector();
    private boolean m_wasNull = false;
    private boolean m_bEOF = false;
    private int[] m_ColumnTypes;
    private boolean m_bClosed = true;
    private SQLException m_Error = null;
    private boolean m_CancelFlag = false;
    private int m_StartingRowNum = 0;
    private int m_CurRowIndex = 0;
    private int m_State = 0;
    private int m_CursorType;
    private int m_CursorConcurrency;
    private int m_RCFetchDirection;
    private int m_FetchDirection;
    private int m_FetchSize;
    private int m_max_field_size = 0;
    private boolean m_fromDatabaseMetadata = false;
    private int m_associatedXATransactionId = 0;
    private Vector m_bindBlock = new Vector();
    private boolean m_isInsertRow = false;
    private final int RS_LAST_ROW = Integer.MAX_VALUE;
    private final int RS_AFTER_LAST_ROW = -2147483647;
    private final int RS_FIRST_ROW = 1;
    private final int RS_BEFORE_FIRST_ROW = 0;

    public netJDBCResultSet() throws SQLException {
    }

    public netJDBCResultSet(netJDBCConnection netJDBCConnection2, netJDBCStatement netJDBCStatement2, DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n) throws SQLException {
        this.m_bClosed = false;
        this.m_cnx = netJDBCConnection2;
        this.m_stmt = netJDBCStatement2;
        this.m_dos = dataOutputStream;
        this.m_dis = dataInputStream;
        this.setObjectId(n);
        if (this.m_stmt == null) {
            this.m_CursorType = 1003;
            this.m_CursorConcurrency = 1007;
            this.m_FetchDirection = 1000;
            this.m_FetchSize = dbgaProperties.getPropertyFetchBlockSize();
        } else {
            this.m_CursorType = this.m_stmt.getResultSetType();
            this.m_CursorConcurrency = this.m_stmt.getResultSetConcurrency();
            this.m_FetchDirection = this.m_stmt.getFetchDirection();
            this.m_FetchSize = this.m_stmt.getFetchSize();
            this.m_max_field_size = this.m_stmt.getMaxFieldSize();
        }
        this.m_RCFetchDirection = this.m_FetchDirection;
        this.m_associatedXATransactionId = this.m_cnx.getCurrentXATransactionId();
        netJDBCConnection2.putRSObject(this);
        this.getMetaData();
    }

    public netJDBCResultSet(netJDBCConnection netJDBCConnection2, netJDBCStatement netJDBCStatement2, DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n, boolean bl) throws SQLException {
        this(netJDBCConnection2, netJDBCStatement2, dataOutputStream, dataInputStream, n);
        this.m_fromDatabaseMetadata = bl;
    }

    public boolean next() throws SQLException {
        if (this.m_CursorType == 1003) {
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.processCancel();
                try {
                    if (this.m_bClosed) {
                        throw new dbexcpException(86018);
                    }
                }
                catch (dbexcpException dbexcpException2) {
                    throw dbexcpException2.getSQLException();
                }
                if (++this.m_CurRowIndex < this.m_RowCache.size()) {
                    this.mapRow(this.m_CurRowIndex);
                    boolean bl = true;
                    return bl;
                }
                if (this.m_bEOF) {
                    boolean bl = false;
                    return bl;
                }
                if (this.m_Error != null) {
                    SQLException sQLException = this.m_Error;
                    this.m_Error = null;
                    throw sQLException;
                }
                if (this.fetchData(this.m_StartingRowNum + this.m_CurRowIndex, "next()")) {
                    this.mapRow(this.m_CurRowIndex);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return this.relative(1);
    }

    public void close() throws SQLException {
        if (!this.m_bClosed) {
            this.releaseRowCache();
            this.internalClose(false);
            this.m_cnx.removeRSObject(this);
            if (this.m_cnx.getAutoCommit() && !this.m_fromDatabaseMetadata) {
                this.m_cnx.cancelAllRS();
            }
        }
        this.m_bClosed = true;
    }

    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    public synchronized String getString(int n) throws SQLException {
        byte[] byArray;
        this.validateColumnIndex(n);
        Object object = null;
        boolean bl = this.m_wasNull = this.m_CurrentRow[n - 1] == null;
        if (this.m_wasNull) {
            return null;
        }
        object = this.m_CurrentRow[n - 1] instanceof String ? (String)this.m_CurrentRow[n - 1] : (this.m_CurrentRow[n - 1] instanceof netLengthedInputStream ? ((this.m_wasNull = (byArray = this.getBytes(n)) == null) ? null : new String(byArray)) : this.m_CurrentRow[n - 1].toString());
        object = this.performFieldLengthCheck((String)object);
        return object;
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        String string;
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return false;
        }
        if (this.m_CurrentRow[n - 1] instanceof Boolean) {
            return (Boolean)this.m_CurrentRow[n - 1];
        }
        String string2 = this.getString(n);
        return string2 == null || !(string = string2.trim()).equals("") && !string.startsWith("0") && !string.equalsIgnoreCase("FALSE");
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0;
        }
        if (this.m_CurrentRow[n - 1] instanceof Byte) {
            return (Byte)this.m_CurrentRow[n - 1];
        }
        return (byte)this.getInt(n);
    }

    public synchronized short getShort(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0;
        }
        if (this.m_CurrentRow[n - 1] instanceof Short) {
            return (Short)this.m_CurrentRow[n - 1];
        }
        try {
            BigDecimal bigDecimal = this.getBigDecimal(n, 0);
            if (bigDecimal != null) {
                int n2 = bigDecimal.intValue();
                if ((double)n2 < -32768.0 || (double)n2 > 32767.0) {
                    throw new dbexcpException(25015);
                }
                return (short)n2;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            dbexcpException dbexcpException2 = new dbexcpException(25015);
            throw dbexcpException2.getSQLException();
        }
        catch (dbexcpException dbexcpException3) {
            throw dbexcpException3.getSQLException();
        }
    }

    public synchronized int getInt(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0;
        }
        if (this.m_CurrentRow[n - 1] instanceof Integer) {
            return (Integer)this.m_CurrentRow[n - 1];
        }
        long l = this.getLong(n);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            dbexcpException dbexcpException2 = new dbexcpException(25015);
            throw dbexcpException2.getSQLException();
        }
        return (int)l;
    }

    public synchronized long getLong(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0L;
        }
        if (this.m_CurrentRow[n - 1] instanceof Long) {
            return (Long)this.m_CurrentRow[n - 1];
        }
        BigDecimal bigDecimal = this.getBigDecimal(n, 0);
        if (bigDecimal != null) {
            return bigDecimal.longValue();
        }
        return 0L;
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0.0f;
        }
        if (this.m_CurrentRow[n - 1] instanceof Float) {
            return ((Float)this.m_CurrentRow[n - 1]).floatValue();
        }
        try {
            String string = this.getString(n);
            if (string == null) {
                return 0.0f;
            }
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            dbexcpException dbexcpException2 = new dbexcpException(25015);
            throw dbexcpException2.getSQLException();
        }
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.validateColumnIndex(n);
        if (this.m_CurrentRow[n - 1] == null) {
            this.m_wasNull = true;
            return 0.0;
        }
        if (this.m_CurrentRow[n - 1] instanceof Double) {
            return (Double)this.m_CurrentRow[n - 1];
        }
        try {
            String string = this.getString(n);
            if (string == null) {
                return 0.0;
            }
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            dbexcpException dbexcpException2 = new dbexcpException(25015);
            throw dbexcpException2.getSQLException();
        }
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        try {
            String string = this.getString(n);
            if (string == null) {
                this.m_wasNull = true;
                return null;
            }
            if (string.equalsIgnoreCase("TRUE")) {
                string = "1";
            } else if (string.equalsIgnoreCase("FALSE")) {
                string = "0";
            }
            BigDecimal bigDecimal = new BigDecimal(string.trim());
            if (n2 >= 0) {
                bigDecimal.setScale(n2, 4);
            }
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            dbexcpException dbexcpException2 = new dbexcpException(25015);
            throw dbexcpException2.getSQLException();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] getBytes(int var1_1) throws SQLException {
        block21: {
            block20: {
                block19: {
                    this.validateColumnIndex(var1_1);
                    var2_2 = false;
                    v0 = this.m_wasNull = this.m_CurrentRow[var1_1 - 1] == null;
                    if (this.m_wasNull) {
                        return null;
                    }
                    if (!(this.m_CurrentRow[var1_1 - 1] instanceof netLengthedInputStream)) {
                        var3_4 = this.getString(var1_1);
                        if (var3_4 != null) return var3_4.getBytes();
                        return null;
                    }
                    var3_3 = null;
                    var4_5 = null;
                    var5_6 = null;
                    try {
                        try {
                            try {
                                var3_3 = ((netLengthedInputStream)this.m_CurrentRow[var1_1 - 1]).getInputStream();
                                this.m_wasNull = var3_3 == null;
                                if (this.m_wasNull) {
                                    var6_7 = null;
                                    var11_10 = null;
                                    break block19;
                                }
                                var7_18 = ((netLengthedInputStream)this.m_CurrentRow[var1_1 - 1]).getLength();
                                if (var3_3 instanceof fileTempFileInputStream) {
                                    var2_2 = true;
                                    var4_5 = new fileTempFileInputStream(((fileTempFileInputStream)var3_3).getFile());
                                } else {
                                    if (var3_3 instanceof ByteArrayInputStream) {
                                        var8_19 = new byte[]{};
                                        break block20;
                                    }
                                    var4_5 = var3_3;
                                }
                                var5_6 = new ByteArrayOutputStream();
                                var8_20 = null;
                                if (var7_18 > 0) {
                                    var8_20 = new byte[var7_18];
                                }
                                var9_21 = 0;
                                var9_21 = var2_2 != false ? var4_5.read(var8_20) : ((netBufferedInputStream)var4_5).readReset(var8_20);
                                var5_6.write(var8_20, 0, var9_21);
                                break block21;
                            }
                            catch (IOException var6_8) {
                                throw new dbexcpException(86021, new Object[]{"getBytes()", var6_8.toString()});
                            }
                        }
                        catch (dbexcpException var6_9) {
                            throw var6_9.getSQLException();
                        }
                    }
                    catch (Throwable var10_22) {
                        var11_13 = null;
                        try {
                            if (var4_5 == null) throw var10_22;
                            if (var4_5 instanceof fileTempFileInputStream == false) throw var10_22;
                            var4_5.close();
                            throw var10_22;
                        }
                        catch (IOException var12_17) {
                            // empty catch block
                        }
                        throw var10_22;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 284->305)] { 
lbl58:
                // 1 sources

                if (var4_5 == null) return var6_7;
                if (var4_5 instanceof fileTempFileInputStream == false) return var6_7;
                var4_5.close();
                return var6_7;
lbl62:
                // 1 sources

                catch (IOException var12_14) {
                    // empty catch block
                }
                return var6_7;
            }
            var11_11 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 284->305)] { 
lbl68:
            // 1 sources

            if (var4_5 == null) return var8_19;
            if (var4_5 instanceof fileTempFileInputStream == false) return var8_19;
            var4_5.close();
            return var8_19;
lbl72:
            // 1 sources

            catch (IOException var12_15) {
                // empty catch block
            }
            return var8_19;
        }
        var11_12 = null;
        try {}
        catch (IOException var12_16) {}
        if (var4_5 == null) return this.performFieldLengthCheck(var5_6.toByteArray());
        if (var4_5 instanceof fileTempFileInputStream == false) return this.performFieldLengthCheck(var5_6.toByteArray());
        var4_5.close();
        return this.performFieldLengthCheck(var5_6.toByteArray());
        return this.performFieldLengthCheck(var5_6.toByteArray());
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.validateColumnIndex(n);
        java.util.Date date = this.getInternalDate(n, 91);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        return new Date(date.getTime());
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.validateColumnIndex(n);
        Calendar calendar = Calendar.getInstance();
        java.util.Date date = this.getInternalDate(n, 92);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Time(date2.getTime());
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.validateColumnIndex(n);
        java.util.Date date = this.getInternalDate(n, 93);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        return (Timestamp)date;
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.getStream(n, null);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        return this.getStream(n, "UTF8");
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        return this.getStream(n, "UTF8");
    }

    private InputStream getStream(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        try {
            boolean bl = this.m_wasNull = this.m_CurrentRow[n - 1] == null;
            if (this.m_wasNull) {
                return null;
            }
            if (this.m_CurrentRow[n - 1] instanceof netLengthedInputStream) {
                InputStream inputStream = ((netLengthedInputStream)this.m_CurrentRow[n - 1]).getInputStream();
                int n2 = ((netLengthedInputStream)this.m_CurrentRow[n - 1]).getLength();
                this.m_wasNull = inputStream == null;
                if (this.m_wasNull) {
                    return null;
                }
                if (inputStream instanceof fileTempFileInputStream) {
                    inputStream = new fileTempFileInputStream(((fileTempFileInputStream)inputStream).getFile());
                }
                return inputStream;
            }
            if (string != null) {
                try {
                    return new utilInputStreamFromReader(new StringReader(new String(((String)this.m_CurrentRow[n - 1]).getBytes("UTF8"))));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new dbexcpException(75001, new Object[]{"UTF8"});
                }
            }
            return new utilInputStreamFromReader(new StringReader((String)this.m_CurrentRow[n - 1]));
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        catch (IOException iOException) {
            try {
                throw new dbexcpException(86021, new Object[]{"getStream()", iOException.toString()});
            }
            catch (dbexcpException dbexcpException3) {
                throw dbexcpException3.getSQLException();
            }
        }
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.processCancel();
        try {
            if (this.m_bClosed) {
                throw new dbexcpException(86018);
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        if (this.m_rsmd == null) {
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "getMetaData()", null);
                int n = this.handleJDBCObjectResponse(this.m_dis);
                this.m_rsmd = new netJDBCResultSetMetaData(this.m_cnx, this.m_dos, this.m_dis, n);
                this.m_ColumnTypes = new int[this.m_rsmd.getColumnCount()];
                int n2 = 0;
                while (n2 < this.m_rsmd.getColumnCount()) {
                    this.m_ColumnTypes[n2] = this.m_rsmd.getColumnType(n2 + 1);
                    ++n2;
                }
            }
        }
        return this.m_rsmd;
    }

    public synchronized Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        return this.getObject(n, resultSetMetaData.getColumnType(n), resultSetMetaData.getScale(n));
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.validate();
        try {
            int n = 1;
            while (n <= this.m_rsmd.getColumnCount()) {
                if (this.m_rsmd.getColumnName(n).equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            throw new dbexcpException(86015, new Object[]{string});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Blob getBlob(int n) throws SQLException {
        return new jdbcBlob(this.getBytes(n));
    }

    public Clob getClob(int n) throws SQLException {
        this.validateColumnIndex(n);
        byte[] byArray = null;
        try {
            try {
                byArray = this.getBytes(n);
                if (byArray == null) {
                    this.m_wasNull = true;
                    return null;
                }
                return new jdbcClob(new String(byArray, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"UTF8"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.validateColumnIndex(n);
        java.util.Date date = this.getInternalDate(n, 91);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Date(date2.getTime());
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.validateColumnIndex(n);
        java.util.Date date = this.getInternalDate(n, 92);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Time(date2.getTime());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.validateColumnIndex(n);
        java.util.Date date = this.getInternalDate(n, 93);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Timestamp(date2.getTime());
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.validateColumnIndex(n);
        try {
            try {
                return new InputStreamReader(this.getStream(n, "UTF8"), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"UTF8"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public boolean previous() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            return this.relative(-1);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean first() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_FetchDirection == 1001) {
                return this.absolute(Integer.MAX_VALUE);
            }
            return this.absolute(1);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean last() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_FetchDirection == 1001) {
                return this.absolute(1);
            }
            return this.absolute(Integer.MAX_VALUE);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                int n2;
                int n3;
                this.processCancel();
                try {
                    if (this.m_bClosed) {
                        throw new dbexcpException(86028);
                    }
                }
                catch (dbexcpException dbexcpException2) {
                    throw dbexcpException2.getSQLException();
                }
                if (this.m_RCFetchDirection == 1001) {
                    n3 = this.m_StartingRowNum - this.m_RowCache.size() + 1;
                    n2 = this.m_StartingRowNum;
                } else {
                    n3 = this.m_StartingRowNum;
                    n2 = this.m_StartingRowNum + this.m_RowCache.size() - 1;
                }
                if (n >= n3 && n <= n2) {
                    this.m_CurRowIndex = this.m_RCFetchDirection == 1001 ? this.m_StartingRowNum - n : n - this.m_StartingRowNum;
                    this.mapRow(this.m_CurRowIndex);
                    boolean bl = true;
                    return bl;
                }
                if (n == this.m_StartingRowNum + this.m_RowCache.size() && this.m_Error != null) {
                    SQLException sQLException = this.m_Error;
                    this.m_Error = null;
                    throw sQLException;
                }
                if (this.fetchData(n, "absolute( $int )")) {
                    this.mapRow(this.m_CurRowIndex);
                    boolean bl = true;
                    return bl;
                }
                this.m_CurrentRow = null;
                boolean bl = false;
                return bl;
            }
        }
        catch (dbexcpException dbexcpException3) {
            throw dbexcpException3.getSQLException();
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            int n2 = this.m_State == 0 ? this.getRow() : (this.m_RCFetchDirection == 1001 ? this.m_StartingRowNum - this.m_CurRowIndex : this.m_StartingRowNum + this.m_CurRowIndex);
            if (this.m_FetchDirection == 1001) {
                n *= -1;
            }
            if ((n2 += n) < 0) {
                return this.absolute(0);
            }
            return this.absolute(n2);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void afterLast() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            this.m_CurRowIndex = this.m_FetchDirection == 1001 ? 0 : -2147483647;
            this.absolute(this.m_CurRowIndex);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            this.m_CurRowIndex = this.m_FetchDirection == 1001 ? -2147483647 : 0;
            this.absolute(this.m_CurRowIndex);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            this.clearBinds();
            this.m_isInsertRow = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.m_isInsertRow) {
            this.clearBinds();
            this.m_isInsertRow = true;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_State == 0) {
                Object object = this.m_cnx.getMonitor();
                synchronized (object) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "isFirst( )", null);
                    boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                    return bl;
                }
            }
            return this.m_StartingRowNum == 1 && this.m_CurRowIndex == 0;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_State == 0) {
                Object object = this.m_cnx.getMonitor();
                synchronized (object) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "isBeforeFirst( )", null);
                    boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                    return bl;
                }
            }
            return false;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isLast() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                if (this.m_State == 0) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "isLast( )", null);
                    boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                    return bl;
                }
                if (this.m_State == 1 && this.m_RowCache.size() == this.m_CurRowIndex + 1) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "isLast( )", null);
                    if (!((Boolean)this.handlePrimitiveResponse(this.m_dis)).booleanValue()) {
                        this.sendMethodRequest(this.m_cnx, this.m_dos, "isAfterLast( )", null);
                        boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                        return bl;
                    }
                }
            }
            return false;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_State == 0) {
                Object object = this.m_cnx.getMonitor();
                synchronized (object) {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "isAfterLast( )", null);
                    boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                    return bl;
                }
            }
            return false;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getRow() throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            if (this.m_State > 0) {
                return this.m_StartingRowNum + this.m_CurRowIndex;
            }
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "getRow()", null);
                int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
                return n;
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateString(int n, String string) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), string};
        this.addBind(n, new BindEntry("updateString( $int, java.lang.String )", objectArray));
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Boolean(bl)};
        this.addBind(n, new BindEntry("updateBoolean( $int, $boolean )", objectArray));
    }

    public void updateNull(int n) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n)};
        this.addBind(n, new BindEntry("updateNull( $int )", objectArray));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), object, new Integer(n2)};
        this.addBind(n, new BindEntry("updateObject( $int, java.lang.Object, $int )", objectArray));
    }

    public void updateObject(int n, Object object) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), object};
        this.addBind(n, new BindEntry("updateObject( $int, java.lang.Object )", objectArray));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Byte(by)};
        this.addBind(n, new BindEntry("updateByte( $int, $byte )", objectArray));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Short(s)};
        this.addBind(n, new BindEntry("updateShort( $int, $short )", objectArray));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        this.addBind(n, new BindEntry("updateInt( $int, $int )", objectArray));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Long(l)};
        this.addBind(n, new BindEntry("updateLong( $int, $long )", objectArray));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Float(f)};
        this.addBind(n, new BindEntry("updateFloat( $int, $float )", objectArray));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), new Double(d)};
        this.addBind(n, new BindEntry("updateDouble( $int, $double )", objectArray));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), bigDecimal};
        this.addBind(n, new BindEntry("updateBigDecimal( $int, java.math.BigDecimal )", objectArray));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), byArray};
        this.addBind(n, new BindEntry("updateBytes( $int, $byte[] )", objectArray));
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), date};
        this.addBind(n, new BindEntry("updateDate( $int, java.sql.Date )", objectArray));
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), time};
        this.addBind(n, new BindEntry("updateTime( $int, java.sql.Time )", objectArray));
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkUpdateable();
        Object[] objectArray = new Object[]{new Integer(n), timestamp};
        this.addBind(n, new BindEntry("updateTimestamp( $int, java.sql.Timestamp )", objectArray));
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdateable();
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedInputStream(inputStream, n2), new Integer(n2)};
            this.addBind(n, new BindEntry("updateAsciiStream( $int, java.io.InputStream, $int )", objectArray));
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkUpdateable();
        if (reader == null) {
            this.updateNull(n);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedReader(reader, n2), new Integer(n2)};
            this.addBind(n, new BindEntry("updateCharacterStream( $int, java.io.Reader, $int )", objectArray));
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdateable();
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedInputStream(inputStream, n2), new Integer(n2)};
            this.addBind(n, new BindEntry("updateBinaryStream( $int, java.io.InputStream, $int )", objectArray));
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateRow() throws SQLException {
        this.validate();
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            throw new dbexcpException(25108).getSQLException();
        }
        if (this.m_bindBlock.size() == 0) {
            return;
        }
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            try {
                try {
                    this.validate();
                    Object[] objectArray = new Object[]{new Integer(this.m_StartingRowNum + this.m_CurRowIndex)};
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "setToRow( $int )", objectArray);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.flushBindVariables();
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "updateRow()", null);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.m_cnx.condCommit();
                }
                catch (SQLException sQLException) {
                    this.m_cnx.condRollback();
                    throw sQLException;
                }
                Object var4_4 = null;
                this.clearBinds();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearBinds();
                throw throwable;
            }
        }
    }

    public void insertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.m_isInsertRow) {
            throw new dbexcpException(25108).getSQLException();
        }
        if (this.m_bindBlock.size() == 0) {
            return;
        }
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            try {
                try {
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "moveToInsertRow()", null);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.flushBindVariables();
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "insertRow()", null);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.m_cnx.condCommit();
                }
                catch (SQLException sQLException) {
                    this.m_cnx.condRollback();
                    throw sQLException;
                }
                Object var4_2 = null;
                this.clearBinds();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.clearBinds();
                throw throwable;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.validate();
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            throw new dbexcpException(25108).getSQLException();
        }
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            try {
                try {
                    this.validate();
                    Object[] objectArray = new Object[]{new Integer(this.m_StartingRowNum + this.m_CurRowIndex)};
                    this.sendMethodRequestNoFlush(this.m_cnx, this.m_dos, "setToRow( $int )", objectArray);
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "deleteRow()", null);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.handlePrimitiveResponse(this.m_dis);
                    this.m_cnx.condCommit();
                }
                catch (SQLException sQLException) {
                    this.m_cnx.condRollback();
                    throw sQLException;
                }
                Object var4_4 = null;
                this.clearBinds();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearBinds();
                throw throwable;
            }
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            throw new dbexcpException(25108).getSQLException();
        }
        if (this.m_bindBlock.size() > 0) {
            int n = 0;
            while (n < this.m_CurrentRow.length) {
                this.m_CurrentRow[n] = this.m_OriginalRow[n];
                ++n;
            }
        }
        this.clearBinds();
    }

    public void refreshRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowUpdated() throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(this.m_StartingRowNum + this.m_CurRowIndex)};
        this.sendMethodRequestNoFlush(this.m_cnx, this.m_dos, "setToRow( $int )", objectArray);
        this.sendMethodRequest(this.m_cnx, this.m_dos, "rowUpdated()", null);
        this.handlePrimitiveResponse(this.m_dis);
        return (Boolean)this.handlePrimitiveResponse(this.m_dis);
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(this.m_StartingRowNum + this.m_CurRowIndex)};
        this.sendMethodRequestNoFlush(this.m_cnx, this.m_dos, "setToRow( $int )", objectArray);
        this.sendMethodRequest(this.m_cnx, this.m_dos, "rowDeleted()", null);
        this.handlePrimitiveResponse(this.m_dis);
        return (Boolean)this.handlePrimitiveResponse(this.m_dis);
    }

    public int getType() throws SQLException {
        return this.m_CursorType;
    }

    public int getConcurrency() throws SQLException {
        return this.m_CursorConcurrency;
    }

    public Statement getStatement() throws SQLException {
        return this.m_stmt;
    }

    public int getFetchDirection() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getFetchDirection()", null);
            int n = (Integer)this.handlePrimitiveResponse(this.m_dis);
            return n;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            if (this.m_CursorType == 1003) {
                throw new dbexcpException(25019);
            }
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                Object[] objectArray = new Serializable[]{new Integer(n)};
                this.sendMethodRequest(this.m_cnx, this.m_dos, "setFetchDirection( $int )", objectArray);
                this.handlePrimitiveResponse(this.m_dis);
            }
            this.m_FetchDirection = n;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        return this.m_FetchSize;
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86031, new Object[]{new Integer(n)});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            Object[] objectArray = new Serializable[]{new Integer(n)};
            this.sendMethodRequest(this.m_cnx, this.m_dos, "setFetchSize( $int )", objectArray);
            this.handlePrimitiveResponse(this.m_dis);
        }
        this.m_FetchSize = n > 0 ? n : dbgaProperties.getPropertyFetchBlockSize();
    }

    public URL getURL(int n) throws SQLException {
        this.functionUnsupported("getURL");
        return null;
    }

    public URL getURL(String string) throws SQLException {
        this.functionUnsupported("getURL");
        return null;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.functionUnsupported("updateRef");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.functionUnsupported("updateRef");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.functionUnsupported("updateBlob");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.functionUnsupported("updateBlob");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.functionUnsupported("updateClob");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.functionUnsupported("updateClob");
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.functionUnsupported("updateArray");
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.functionUnsupported("updateArray");
    }

    private void functionUnsupported(String string) throws SQLException {
        try {
            throw new dbexcpException(86009, "p_Function");
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    void cancel() {
        this.m_CancelFlag = true;
    }

    private Object getObject(int n, int n2, int n3) throws SQLException {
        this.validateColumnIndex(n);
        this.m_wasNull = false;
        switch (n2) {
            case -7: {
                boolean bl = this.getBoolean(n);
                return this.m_wasNull ? null : new Boolean(bl);
            }
            case -6: {
                int n4 = this.getInt(n);
                return this.m_wasNull ? null : new Integer(n4);
            }
            case 5: {
                short s = this.getShort(n);
                return this.m_wasNull ? null : new Short(s);
            }
            case 4: {
                int n5 = this.getInt(n);
                return this.m_wasNull ? null : new Integer(n5);
            }
            case -5: {
                long l = this.getLong(n);
                return this.m_wasNull ? null : new Long(l);
            }
            case 6: {
                String string = this.getString(n);
                return this.m_wasNull ? null : new Double(string);
            }
            case 7: {
                float f = this.getFloat(n);
                return this.m_wasNull ? null : new Float(f);
            }
            case 8: {
                double d = this.getDouble(n);
                return this.m_wasNull ? null : new Double(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n, n3);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case -4: 
            case 1111: {
                byte[] byArray;
                Object object = byArray = this.getBytes(n);
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return object;
            }
        }
        return null;
    }

    Object[] fetchAndBufferRow(boolean bl) throws SQLException {
        int n = this.m_rsmd.getColumnCount();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray2 = new Serializable[]{new Integer(n2 + 1)};
            switch (this.m_ColumnTypes[n2]) {
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    Object object;
                    objectArray[n2] = object = (netLengthedInputStream)this.handlePrimitiveResponse(this.m_dis);
                    break;
                }
                default: {
                    Object object = this.m_cnx.getMonitor();
                    synchronized (object) {
                        if (!bl) {
                            this.sendMethodRequest(this.m_cnx, this.m_dos, "getString( $int )", objectArray2);
                        }
                        objectArray[n2] = this.handlePrimitiveResponse(this.m_dis);
                        break;
                    }
                }
            }
            ++n2;
        }
        return objectArray;
    }

    private java.util.Date getInternalDate(int n, int n2) throws SQLException {
        try {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n3 = this.getMetaData().getColumnType(n);
            if (n3 == 1 || n3 == 12) {
                n3 = n2;
            }
            if (n3 == 91) {
                stringBuffer.append(string.trim());
                stringBuffer.append(" 0:0:0");
            } else if (n3 == 92) {
                stringBuffer.append("1970-1-1 ");
                stringBuffer.append(string.trim());
            } else if (n3 == 93) {
                stringBuffer.append(string.trim());
            } else {
                throw new dbexcpException(25015);
            }
            return Timestamp.valueOf(stringBuffer.toString());
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        catch (Exception exception) {
            try {
                throw new dbexcpException(86016, new Object[]{exception.toString()});
            }
            catch (dbexcpException dbexcpException3) {
                throw dbexcpException3.getSQLException();
            }
        }
    }

    private void internalClose(boolean bl) throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            if (this.m_cnx.isClosed()) {
                return;
            }
            if (!this.m_bClosed) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "close()", null);
                this.handlePrimitiveResponse(this.m_dis);
            }
            if (bl || this.m_stmt != null) {
                // empty if block
            }
            if (this.m_rsmd != null) {
                this.m_rsmd.close();
            }
            this.m_rsmd = null;
            this.m_bClosed = true;
        }
    }

    private void processCancel() throws SQLException {
        if (this.m_CancelFlag) {
            if (!this.m_bClosed) {
                this.releaseRowCache();
            }
            this.m_stmt = null;
            this.m_bClosed = true;
            this.m_CancelFlag = false;
        }
    }

    private void validateColumnIndex(int n) throws SQLException {
        this.m_wasNull = false;
        this.validate();
        try {
            if (n > this.m_CurrentRow.length) {
                throw new dbexcpException(86015, Integer.toString(n));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private void validate() throws SQLException {
        this.processCancel();
        try {
            if (this.m_CurrentRow == null || this.m_bClosed || this.m_cnx.getCurrentXATransactionId() != this.m_associatedXATransactionId) {
                throw new dbexcpException(86028);
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private boolean fetchData(int n, String string) throws SQLException {
        Object object;
        int n2 = 0;
        this.m_Error = null;
        try {
            object = this.m_cnx.getMonitor();
            synchronized (object) {
                Object[] objectArray = new Serializable[]{new Integer(n)};
                this.sendMethodRequest(this.m_cnx, this.m_dos, string, objectArray);
                this.releaseRowCache();
                this.m_RCFetchDirection = this.m_FetchDirection;
                int n3 = (Integer)this.handlePrimitiveResponse(this.m_dis);
                n2 = 0;
                while (n2 < n3) {
                    boolean bl = (Boolean)this.handlePrimitiveResponse(this.m_dis);
                    if (!bl) {
                        this.m_bEOF = true;
                        ++n2;
                        break;
                    }
                    Object[] objectArray2 = this.fetchAndBufferRow(true);
                    this.m_RowCache.addElement(objectArray2);
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            this.m_Error = sQLException;
        }
        if (this.m_RowCache.size() == 0) {
            if (this.m_Error != null) {
                object = this.m_Error;
                this.m_Error = null;
                throw object;
            }
            this.m_StartingRowNum = -1;
            this.m_CurRowIndex = -1;
            this.m_State = 0;
            return false;
        }
        if (n < 0 || n == Integer.MAX_VALUE) {
            if (this.m_RCFetchDirection == 1001) {
                this.m_State = 0;
                this.m_StartingRowNum = this.getRow() + n2 - 1;
            } else {
                this.m_State = 0;
                this.m_StartingRowNum = this.getRow() - n2 + 1;
            }
        } else {
            this.m_StartingRowNum = n;
        }
        this.m_CurRowIndex = 0;
        this.m_State = 1;
        if (this.m_CursorType == 1003) {
            this.m_StartingRowNum = 0;
        }
        return true;
    }

    private void mapRow(int n) throws SQLException {
        this.m_CurrentRow = (Object[])this.m_RowCache.elementAt(n);
    }

    private void releaseRowCache() throws SQLException {
        try {
            int n = 0;
            while (n < this.m_RowCache.size()) {
                this.m_CurrentRow = (Object[])this.m_RowCache.elementAt(n);
                int n2 = 0;
                while (n2 < this.m_CurrentRow.length) {
                    if (this.m_CurrentRow[n2] instanceof netLengthedInputStream) {
                        ((netLengthedInputStream)this.m_CurrentRow[n2]).close();
                    }
                    ++n2;
                }
                ++n;
            }
            this.m_RowCache.removeAllElements();
            this.m_CurrentRow = null;
        }
        catch (IOException iOException) {
            try {
                throw new dbexcpException(86021, new Object[]{"getStream()", iOException.toString()});
            }
            catch (dbexcpException dbexcpException2) {
                throw dbexcpException2.getSQLException();
            }
        }
    }

    private String performFieldLengthCheck(String string) {
        if (this.m_max_field_size != 0 && string.length() > this.m_max_field_size) {
            String string2;
            string = string2 = new String(string.substring(0, this.m_max_field_size));
        }
        return string;
    }

    private byte[] performFieldLengthCheck(byte[] byArray) {
        if (this.m_max_field_size != 0 && byArray.length > this.m_max_field_size) {
            byte[] byArray2 = new byte[this.m_max_field_size];
            System.arraycopy(byArray, 0, byArray2, 0, this.m_max_field_size);
            byArray = byArray2;
        }
        return byArray;
    }

    protected void finalize() throws Throwable {
        if (!this.m_bClosed) {
            this.releaseRowCache();
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "finalizeCalled()", null);
                this.handlePrimitiveResponse(this.m_dis);
            }
        }
        this.m_bClosed = true;
    }

    private void clearBinds() {
        if (this.m_bindBlock != null) {
            this.m_bindBlock.removeAllElements();
        }
    }

    private void flushBindVariables() throws SQLException {
        try {
            int n = 0;
            Object object = this.m_cnx.getMonitor();
            synchronized (object) {
                Enumeration enumeration = this.m_bindBlock.elements();
                while (enumeration.hasMoreElements()) {
                    BindEntry bindEntry = (BindEntry)enumeration.nextElement();
                    this.sendMethodRequestNoFlush(this.m_cnx, this.m_dos, bindEntry.getMethod(), bindEntry.getArgs());
                    ++n;
                }
                this.flushOutput(this.m_dos);
                this.clearBinds();
                int n2 = 0;
                while (n2 < n) {
                    this.handlePrimitiveResponse(this.m_dis);
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "flushBindVariables(...)";
            objectArray[1] = iOException.toString();
            throw new dbexcpException(2006, objectArray).getSQLException();
        }
    }

    private void checkUpdateable() throws SQLException {
        if (this.m_CursorConcurrency != 1008) {
            throw new dbexcpException(25019).getSQLException();
        }
    }

    private void addBind(int n, BindEntry bindEntry) {
        this.m_bindBlock.addElement(bindEntry);
        if (!this.m_isInsertRow && this.m_CurrentRow != null) {
            if (this.m_OriginalRow == null) {
                this.m_OriginalRow = new Object[this.m_CurrentRow.length];
            }
            if (this.m_bindBlock.size() == 1) {
                int n2 = 0;
                while (n2 < this.m_CurrentRow.length) {
                    this.m_OriginalRow[n2] = this.m_CurrentRow[n2];
                    ++n2;
                }
            }
            this.m_CurrentRow[n - 1] = bindEntry.getArgs()[1].toString();
        }
    }
}

