/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiBindParameter;
import com.pointbase.api.apiBindParameterBinary;
import com.pointbase.api.apiBindParameterInputStream;
import com.pointbase.api.apiBindParameterInteger;
import com.pointbase.api.apiBindParameterReader;
import com.pointbase.api.apiBindParameterString;
import com.pointbase.api.apiResultHeader;
import com.pointbase.api.apiResultSet;
import com.pointbase.command.commandConstants;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.jdbc.jdbcBlob;
import com.pointbase.jdbc.jdbcClob;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcObject;
import com.pointbase.jdbc.jdbcPreparedStatement;
import com.pointbase.jdbc.jdbcResultSetMetaData;
import com.pointbase.jdbc.jdbcStatement;
import com.pointbase.util.utilInputStreamFromReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class jdbcResultSet
extends jdbcObject
implements ResultSet {
    private apiResultSet m_result;
    private jdbcStatement m_stmt;
    private jdbcResultSetMetaData m_rsmd;
    private boolean m_wasNull;
    private boolean m_isClosed = false;
    private int m_ResultSetNum;
    private int m_CursorType;
    private int m_ResultSetIndex;
    private int m_FetchDirection;
    private int m_FetchSize;
    private int m_max_field_size = 0;
    private int m_associatedXATransactionId = 0;
    private boolean m_isInsertRow = false;

    public jdbcResultSet() {
    }

    public jdbcResultSet(apiResultHeader apiResultHeader2, jdbcStatement jdbcStatement2, int n) {
        this.m_result = null;
        this.m_stmt = jdbcStatement2;
        this.m_wasNull = false;
        this.m_ResultSetIndex = n;
        this.m_rsmd = new jdbcResultSetMetaData(apiResultHeader2);
        this.m_isClosed = false;
        this.m_ResultSetNum = this.m_stmt.getNextResultSetNum();
        this.m_CursorType = jdbcStatement2.getCursorType();
        if (this.m_CursorType == 0) {
            this.m_CursorType = jdbcStatement2.getType();
        }
        this.m_associatedXATransactionId = this.m_stmt.getjdbcConnection().getCurrentXATransactionId();
        try {
            this.m_max_field_size = this.m_stmt.getMaxFieldSize();
            this.setFetchDirection(this.m_stmt.getFetchDirection());
            this.m_FetchSize = this.m_stmt.getFetchSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized boolean next() throws SQLException {
        try {
            int n = 1;
            if (this.m_FetchDirection == 2) {
                n = -1;
            }
            this.assertNotClosed();
            this.m_result = this.m_stmt.getApiStatement().fetchRelativeRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void close() throws SQLException {
        try {
            if (!this.m_isClosed) {
                if (this.m_stmt != null) {
                    this.m_stmt.rsClose(this.m_ResultSetIndex);
                }
                if (this.m_rsmd != null) {
                    this.m_rsmd.releaseResources();
                }
                this.m_isClosed = true;
                this.m_result = null;
                if (dbgaProperties.getPropertiesDebugLog() && this.m_stmt != null) {
                    String string = this.m_stmt.buildLogInfo();
                    this.m_stmt.printDebugInfo(string + " Closed ResultSet Rs" + Integer.toString(this.m_ResultSetNum));
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    public String getString(int n) throws SQLException {
        try {
            this.validate();
            String string = this.m_result.getResultSetRowDataString(n - 1);
            string = this.performFieldLengthCheck(string);
            this.m_wasNull = string == null;
            return string;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            this.validate();
            return (byte)this.getInt(n);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            String string;
            String string2 = this.m_result.getResultSetRowDataString(n - 1);
            boolean bl = this.m_wasNull = string2 == null;
            return !(string2 != null ? (string = string2.trim()).equals("") || string.startsWith("0") || string.equalsIgnoreCase("FALSE") : this.m_wasNull);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            this.validate();
            short s = this.m_result.getShort(n - 1);
            this.m_wasNull = this.m_result.wasNull();
            return s;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            this.validate();
            int n2 = this.m_result.getInt(n - 1);
            this.m_wasNull = this.m_result.wasNull();
            return n2;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            this.validate();
            long l = this.m_result.getLong(n - 1);
            this.m_wasNull = this.m_result.wasNull();
            return l;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            this.validate();
            float f = this.m_result.getFloat(n - 1);
            this.m_wasNull = this.m_result.wasNull();
            return f;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            this.validate();
            double d = this.m_result.getDouble(n - 1);
            this.m_wasNull = this.m_result.wasNull();
            return d;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            this.validate();
            BigDecimal bigDecimal = this.m_result.getBigDecimal(n - 1, n2);
            this.m_wasNull = this.m_result.wasNull();
            return bigDecimal;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(int var1_1) throws SQLException {
        block12: {
            var2_2 = null;
            var3_3 = null;
            try {
                try {
                    this.m_wasNull = false;
                    this.validate();
                    var2_2 = this.m_result.getResultSetRowDataInputStream(var1_1 - 1);
                    var4_4 = this.m_result.getLobDataLength(var1_1 - 1);
                    if (var2_2 == null) {
                        this.m_wasNull = true;
                        var5_6 = null;
                        var8_8 = null;
                        break block12;
                    }
                    var3_3 = new ByteArrayOutputStream();
                    var5_7 = null;
                    var5_7 = var4_4 > 0 ? new byte[var4_4] : new byte[1024];
                    try {
                        while ((var6_14 = var2_2.read(var5_7)) != -1) {
                            var3_3.write(var5_7, 0, var6_14);
                        }
                    }
                    catch (IOException var6_15) {
                        throw new dbexcpException(86019, new Object[]{"getBytes(...)", var6_15.toString()});
                    }
                    var8_9 = null;
                }
                catch (dbexcpException var4_5) {
                    throw var4_5.getSQLException();
                }
                try {
                    if (var2_2 == null) return this.performFieldLengthCheck(var3_3.toByteArray());
                    var2_2.close();
                    return this.performFieldLengthCheck(var3_3.toByteArray());
                }
                catch (IOException var9_12) {
                    return this.performFieldLengthCheck(var3_3.toByteArray());
                }
            }
            catch (Throwable var7_16) {
                var8_10 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 171->182)] { 
lbl38:
                // 1 sources

                if (var2_2 == null) throw var7_16;
                var2_2.close();
                throw var7_16;
lbl41:
                // 1 sources

                catch (IOException var9_13) {
                    // empty catch block
                }
                throw var7_16;
            }
        }
        ** try [egrp 3[TRYBLOCK] [3 : 171->182)] { 
lbl46:
        // 1 sources

        if (var2_2 == null) return var5_6;
        var2_2.close();
        return var5_6;
lbl49:
        // 1 sources

        catch (IOException var9_11) {
            // empty catch block
        }
        return var5_6;
    }

    public Date getDate(int n) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 91);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        return new Date(date.getTime());
    }

    public Time getTime(int n) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 92);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        return new Time(date.getTime());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 93);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        utilInputStreamFromReader utilInputStreamFromReader2 = null;
        try {
            try {
                InputStream inputStream = this.getInputStream(n);
                if (inputStream == null) {
                    this.m_wasNull = true;
                    return inputStream;
                }
                utilInputStreamFromReader2 = new utilInputStreamFromReader(new InputStreamReader(inputStream, "UTF8"), "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"ASCII"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        return utilInputStreamFromReader2;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getInputStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getInputStream(n);
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            return this.m_rsmd;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Object getObject(int n, int n2, int n3) throws SQLException {
        this.m_wasNull = false;
        switch (n2) {
            case -7: {
                boolean bl = this.getBoolean(n);
                return this.m_wasNull ? null : new Boolean(bl);
            }
            case -6: {
                int n4 = this.getInt(n);
                return this.m_wasNull ? null : new Integer(n4);
            }
            case 5: {
                short s = this.getShort(n);
                return this.m_wasNull ? null : new Short(s);
            }
            case 4: {
                int n5 = this.getInt(n);
                return this.m_wasNull ? null : new Integer(n5);
            }
            case -5: {
                long l = this.getLong(n);
                return this.m_wasNull ? null : new Long(l);
            }
            case 6: {
                String string = this.getString(n);
                return this.m_wasNull ? null : new Double(string);
            }
            case 7: {
                float f = this.getFloat(n);
                return this.m_wasNull ? null : new Float(f);
            }
            case 8: {
                double d = this.getDouble(n);
                return this.m_wasNull ? null : new Double(d);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getBigDecimal(n, n3);
                return this.m_wasNull ? null : bigDecimal;
            }
            case -1: 
            case 1: 
            case 12: {
                String string = this.getString(n);
                return this.m_wasNull ? null : string;
            }
            case 91: {
                Date date = this.getDate(n);
                return this.m_wasNull ? null : date;
            }
            case 92: {
                Time time = this.getTime(n);
                return this.m_wasNull ? null : time;
            }
            case 93: {
                Timestamp timestamp = this.getTimestamp(n);
                return this.m_wasNull ? null : timestamp;
            }
            case -3: 
            case -2: {
                byte[] byArray = this.getBytes(n);
                return this.m_wasNull ? null : byArray;
            }
            case -4: 
            case 1111: {
                byte[] byArray = this.getBytes(n);
                Object object = null;
                if (this.m_wasNull) {
                    return null;
                }
                object = byArray;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return object;
            }
        }
        return null;
    }

    public Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, 0);
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return this.getObject(n, n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n, 0);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public int findColumn(String string) throws SQLException {
        try {
            return 1 + this.m_rsmd.columnNumber(string);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = null;
        byArray = this.getBytes(n);
        if (byArray == null) {
            this.m_wasNull = true;
            return null;
        }
        return new jdbcBlob(byArray);
    }

    public Clob getClob(int n) throws SQLException {
        byte[] byArray = null;
        try {
            try {
                byArray = this.getBytes(n);
                if (byArray == null) {
                    this.m_wasNull = true;
                    return null;
                }
                return new jdbcClob(new String(byArray, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"UTF8"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 91);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Date(date2.getTime());
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 92);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Time(date2.getTime());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        java.util.Date date = this.getInternalDate(n, 93);
        if (date == null) {
            this.m_wasNull = true;
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        java.util.Date date2 = calendar.getTime();
        return new Timestamp(date2.getTime());
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Object var2_2 = null;
        try {
            try {
                InputStream inputStream = this.getInputStream(n);
                if (inputStream != null) {
                    return new InputStreamReader(inputStream, "UTF8");
                }
                this.m_wasNull = true;
                return null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"UTF8"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public boolean previous() throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            int n = -1;
            if (this.m_FetchDirection == 2) {
                n = 1;
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            this.m_result = this.m_stmt.getApiStatement().fetchRelativeRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean first() throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            int n = this.m_FetchDirection == 2 ? Integer.MAX_VALUE : 1;
            this.m_result = this.m_stmt.getApiStatement().fetchAbsoluteRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean last() throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            int n = this.m_FetchDirection == 2 ? 1 : Integer.MAX_VALUE;
            this.m_result = this.m_stmt.getApiStatement().fetchAbsoluteRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean absolute(int n) throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            this.m_result = this.m_stmt.getApiStatement().fetchAbsoluteRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean relative(int n) throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_FetchDirection == 2) {
                n = -n;
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            this.m_result = this.m_stmt.getApiStatement().fetchRelativeRow(this.m_stmt.getResultSetIndex(), n);
            return this.m_result != null;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void afterLast() throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(25017);
            }
            int n = this.m_FetchDirection == 2 ? 0 : -2147483647;
            this.m_result = this.m_stmt.getApiStatement().fetchAbsoluteRow(this.m_stmt.getResultSetIndex(), n);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.m_result != null) {
            this.m_result.clearBind();
        }
        try {
            this.assertNotClosed();
            if ((this.m_CursorType & 0xF) == 1) {
                throw new dbexcpException(25019);
            }
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            int n = this.m_FetchDirection == 2 ? -2147483647 : 0;
            this.m_result = this.m_stmt.getApiStatement().fetchAbsoluteRow(this.m_stmt.getResultSetIndex(), n);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            if (this.m_result != null) {
                this.m_result.clearBind();
            }
            this.m_isInsertRow = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.m_isInsertRow) {
            if (this.m_result != null) {
                this.m_result.clearBind();
            }
            this.m_isInsertRow = true;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            if (this.m_FetchDirection == 2) {
                return this.m_stmt.getApiStatement().isLast();
            }
            return this.m_stmt.getApiStatement().isFirst();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            if (this.m_FetchDirection == 2) {
                return this.m_stmt.getApiStatement().isAfterLast();
            }
            return this.m_stmt.getApiStatement().isBeforeFirst();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isLast() throws SQLException {
        try {
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            if (this.m_FetchDirection == 2) {
                return this.m_stmt.getApiStatement().isFirst();
            }
            return this.m_stmt.getApiStatement().isLast();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            if (this.m_FetchDirection == 2) {
                return this.m_stmt.getApiStatement().isBeforeFirst();
            }
            return this.m_stmt.getApiStatement().isAfterLast();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getRow() throws SQLException {
        try {
            if (this.m_stmt == null || this.m_isClosed) {
                throw new dbexcpException(86018);
            }
            return this.m_stmt.getApiStatement().getCurrRowNumber();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    protected void setBind(apiBindParameter apiBindParameter2) throws SQLException {
        try {
            if (this.m_result == null) {
                this.m_result = new apiResultSet(this.m_stmt.getApiStatement());
            }
            if (this.m_result.getBinds() == null) {
                this.m_result.initialBinds(this.m_rsmd.getColumnCount());
            }
            this.m_result.setBind(apiBindParameter2);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(n2);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n3, null));
    }

    public void updateString(int n, String string) throws SQLException {
        this.checkUpdateable();
        if (string == null) {
            this.setNull(n, 12);
        } else {
            int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(12);
            this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, string));
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-7);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, new Boolean(bl).toString()));
    }

    public void updateNull(int n) throws SQLException {
        this.checkUpdateable();
        this.setNull(n, this.m_rsmd.getColumnType(n));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkUpdateable();
        try {
            int n3 = this.m_rsmd.getColumnType(n);
            int n4 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(n3);
            Object object2 = object;
            if (object2 == null) {
                this.setNull(n, n3);
            } else {
                switch (n3) {
                    case 1111: {
                        if (object2 instanceof Serializable) {
                            try {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                objectOutputStream.writeObject(object2);
                                objectOutputStream.flush();
                                objectOutputStream.close();
                                byte[] byArray = byteArrayOutputStream.toByteArray();
                                this.setBind((apiBindParameter)new apiBindParameterBinary(n - 1, 121, byArray));
                                break;
                            }
                            catch (IOException iOException) {
                                throw new dbexcpException(86013, new Object[]{"setObject(...)", iOException.toString()});
                            }
                        }
                        throw new dbexcpException(86012, new Object[]{object2.getClass().getName()});
                    }
                    case 93: {
                        String string = object2.toString();
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 92: {
                        String string = object2.toString();
                        if (object2 instanceof Timestamp) {
                            string = object2.toString();
                            string.substring(string.indexOf(32) + 1, string.length());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 91: {
                        String string = object2.toString();
                        if (object2 instanceof Timestamp) {
                            string = object2.toString().substring(0, 18);
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: {
                        if (object2 instanceof InputStream) {
                            this.setInputStream(n, n4, (InputStream)object2, n2, null);
                        }
                        if (object2 instanceof byte[]) {
                            this.updateBytes(n, (byte[])object2);
                            break;
                        }
                        this.updateString(n, object2.toString());
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        Integer n5 = null;
                        n5 = object2 instanceof Boolean ? new Integer((Boolean)object2 != false ? "1" : "0") : (object2 instanceof Float ? new Integer(((Float)object2).intValue()) : (object2 instanceof Double ? new Integer(((Double)object2).intValue()) : (object2 instanceof Long ? new Integer(((Long)object2).intValue()) : (object2 instanceof BigDecimal ? new Integer(((BigDecimal)object2).intValue()) : new Integer(object2.toString())))));
                        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n4, n5));
                        break;
                    }
                    case -5: {
                        String string = object2.toString();
                        if (object2 instanceof Boolean) {
                            string = (Boolean)object2 != false ? "1" : "0";
                        } else if (object2 instanceof Float) {
                            string = Long.toString((long)((Float)object2).floatValue());
                        } else if (object2 instanceof Double) {
                            string = Long.toString((long)((Double)object2).doubleValue());
                        } else if (object2 instanceof BigDecimal) {
                            string = Long.toString(((BigDecimal)object2).longValue());
                        } else if (object2 instanceof Integer) {
                            string = Long.toString(((Integer)object2).longValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 2: 
                    case 3: {
                        String string = object2.toString();
                        if (object2 instanceof Boolean) {
                            string = (Boolean)object2 != false ? "1" : "0";
                        } else if (object2 instanceof Float) {
                            string = BigDecimal.valueOf((long)((Float)object2).floatValue()).toString();
                        } else if (object2 instanceof Double) {
                            string = BigDecimal.valueOf((long)((Double)object2).doubleValue()).toString();
                        } else if (object2 instanceof Integer) {
                            string = BigDecimal.valueOf(((Integer)object2).longValue()).toString();
                        } else if (object2 instanceof Long) {
                            string = BigDecimal.valueOf((Long)object2).toString();
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 7: {
                        String string = object2.toString();
                        if (object2 instanceof Boolean) {
                            string = (Boolean)object2 != false ? "1" : "0";
                        } else if (object2 instanceof BigDecimal) {
                            string = Float.toString(((BigDecimal)object2).floatValue());
                        } else if (object2 instanceof Double) {
                            string = Float.toString(((Double)object2).floatValue());
                        } else if (object2 instanceof Integer) {
                            string = Float.toString(((Integer)object2).floatValue());
                        } else if (object2 instanceof Long) {
                            string = Float.toString(((Long)object2).floatValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 6: 
                    case 8: {
                        String string = object2.toString();
                        if (object2 instanceof Boolean) {
                            string = (Boolean)object2 != false ? "1" : "0";
                        } else if (object2 instanceof BigDecimal) {
                            string = Double.toString(((BigDecimal)object2).doubleValue());
                        } else if (object2 instanceof Float) {
                            string = Double.toString(((Float)object2).doubleValue());
                        } else if (object2 instanceof Integer) {
                            string = Double.toString(((Integer)object2).doubleValue());
                        } else if (object2 instanceof Long) {
                            string = Double.toString(((Long)object2).doubleValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    default: {
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, object2.toString()));
                    }
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-6);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n2, new Integer(by)));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(5);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n2, new Integer(s)));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.checkUpdateable();
        int n3 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(4);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n3, new Integer(n2)));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-5);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Long.toString(l)));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(6);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Double.toString(f)));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.checkUpdateable();
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(8);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Double.toString(d)));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkUpdateable();
        if (bigDecimal == null) {
            this.setNull(n, 2);
            return;
        }
        int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(2);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, bigDecimal.toString()));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkUpdateable();
        if (byArray.length < 4096) {
            this.setBind((apiBindParameter)new apiBindParameterBinary(n - 1, 121, byArray));
        } else {
            int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-4);
            this.setInputStream(n, n2, new ByteArrayInputStream(byArray), byArray.length, null);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.checkUpdateable();
        if (date == null) {
            this.setNull(n, 91);
        } else {
            int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(91);
            this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, date.toString()));
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.checkUpdateable();
        if (time == null) {
            this.setNull(n, 92);
        } else {
            int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(92);
            this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, time.toString()));
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkUpdateable();
        if (timestamp == null) {
            this.setNull(n, 93);
        } else {
            int n2 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(93);
            this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, timestamp.toString()));
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdateable();
        if (inputStream == null) {
            this.setNull(n, -1);
            return;
        }
        int n3 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-1);
        this.setInputStream(n, n3, inputStream, n2, null);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkUpdateable();
        if (reader == null) {
            this.setNull(n, -1);
            return;
        }
        int n3 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-1);
        this.setReader(n, n3, reader, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdateable();
        if (inputStream == null) {
            this.setNull(n, -4);
            return;
        }
        int n3 = jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(-4);
        this.setInputStream(n, n3, inputStream, n2, null);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateRow() throws SQLException {
        block9: {
            block8: {
                this.checkUpdateable();
                try {
                    try {
                        this.assertNotClosed();
                        if (this.m_stmt == null) throw new dbexcpException(86018);
                        if (this.m_isClosed) {
                            throw new dbexcpException(86018);
                        }
                        if (this.m_isInsertRow) {
                            throw new dbexcpException(25108);
                        }
                        if (this.m_result.isBindClear()) {
                            Object var3_1 = null;
                            if (this.m_result == null) return;
                            break block8;
                        }
                        this.m_result = this.m_stmt.getApiStatement().updateRow(this.m_result.getBinds());
                        break block9;
                    }
                    catch (dbexcpException dbexcpException2) {
                        throw dbexcpException2.getSQLException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.m_result == null) throw throwable;
                    this.m_result.clearBind();
                    throw throwable;
                }
            }
            this.m_result.clearBind();
            return;
        }
        Object var3_2 = null;
        if (this.m_result == null) return;
        this.m_result.clearBind();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRow() throws SQLException {
        block9: {
            block8: {
                this.checkUpdateable();
                try {
                    try {
                        this.assertNotClosed();
                        if (this.m_stmt == null) throw new dbexcpException(86018);
                        if (this.m_isClosed) {
                            throw new dbexcpException(86018);
                        }
                        if (!this.m_isInsertRow) {
                            throw new dbexcpException(25108);
                        }
                        if (this.m_result.isBindClear()) {
                            Object var3_1 = null;
                            if (this.m_result == null) return;
                            break block8;
                        }
                        this.m_stmt.getApiStatement().insertRow(this.m_result.getBinds());
                        break block9;
                    }
                    catch (dbexcpException dbexcpException2) {
                        throw dbexcpException2.getSQLException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.m_result == null) throw throwable;
                    this.m_result.clearBind();
                    throw throwable;
                }
            }
            this.m_result.clearBind();
            return;
        }
        Object var3_2 = null;
        if (this.m_result == null) return;
        this.m_result.clearBind();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteRow() throws SQLException {
        this.checkUpdateable();
        try {
            try {
                this.assertNotClosed();
                if (this.m_stmt == null || this.m_isClosed) {
                    throw new dbexcpException(86018);
                }
                if (this.m_isInsertRow) {
                    throw new dbexcpException(25108);
                }
                this.m_stmt.getApiStatement().deleteRow();
            }
            catch (dbexcpException dbexcpException2) {
                throw dbexcpException2.getSQLException();
            }
            Object var3_1 = null;
            if (this.m_result == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (this.m_result == null) throw throwable;
            this.m_result.clear();
            throw throwable;
        }
        this.m_result.clear();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkUpdateable();
        if (this.m_isInsertRow) {
            throw new dbexcpException(25108).getSQLException();
        }
        this.m_result.clearBind();
    }

    public void refreshRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowInserted() throws SQLException {
        this.checkUpdateable();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkUpdateable();
        try {
            this.assertNotClosed();
            return this.m_stmt.getApiStatement().rowUpdated();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowDeleted() throws SQLException {
        this.checkUpdateable();
        try {
            this.assertNotClosed();
            return this.m_stmt.getApiStatement().rowDeleted();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getType() throws SQLException {
        switch (this.m_CursorType & 0xF) {
            case 2: {
                return 1004;
            }
            case 4: {
                return 1005;
            }
        }
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        switch (this.m_CursorType & 0xF0) {
            case 32: {
                return 1008;
            }
        }
        return 1007;
    }

    public Statement getStatement() throws SQLException {
        return this.m_stmt;
    }

    public int getFetchDirection() throws SQLException {
        switch (this.m_FetchDirection) {
            case 4: {
                return 1002;
            }
            case 2: {
                return 1001;
            }
        }
        return 1000;
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            switch (n) {
                case 1001: {
                    if ((this.m_CursorType & 0xF) == 1) {
                        throw new dbexcpException(25019);
                    }
                    this.m_FetchDirection = 2;
                    break;
                }
                case 1000: {
                    this.m_FetchDirection = 1;
                    break;
                }
                case 1002: {
                    this.m_FetchDirection = 4;
                    break;
                }
                default: {
                    throw new dbexcpException(25218);
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        return this.m_FetchSize;
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86031, new Object[]{new Integer(n)});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_FetchSize = n > 0 ? n : dbgaProperties.getPropertyFetchBlockSize();
    }

    public int getLobDataLength(String string) throws SQLException {
        return this.getLobDataLength(this.findColumn(string));
    }

    public int getLobDataLength(int n) throws SQLException {
        int n2 = 0;
        try {
            this.validate();
            n2 = this.m_result.getLobDataLength(n - 1);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        return n2;
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public void setToRow(int n) throws dbexcpException, SQLException {
        this.moveToCurrentRow();
        this.m_stmt.getApiStatement().setToRow(n);
    }

    public void clearRowCache() {
        this.m_stmt.getApiStatement().clearRowCache();
    }

    public URL getURL(int n) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getURL");
        return null;
    }

    public URL getURL(String string) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getURL");
        return null;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateRef");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateRef");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateBlob");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateBlob");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateClob");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateClob");
    }

    public void updateArray(int n, Array array) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateArray");
    }

    public void updateArray(String string, Array array) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("updateArray");
    }

    protected void setApiResultSet(apiResultSet apiResultSet2) {
        this.m_result = apiResultSet2;
    }

    protected void setStatement(jdbcStatement jdbcStatement2) {
        this.m_stmt = jdbcStatement2;
    }

    protected void setResultSetMetaData(jdbcResultSetMetaData jdbcResultSetMetaData2) {
        this.m_rsmd = jdbcResultSetMetaData2;
    }

    private void assertNotClosed() throws dbexcpException, SQLException {
        if (this.m_isClosed) {
            throw new dbexcpException(86018);
        }
        if (this.m_stmt.getApiStatement().getCancelFlag()) {
            this.close();
            throw new dbexcpException(86018);
        }
    }

    private String performFieldLengthCheck(String string) {
        if (string != null && this.m_max_field_size != 0 && string.length() > this.m_max_field_size) {
            String string2;
            string = string2 = new String(string.substring(0, this.m_max_field_size));
        }
        return string;
    }

    private byte[] performFieldLengthCheck(byte[] byArray) {
        if (byArray != null && this.m_max_field_size != 0 && byArray.length > this.m_max_field_size) {
            byte[] byArray2 = new byte[this.m_max_field_size];
            System.arraycopy(byArray, 0, byArray2, 0, this.m_max_field_size);
            byArray = byArray2;
        }
        return byArray;
    }

    private InputStream getInputStream(int n) throws SQLException {
        try {
            this.validate();
            InputStream inputStream = this.m_result.getResultSetRowDataInputStream(n - 1);
            this.m_wasNull = inputStream == null;
            return inputStream;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private java.util.Date getInternalDate(int n, int n2) throws SQLException {
        try {
            this.validate();
            java.util.Date date = this.m_result.getResultSetRowDataDate(n - 1, n2);
            this.m_wasNull = this.m_result.wasNull();
            return date;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        catch (Exception exception) {
            try {
                throw new dbexcpException(86016, new Object[]{exception.toString()});
            }
            catch (dbexcpException dbexcpException3) {
                throw dbexcpException3.getSQLException();
            }
        }
    }

    private void setInputStream(int n, int n2, InputStream inputStream, int n3, String string) throws SQLException {
        try {
            this.setBind((apiBindParameter)new apiBindParameterInputStream(n - 1, n2, inputStream, n3, commandConstants.UPDATE));
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private void setReader(int n, int n2, Reader reader, int n3) throws SQLException {
        try {
            this.setBind((apiBindParameter)new apiBindParameterReader(n - 1, n2, reader, n3, commandConstants.UPDATE));
        }
        catch (dbexcpException dbexcpException2) {
            dbexcpException2.getSQLException();
        }
    }

    private void validate() throws dbexcpException {
        if (this.m_result == null || this.m_isClosed || this.m_stmt.getjdbcConnection().getCurrentXATransactionId() != this.m_associatedXATransactionId) {
            throw new dbexcpException(86028);
        }
    }

    private void checkUpdateable() throws SQLException {
        if ((this.m_CursorType & 0xF0) != 32) {
            throw new dbexcpException(25019).getSQLException();
        }
    }

    public int getBaseType(int n) throws SQLException {
        int n2 = 2;
        try {
            n2 = this.m_result.getBaseType(n - 1);
        }
        catch (dbexcpException dbexcpException2) {
            dbexcpException2.getSQLException();
        }
        return n2;
    }

    public int getInternalSQLType(int n) throws SQLException {
        int n2 = 0;
        try {
            n2 = this.m_result.getInternalSQLType(n - 1);
        }
        catch (dbexcpException dbexcpException2) {
            dbexcpException2.getSQLException();
        }
        return n2;
    }
}

