/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.collxn.collxnVector;
import com.pointbase.jdbc.jdbcILogResultSet;
import com.pointbase.jdbc.jdbcINewRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class jdbcLogResultSet
implements jdbcILogResultSet {
    private jdbcINewRowSet mRowSet;
    private collxnVector mAllRows;
    private collxnVector mAllUpdatedRows;
    private collxnVector mCurrRow;
    private collxnVector mCurrUpdatedRow;
    private ResultSetMetaData[] mMetaData;
    private char[] mUpdatedKeys;
    private int mCurrOpType;
    private int mFixedRows;
    private int mNumColumns;
    private int mCurrIndex;
    private int mMaxRows;
    private boolean mWasNull;

    public jdbcLogResultSet(ResultSet resultSet) {
        this.mRowSet = (jdbcINewRowSet)resultSet;
        this.mMetaData = this.mRowSet.getMetaDataArray();
    }

    public boolean next() throws SQLException {
        if (this.mAllRows == null && this.mAllUpdatedRows == null || this.mCurrIndex >= this.mMaxRows) {
            if (this.mRowSet.nextBlock()) {
                this.mCurrIndex = 0;
                this.mAllRows = this.mRowSet.getRows();
                this.mMaxRows = this.mAllRows.size();
                this.mAllUpdatedRows = this.mRowSet.getUpdatedRows();
            } else {
                return false;
            }
        }
        this.mCurrRow = (collxnVector)this.mAllRows.elementAt(this.mCurrIndex);
        this.mCurrUpdatedRow = (collxnVector)this.mAllUpdatedRows.elementAt(this.mCurrIndex);
        this.mFixedRows = (Integer)this.mCurrRow.elementAt(0);
        this.mNumColumns = this.mCurrRow.size() - this.mFixedRows;
        this.mCurrOpType = this.getOperationType();
        ++this.mCurrIndex;
        if (this.mCurrOpType == 1) {
            this.mUpdatedKeys = ((String)this.mCurrUpdatedRow.elementAt(this.mNumColumns)).toCharArray();
        }
        return true;
    }

    public int getFixedColumnLength() {
        return this.mFixedRows;
    }

    public int getColumnCount() {
        return this.mNumColumns;
    }

    public int getOperationType() {
        String string = (String)this.mCurrRow.elementAt(2);
        if (string.equals("I")) {
            return 0;
        }
        if (string.equals("U")) {
            return 1;
        }
        if (string.equals("D")) {
            return 2;
        }
        return 3;
    }

    public int getTableIndex() {
        return (Integer)this.mCurrRow.elementAt(3);
    }

    public int getTransactionID() {
        return (Integer)this.mCurrRow.elementAt(1);
    }

    public String getTableName() throws SQLException {
        return this.mMetaData[this.getTableIndex()].getTableName(1);
    }

    public boolean wasNull() {
        return this.mWasNull;
    }

    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.getObject(n);
        if (this.mWasNull) {
            return false;
        }
        return bl;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getObject(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getObject(n);
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getObject(n);
    }

    public double getDouble(int n) throws SQLException {
        Double d = (Double)this.getObject(n);
        if (this.mWasNull) {
            return 0.0;
        }
        return d;
    }

    public float getFloat(int n) throws SQLException {
        Float f = (Float)this.getObject(n);
        if (this.mWasNull) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public int getInt(int n) throws SQLException {
        Integer n2 = (Integer)this.getObject(n);
        if (this.mWasNull) {
            return 0;
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        Long l = (Long)this.getObject(n);
        if (this.mWasNull) {
            return 0L;
        }
        return l;
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = this.mCurrOpType == 1 && this.mUpdatedKeys[n - 1] == 'Y' ? this.mCurrUpdatedRow.elementAt(n - 1) : this.mCurrRow.elementAt(this.mFixedRows + n - 1);
        this.mWasNull = object == null;
        return object;
    }

    public short getShort(int n) throws SQLException {
        Short s = (Short)this.getObject(n);
        if (this.mWasNull) {
            return 0;
        }
        return s;
    }

    public String getString(int n) throws SQLException {
        return this.getObject(n).toString();
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getObject(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getObject(n);
    }
}

