/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcPooledConnection;
import com.pointbase.transxn.transxnXaResource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class jdbcConnectionHandle
implements Connection {
    private Connection m_Connection;
    private boolean m_IsXAConnection;
    private jdbcPooledConnection m_PooledConnection;

    public jdbcConnectionHandle(jdbcPooledConnection jdbcPooledConnection2, Connection connection) throws SQLException {
        this.m_Connection = connection;
        if (this.m_Connection == null || (this.m_PooledConnection = jdbcPooledConnection2) == null) {
            throw new NullPointerException("Null Parameters given");
        }
        this.m_IsXAConnection = ((transxnXaResource)((Object)connection)).isXAConnection();
    }

    public void clearWarnings() throws SQLException {
        this.validate();
        this.m_Connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.validate();
        this.m_PooledConnection.notifyCloseToListeners();
        ((transxnXaResource)((Object)this.m_Connection)).closeXA();
        this.m_Connection = null;
    }

    public void commit() throws SQLException {
        this.validate();
        this.m_Connection.commit();
    }

    public Statement createStatement() throws SQLException {
        this.validate();
        return this.m_Connection.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.validate();
        return this.m_Connection.createStatement(n, n2);
    }

    public boolean getAutoCommit() throws SQLException {
        this.validate();
        return this.m_Connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.validate();
        return this.m_Connection.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validate();
        return this.m_Connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.validate();
        return this.m_Connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.validate();
        return this.m_Connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return this.m_Connection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        this.validate();
        return this.m_Connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        this.validate();
        return this.m_Connection.isClosed();
    }

    public String nativeSQL(String string) throws SQLException {
        this.validate();
        return this.m_Connection.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.validate();
        return this.m_Connection.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.m_Connection.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.validate();
        return this.m_Connection.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.m_Connection.prepareStatement(string, n, n2);
    }

    public void rollback() throws SQLException {
        this.validate();
        this.m_Connection.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.validate();
        this.m_Connection.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.validate();
        this.m_Connection.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.validate();
        this.m_Connection.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.validate();
        this.m_Connection.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validate();
        this.m_Connection.setTypeMap(map);
    }

    public int getHoldability() throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getHoldability");
        return -1;
    }

    public void setHoldability(int n) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getHoldability");
    }

    private void validate() throws SQLException {
        if (this.m_Connection == null) {
            throw new SQLException("Invalid Connection");
        }
    }

    private void validXAOperation() throws SQLException {
        if (this.m_IsXAConnection) {
            throw new SQLException("Invalid Operation on XAConnection");
        }
    }
}

