/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class jdbcBlob
implements Blob,
Serializable {
    private byte[] m_Data;
    private long m_Length;

    public jdbcBlob(byte[] byArray) throws SQLException {
        try {
            if (byArray == null) {
                throw new dbexcpException(86040, new Object[]{"byte[] data", "jdbcBlob(...)", "jdbcBlob", "null"});
            }
            if (byArray.length <= 0) {
                throw new dbexcpException(86041, new Object[]{"byte[] data", "jdbcBlob(...)", "jdbcBlob"});
            }
            this.m_Length = byArray.length;
            this.m_Data = new byte[(int)this.m_Length];
            this.m_Data = byArray;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public jdbcBlob(Blob blob) throws SQLException {
        try {
            try {
                if (blob == null) {
                    throw new dbexcpException(86040, new Object[]{"Blob data", "jdbcBlob(...)", "jdbcBlob", "null"});
                }
                this.m_Length = blob.length();
                InputStream inputStream = blob.getBinaryStream();
                this.m_Data = new byte[(int)this.m_Length];
                int n = inputStream.read(this.m_Data, 0, (int)this.m_Length);
                if ((long)n != this.m_Length) {
                    throw new dbexcpException(25201, " != " + this.m_Length);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new dbexcpException(86000, new Object[]{iOException.toString()});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public long length() throws SQLException {
        return this.m_Length;
    }

    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_Data);
        return byteArrayInputStream;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        try {
            if (l <= 0L) {
                throw new dbexcpException(86040, new Object[]{"long position", "getBytes(...)", "jdbcBlob", Long.toString(l)});
            }
            if (n <= 0) {
                throw new dbexcpException(86040, new Object[]{"int length", "getBytes(...)", "jdbcBlob", Integer.toString(n)});
            }
            byte[] byArray = new byte[n];
            int n2 = (int)l;
            if ((long)(n2 + n - 1) > this.m_Length) {
                throw new dbexcpException(86001, new Object[]{"getBytes()"});
            }
            int n3 = 0;
            while (n3 < n) {
                byArray[n3] = this.m_Data[n2 - 1];
                ++n3;
                ++n2;
            }
            return byArray;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public long position(byte[] byArray, long l) throws SQLException {
        try {
            if (byArray == null) {
                throw new dbexcpException(86040, new Object[]{"byte[] pattern", "position(...)", "jdbcBlob", "null"});
            }
            if (byArray.length <= 0) {
                throw new dbexcpException(86041, new Object[]{"byte[] pattern", "position(...)", "jdbcBlob"});
            }
            if (l <= 0L) {
                throw new dbexcpException(86040, new Object[]{"long start", "position(...)", "jdbcBlob", Long.toString(l)});
            }
            if (l > this.m_Length) {
                throw new dbexcpException(86040, new Object[]{"long start", "position(...)", "jdbcBlob", Long.toString(l)});
            }
            byte[] byArray2 = this.getBytes(l, (int)(this.m_Length - (l - 1L)));
            long l2 = jdbcBlob.byteIndexOf(byArray2, byArray);
            if (l2 >= 0L) {
                return l2 + 1L;
            }
            return -1L;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public long position(Blob blob, long l) throws SQLException {
        try {
            if (blob == null) {
                throw new dbexcpException(86040, new Object[]{"Blob pattern", "position(...)", "jdbcBlob", "null"});
            }
            if (l <= 0L) {
                throw new dbexcpException(86040, new Object[]{"long start", "position(...)", "jdbcBlob", Long.toString(l)});
            }
            if (l > this.m_Length) {
                throw new dbexcpException(86040, new Object[]{"long start", "position(...)", "jdbcBlob", Long.toString(l)});
            }
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            byte[] byArray2 = this.getBytes(l, (int)(this.m_Length - (l - 1L)));
            long l2 = jdbcBlob.byteIndexOf(byArray2, byArray);
            if (l2 >= 0L) {
                return l2 + 1L;
            }
            return -1L;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("setBytes");
        return -1;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("setBytes");
        return -1;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("setBinaryStream");
        return null;
    }

    public void truncate(long l) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("truncate");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int byteIndexOf(byte[] byArray, byte[] byArray2) throws SQLException {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length - 1;
        int n5 = byArray2.length - 1;
        byte by = byArray2[n3];
        try {
            try {
                while (true) {
                    boolean bl = false;
                    if (n5 > n4) {
                        throw new dbexcpException(86039, new Object[]{"byte[] Pattern", "jdbcBlob", "position(...)"});
                    }
                    while (true) {
                        if (n2 > n4 || byArray[n2] == by) {
                            if (n2 <= n4) break;
                            return n;
                        }
                        ++n2;
                    }
                    int n6 = n2;
                    while (n3 <= n5) {
                        if (byArray2[n3++] == byArray[n2++]) {
                            bl = true;
                            if (n3 != n5 + 1) continue;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return n6;
                    }
                    if (n3 == n5) {
                        return n6;
                    }
                    n2 = n6 + 1;
                    n3 = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new dbexcpException(86039, new Object[]{"byte[] pattern", "jdbcBlob", "position(...)"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }
}

