/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.crypto;

import com.pointbase.crypto.cryptoBlockCipher;
import com.pointbase.crypto.cryptoUtils;

public class cryptoIdeaCipher
extends cryptoBlockCipher {
    private int[] encryptKeys = new int[52];
    private int[] decryptKeys = new int[52];
    private int[] tempShorts = new int[4];

    public cryptoIdeaCipher(String string) {
        super(16, 8);
        this.setKey(string);
    }

    public cryptoIdeaCipher(byte[] byArray) {
        super(16, 8);
        this.setKey(byArray);
    }

    public void setKey(byte[] byArray) {
        int n = 0;
        while (n < 8) {
            this.encryptKeys[n] = (byArray[2 * n] & 0xFF) << 8 | byArray[2 * n + 1] & 0xFF;
            ++n;
        }
        while (n < 52) {
            this.encryptKeys[n] = (this.encryptKeys[n - 8] << 9 | this.encryptKeys[n - 7] >>> 7) & 0xFFFF;
            ++n;
        }
        n = 0;
        int n2 = 51;
        int n3 = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
        int n4 = -this.encryptKeys[n++];
        int n5 = -this.encryptKeys[n++];
        this.decryptKeys[n2--] = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
        this.decryptKeys[n2--] = n5;
        this.decryptKeys[n2--] = n4;
        this.decryptKeys[n2--] = n3;
        int n6 = 1;
        while (n6 < 8) {
            n3 = this.encryptKeys[n++];
            this.decryptKeys[n2--] = this.encryptKeys[n++];
            this.decryptKeys[n2--] = n3;
            n3 = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
            n4 = -this.encryptKeys[n++];
            n5 = -this.encryptKeys[n++];
            this.decryptKeys[n2--] = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
            this.decryptKeys[n2--] = n4;
            this.decryptKeys[n2--] = n5;
            this.decryptKeys[n2--] = n3;
            ++n6;
        }
        n3 = this.encryptKeys[n++];
        this.decryptKeys[n2--] = this.encryptKeys[n++];
        this.decryptKeys[n2--] = n3;
        n3 = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
        n4 = -this.encryptKeys[n++];
        n5 = -this.encryptKeys[n++];
        this.decryptKeys[n2--] = cryptoIdeaCipher.mulinv(this.encryptKeys[n++]);
        this.decryptKeys[n2--] = n5;
        this.decryptKeys[n2--] = n4;
        this.decryptKeys[n2--] = n3;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        cryptoUtils.squashBytesToShorts(byArray, n, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.encryptKeys);
        cryptoUtils.spreadShortsToBytes(this.tempShorts, 0, byArray2, n2, 4);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        cryptoUtils.squashBytesToShorts(byArray, n, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.decryptKeys);
        cryptoUtils.spreadShortsToBytes(this.tempShorts, 0, byArray2, n2, 4);
    }

    private void idea(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < 8) {
            n = cryptoIdeaCipher.mul(n & 0xFFFF, nArray3[n5++]);
            n2 += nArray3[n5++];
            int n7 = n5++;
            n4 = cryptoIdeaCipher.mul(n4 & 0xFFFF, nArray3[n5++]);
            int n8 = n ^ (n3 += nArray3[n7]);
            n8 = cryptoIdeaCipher.mul(n8 & 0xFFFF, nArray3[n5++]);
            int n9 = n8 + (n2 ^ n4);
            n9 = cryptoIdeaCipher.mul(n9 & 0xFFFF, nArray3[n5++]);
            n8 = n9 + n8;
            n ^= n9;
            n4 ^= n8;
            n8 ^= n2;
            n2 = n3 ^ n9;
            n3 = n8;
            ++n6;
        }
        nArray2[0] = cryptoIdeaCipher.mul(n & 0xFFFF, nArray3[n5++]) & 0xFFFF;
        nArray2[1] = n3 + nArray3[n5++] & 0xFFFF;
        nArray2[2] = n2 + nArray3[n5++] & 0xFFFF;
        nArray2[3] = cryptoIdeaCipher.mul(n4 & 0xFFFF, nArray3[n5++]) & 0xFFFF;
    }

    private static int mul(int n, int n2) {
        int n3 = n * n2;
        if (n3 != 0) {
            int n4;
            int n5;
            return n5 - n4 + ((n5 = n3 & 0xFFFF) < (n4 = n3 >>> 16) ? 1 : 0) & 0xFFFF;
        }
        if (n != 0) {
            return 1 - n & 0xFFFF;
        }
        return 1 - n2 & 0xFFFF;
    }

    private static int mulinv(int n) {
        if (n <= 1) {
            return n;
        }
        int n2 = 1;
        int n3 = 65537 / n;
        int n4 = 65537 % n & 0xFFFF;
        while (n4 != 1) {
            int n5 = n / n4;
            n2 = n2 + n5 * n3 & 0xFFFF;
            if ((n %= n4) == 1) {
                return n2;
            }
            n5 = n4 / n;
            n4 %= n;
            n3 = n3 + n5 * n2 & 0xFFFF;
        }
        return 1 - n3 & 0xFFFF;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 65536) {
            int n2 = cryptoIdeaCipher.mulinv(n);
            int n3 = cryptoIdeaCipher.mul(n, n2);
            if (n3 != 1) {
                System.err.println("mul/mulinv flaw: " + n + " * " + n2 + " = " + n3);
            }
            ++n;
        }
    }
}

