/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.jacorb.notification.servant.StructuredProxyPullConsumerImplMBean;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.StructuredPullSupplier;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class StructuredProxyPullConsumerImpl
extends AbstractProxyConsumer
implements StructuredProxyPullConsumerOperations,
MessageSupplier,
MessageSupplierDelegate,
StructuredProxyPullConsumerImplMBean {
    private StructuredPullSupplier pullSupplier_;
    private final long pollInterval_;
    private final PullMessagesUtility pollUtil_;
    private final PullMessagesOperation pullMessagesOperation_;

    public StructuredProxyPullConsumerImpl(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, SupplierAdmin supplierAdmin) {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, messageFactory, supplierAdmin, offerManager, subscriptionManager);
        this.pollInterval_ = configuration.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        this.pollUtil_ = new PullMessagesUtility(taskProcessor, this);
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
    }

    public ProxyType MyType() {
        return ProxyType.PULL_STRUCTURED;
    }

    public void disconnect_structured_pull_consumer() {
        this.destroy();
    }

    public synchronized void connect_structured_pull_supplier(StructuredPullSupplier structuredPullSupplier) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.pullSupplier_ = structuredPullSupplier;
        this.connectClient(structuredPullSupplier);
        this.startTask();
    }

    protected void connectionSuspended() {
        this.stopTask();
    }

    public void connectionResumed() {
        this.startTask();
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_structured_pull_supplier();
        this.pullSupplier_ = null;
    }

    protected void startTask() {
        this.pollUtil_.startTask(this.pollInterval_);
    }

    protected void stopTask() {
        this.pollUtil_.stopTask();
    }

    public Servant newServant() {
        return new StructuredProxyPullConsumerPOATie(this);
    }

    public MessageSupplierDelegate.PullResult pullMessages() throws Disconnected {
        BooleanHolder booleanHolder = new BooleanHolder();
        booleanHolder.value = false;
        StructuredEvent structuredEvent = this.pullSupplier_.try_pull_structured_event(booleanHolder);
        return new MessageSupplierDelegate.PullResult(structuredEvent, booleanHolder.value);
    }

    public void queueMessages(MessageSupplierDelegate.PullResult pullResult) {
        Message message = this.getMessageFactory().newMessage((StructuredEvent)pullResult.data_, (IProxyConsumer)this);
        this.checkMessageProperties(message);
        this.processMessage(message);
    }

    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }
}

