/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class ClusteredCacheLoader
implements CacheLoader {
    protected long timeout = 10000L;
    protected TreeCache cache;
    private static Log log = LogFactory.getLog((Class)ClusteredCacheLoader.class);

    public void setConfig(Properties props) {
        try {
            this.timeout = Long.valueOf(props.getProperty("timeout"));
        }
        catch (Exception e) {
            log.info((Object)("Using default value for config property 'timeout' - " + this.timeout));
        }
    }

    public void setCache(TreeCache c) {
        this.cache = c;
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        JBCMethodCall call = MethodCallFactory.create(MethodDeclarations.getChildrenNamesMethodLocal, new Object[]{fqn});
        Object resp = this.callRemote(call);
        return (Set)resp;
    }

    private Object callRemote(MethodCall call) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; calling with " + call));
        }
        Vector mbrs = this.cache.getMembers();
        JBCMethodCall clusteredGet = MethodCallFactory.create(MethodDeclarations.clusteredGetMethod, new Object[]{call, Boolean.FALSE});
        List resps = this.cache.callRemoteMethods((List)mbrs, (MethodCall)clusteredGet, 1, true, this.timeout);
        if (resps == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No replies to call " + call + ".  Perhaps we're alone in the cluster?"));
            }
            return null;
        }
        Iterator i = resps.iterator();
        Object result = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Found remote exception among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            List clusteredGetResp = (List)o;
            if (!((Boolean)clusteredGetResp.get(0)).booleanValue()) continue;
            result = clusteredGetResp.get(1);
            break;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("got responses " + resps));
        }
        return result;
    }

    public Map get(Fqn name) throws Exception {
        return this.get0(name);
    }

    protected Map get0(Fqn name) throws Exception {
        JBCMethodCall call = MethodCallFactory.create(MethodDeclarations.getDataMapMethodLocal, new Object[]{name});
        Object resp = this.callRemote(call);
        Map m = (Map)resp;
        if (m != null) {
            m.remove("jboss:internal:uninitialized");
        }
        return m;
    }

    public boolean exists(Fqn name) throws Exception {
        JBCMethodCall call = MethodCallFactory.create(MethodDeclarations.existsMethod, new Object[]{name});
        Object resp = this.callRemote(call);
        return resp != null && (Boolean)resp != false;
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.cache.getInvocationContext().isOriginLocal()) {
            Object[] o = new Object[]{name, key, Boolean.TRUE};
            JBCMethodCall call = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, o);
            return this.callRemote(call);
        }
        log.trace((Object)"Call originated remotely.  Not bothering to try and do a clustered get() for this put().  Returning null.");
        return null;
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    public void put(List modifications) throws Exception {
    }

    public Object remove(Fqn name, Object key) throws Exception {
        Map map = this.get(name);
        return map == null ? null : map.get(key);
    }

    public void remove(Fqn name) throws Exception {
    }

    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    public void commit(Object tx) throws Exception {
    }

    public void rollback(Object tx) {
    }

    public byte[] loadEntireState() throws Exception {
        return new byte[0];
    }

    public void storeEntireState(byte[] state) throws Exception {
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }
}

