/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.hsqldb.ByteArray;
import org.hsqldb.Column;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcStatement;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.build());
    }

    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.build());
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, x ? "TRUE" : "FALSE");
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, x.toString());
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, Column.createString(x));
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + ByteArray.createString(x) + "'");
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setString(parameterIndex, StringConverter.InputStreamToString(x));
        }
    }

    public void setUnicodeStream(int paramIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(paramIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        byte[] b = new byte[length];
        try {
            x.read(b, 0, length);
            x.close();
        }
        catch (IOException e) {
            throw Trace.error(32, e.getMessage());
        }
        this.setBytes(parameterIndex, b);
    }

    public void clearParameters() {
        this.vParameter.removeAllElements();
    }

    public void setObject(int i, Object x, int type, int scale) throws SQLException {
        this.setObject(i, x, type);
    }

    public void setObject(int parameterIndex, Object x, int type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        x = Column.convertObject(x, type);
        this.setObjectInType(parameterIndex, x, type);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        int type = 1111;
        if (x instanceof String) {
            type = 12;
        } else if (x instanceof BigDecimal) {
            type = 2;
        } else if (x instanceof Integer) {
            type = 4;
        } else if (x instanceof Long) {
            type = -5;
        } else if (x instanceof Float) {
            type = 7;
        } else if (x instanceof Double) {
            type = 8;
        } else if (x instanceof byte[]) {
            type = -2;
        } else if (x instanceof Date) {
            type = 91;
        } else if (x instanceof Time) {
            type = 92;
        } else if (x instanceof Timestamp) {
            type = 93;
        } else if (x instanceof Boolean) {
            type = -7;
        } else if (x instanceof Byte) {
            type = -6;
        } else if (x instanceof Short) {
            type = 5;
        }
        this.setObjectInType(parameterIndex, x, type);
    }

    public boolean execute() throws SQLException {
        return super.execute(this.build());
    }

    private void setParameter(int i, String s) {
        if (this.vParameter.size() < i) {
            this.vParameter.setSize(i);
        }
        this.vParameter.setElementAt(s, --i);
    }

    private String getParameter(int i) {
        if (i >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(i);
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        int l = this.sSql.length();
        boolean bSkip = false;
        boolean bSkip2 = false;
        int j = 0;
        while (j < l) {
            char c = this.sSql.charAt(j);
            if (c == '?' && !bSkip && !bSkip2) {
                s.append(this.getParameter(i++));
            } else {
                if (c == '\'' && !bSkip2) {
                    bSkip = !bSkip;
                } else if (c == '\"' && !bSkip) {
                    bSkip2 = !bSkip2;
                }
                s.append(c);
            }
            ++j;
        }
        return s.toString();
    }

    private void setNull(int parameterIndex) {
        this.setParameter(parameterIndex, "NULL");
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }

    public String getString(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public byte getByte(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public short getShort(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public int getInt(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public long getLong(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public float getFloat(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw this.getNotSupported();
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    public Ref getRef(int i) throws SQLException {
        throw this.getNotSupported();
    }

    public Blob getBlob(int i) throws SQLException {
        throw this.getNotSupported();
    }

    public Clob getClob(int i) throws SQLException {
        throw this.getNotSupported();
    }

    public Array getArray(int i) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw this.getNotSupported();
    }

    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw this.getNotSupported();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw this.getNotSupported();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        throw this.getNotSupported();
    }

    public void setClob(int i, Clob x) throws SQLException {
        throw this.getNotSupported();
    }

    public void setArray(int i, Array x) throws SQLException {
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    jdbcPreparedStatement(jdbcConnection c, String s) {
        super(c);
        this.sSql = s;
        this.vParameter = new Vector();
    }

    private void setObjectInType(int parameterIndex, Object x, int type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        switch (type) {
            case -7: {
                this.setBoolean(parameterIndex, (boolean)((Boolean)x));
                break;
            }
            case -6: {
                this.setByte(parameterIndex, (byte)((Byte)x));
                break;
            }
            case 5: {
                this.setShort(parameterIndex, (short)((Short)x));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, (int)((Integer)x));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, (long)((Long)x));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, ((Float)x).floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, (double)((Double)x));
                break;
            }
            case 2: {
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, (String)x);
                break;
            }
            case 91: {
                this.setDate(parameterIndex, (Date)x);
                break;
            }
            case 92: {
                this.setTime(parameterIndex, (Time)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (x instanceof ByteArray) {
                    x = ((ByteArray)x).byteValue();
                }
                this.setBytes(parameterIndex, (byte[])x);
                break;
            }
            case 1111: {
                this.setParameter(parameterIndex, "'" + ByteArray.serializeToString(x) + "'");
                break;
            }
            default: {
                this.setParameter(parameterIndex, x.toString());
            }
        }
    }

    private SQLException getNotSupported() {
        return Trace.error(19);
    }
}

