/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Table;
import org.hsqldb.Trigger;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    static final int INSERT_AFTER = 0;
    static final int DELETE_AFTER = 1;
    static final int UPDATE_AFTER = 2;
    static final int INSERT_BEFORE = 3;
    static final int DELETE_BEFORE = 4;
    static final int UPDATE_BEFORE = 5;
    static final int INSERT_AFTER_ROW = 6;
    static final int DELETE_AFTER_ROW = 7;
    static final int UPDATE_AFTER_ROW = 8;
    static final int INSERT_BEFORE_ROW = 9;
    static final int DELETE_BEFORE_ROW = 10;
    static final int UPDATE_BEFORE_ROW = 11;
    String name;
    String when;
    String operation;
    boolean forEachRow;
    Table table;
    Trigger trig;
    String fire;
    int vectorIndx;
    Object[] rowForTrigger;
    protected boolean busy;
    protected boolean valid;

    public TriggerDef(String sName, String sWhen, String sOper, boolean bForEach, Table pTab, Trigger pTrig, String sFire) {
        this.name = sName.toUpperCase();
        this.when = sWhen.toUpperCase();
        this.operation = sOper.toUpperCase();
        this.forEachRow = bForEach;
        this.table = pTab;
        this.trig = pTrig;
        this.fire = sFire;
        this.vectorIndx = this.SqlToIndex();
        this.busy = false;
        this.valid = this.vectorIndx >= 0;
    }

    public StringBuffer toBuf() {
        StringBuffer a = new StringBuffer("CREATE TRIGGER ");
        a.append(this.name);
        a.append(" ");
        a.append(this.when);
        a.append(" ");
        a.append(this.operation);
        a.append(" ON ");
        a.append(this.table.getName());
        if (this.forEachRow) {
            a.append(" FOR EACH ROW ");
        }
        a.append(" CALL ");
        a.append(this.fire);
        return a;
    }

    public int SqlToIndex() {
        int indx = this.operation.equals("INSERT") ? 0 : (this.operation.equals("DELETE") ? 1 : (this.operation.equals("UPDATE") ? 2 : -1));
        if (this.when.equals("BEFORE")) {
            indx += 3;
        } else if (!this.when.equals("AFTER")) {
            indx = -1;
        }
        if (this.forEachRow) {
            indx += 6;
        }
        return indx;
    }

    public void run() {
        boolean keepGoing = true;
        while (keepGoing) {
            this.pop();
        }
    }

    public synchronized void pop() {
        if (!this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.trig.fire(this.name, this.table.getName(), this.rowForTrigger);
        this.busy = false;
        this.notify();
    }

    public synchronized void push(Object[] row) {
        if (this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.busy = true;
        this.rowForTrigger = row;
        this.notify();
    }

    public static int numTrigs() {
        return 12;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public boolean isValid() {
        return this.valid;
    }
}

