/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Function;
import org.hsqldb.Like;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int VALUELIST = 5;
    static final int ASTERIX = 6;
    static final int FUNCTION = 7;
    static final int NEGATE = 9;
    static final int ADD = 10;
    static final int SUBTRACT = 11;
    static final int MULTIPLY = 12;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int STRINGCONCAT = 105;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    private int iType;
    private Expression eArg;
    private Expression eArg2;
    private Object oData;
    private Hashtable hList;
    private int iDataType;
    private Select sSelect;
    private Function fFunction;
    private char cLikeEscape;
    private String sTable;
    private String sColumn;
    private TableFilter tFilter;
    private int iColumn;
    private String sAlias;
    private boolean bDescending;

    Expression(Function f) {
        this.iType = 7;
        this.fFunction = f;
    }

    Expression(Expression e) {
        this.iType = e.iType;
        this.iDataType = e.iDataType;
        this.eArg = e.eArg;
        this.eArg2 = e.eArg2;
        this.cLikeEscape = e.cLikeEscape;
        this.sSelect = e.sSelect;
        this.fFunction = e.fFunction;
    }

    Expression(Select s) {
        this.iType = 3;
        this.sSelect = s;
    }

    Expression(Vector v) {
        this.iType = 5;
        this.iDataType = 12;
        int len = v.size();
        this.hList = new Hashtable(len);
        int i = 0;
        while (i < len) {
            Object o = v.elementAt(i);
            if (o != null) {
                this.hList.put(o, this);
            }
            ++i;
        }
    }

    Expression(int type, Expression e, Expression e2) {
        this.iType = type;
        this.eArg = e;
        this.eArg2 = e2;
    }

    Expression(String table, String column) {
        this.sTable = table;
        if (column == null) {
            this.iType = 6;
        } else {
            this.iType = 2;
            this.sColumn = column;
        }
    }

    Expression(int datatype, Object o) {
        this.iType = 1;
        this.iDataType = datatype;
        this.oData = o;
    }

    void setLikeEscape(char c) {
        this.cLikeEscape = c;
    }

    void setDataType(int type) {
        this.iDataType = type;
    }

    void setTrue() {
        this.iType = 4;
    }

    boolean isAggregate() {
        return this.iType == 40 || this.iType == 43 || this.iType == 42 || this.iType == 41 || this.iType == 44;
    }

    void setDescending() {
        this.bDescending = true;
    }

    boolean isDescending() {
        return this.bDescending;
    }

    void setAlias(String s) {
        this.sAlias = s;
    }

    String getAlias() {
        if (this.sAlias != null) {
            return this.sAlias;
        }
        if (this.iType == 1) {
            return "";
        }
        if (this.iType == 2) {
            return this.sColumn;
        }
        return "";
    }

    int getType() {
        return this.iType;
    }

    int getColumnNr() {
        return this.iColumn;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tFilter;
    }

    void checkResolved() throws SQLException {
        Trace.check(this.iType != 2 || this.tFilter != null, 27, this.sColumn);
        if (this.eArg != null) {
            this.eArg.checkResolved();
        }
        if (this.eArg2 != null) {
            this.eArg2.checkResolved();
        }
        if (this.sSelect != null) {
            this.sSelect.checkResolved();
        }
        if (this.fFunction != null) {
            this.fFunction.checkResolved();
        }
    }

    void resolve(TableFilter f) throws SQLException {
        int i;
        if (f != null && this.iType == 2 && (this.sTable == null || f.getName().equals(this.sTable)) && (i = f.getTable().searchColumn(this.sColumn)) != -1) {
            Trace.check(this.tFilter == null || this.tFilter == f, 27, this.sColumn);
            this.tFilter = f;
            this.iColumn = i;
            this.sTable = f.getName();
            this.iDataType = f.getTable().getColumnType(i);
        }
        if (this.eArg != null) {
            this.eArg.resolve(f);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolve(f);
        }
        if (this.sSelect != null) {
            this.sSelect.resolve(f, false);
            this.sSelect.resolve();
        }
        if (this.fFunction != null) {
            this.fFunction.resolve(f);
        }
        if (this.iDataType != 0) {
            return;
        }
        switch (this.iType) {
            case 7: {
                this.iDataType = this.fFunction.getReturnType();
                break;
            }
            case 3: {
                this.iDataType = this.sSelect.eColumn[0].iDataType;
                break;
            }
            case 9: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 15: {
                this.iDataType = 12;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.iDataType = -7;
                break;
            }
            case 40: {
                this.iDataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 61: {
                break;
            }
            case 60: 
            case 62: {
                this.iDataType = this.eArg2.iDataType;
            }
        }
    }

    boolean isResolved() {
        if (this.iType == 1) {
            return true;
        }
        if (this.iType == 2) {
            return this.tFilter != null;
        }
        return false;
    }

    static boolean isCompare(int i) {
        switch (i) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.iType == 6) {
            return this.sTable;
        }
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sTable;
            }
            return this.tFilter.getTable().getName();
        }
        return "";
    }

    String getColumnName() {
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sColumn;
            }
            return this.tFilter.getTable().getColumnName(this.iColumn);
        }
        return this.getAlias();
    }

    void swapCondition() throws SQLException {
        int i = 21;
        switch (this.iType) {
            case 22: {
                i = 25;
                break;
            }
            case 25: {
                i = 22;
                break;
            }
            case 24: {
                i = 23;
                break;
            }
            case 23: {
                i = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.assert(false, "Expression.swapCondition");
            }
        }
        this.iType = i;
        Expression e = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = e;
    }

    Object getValue(int type) throws SQLException {
        Object o = this.getValue();
        if (o == null || this.iDataType == type) {
            return o;
        }
        String s = Column.convertObject(o);
        return Column.convertString(s, type);
    }

    int getDataType() {
        return this.iDataType;
    }

    Object getValue() throws SQLException {
        switch (this.iType) {
            case 1: {
                return this.oData;
            }
            case 2: {
                try {
                    return this.tFilter.oCurrentData[this.iColumn];
                }
                catch (NullPointerException e) {
                    throw Trace.error(27, this.sColumn);
                }
            }
            case 7: {
                return this.fFunction.getValue();
            }
            case 3: {
                return this.sSelect.getValue(this.iDataType);
            }
            case 9: {
                return Column.negate(this.eArg.getValue(this.iDataType), this.iDataType);
            }
            case 40: {
                if (this.eArg.iType == 6 || this.eArg.getValue() != null) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.eArg.getValue();
            }
            case 31: {
                return new Boolean(this.test());
            }
            case 61: {
                return this.eArg.getValue(this.iDataType);
            }
            case 62: {
                if (this.eArg.test()) {
                    return this.eArg2.eArg.getValue();
                }
                return this.eArg2.eArg2.getValue();
            }
        }
        Object a = null;
        Object b = null;
        if (this.eArg != null) {
            a = this.eArg.getValue(this.iDataType);
        }
        if (this.eArg2 != null) {
            b = this.eArg2.getValue(this.iDataType);
        }
        switch (this.iType) {
            case 10: {
                return Column.add(a, b, this.iDataType);
            }
            case 11: {
                return Column.subtract(a, b, this.iDataType);
            }
            case 12: {
                return Column.multiply(a, b, this.iDataType);
            }
            case 14: {
                return Column.divide(a, b, this.iDataType);
            }
            case 15: {
                return Column.concat(a, b);
            }
            case 60: {
                return a == null ? b : a;
            }
        }
        return new Boolean(this.test());
    }

    private boolean testValueList(Object o, int datatype) throws SQLException {
        if (this.iType == 5) {
            if (datatype != this.iDataType) {
                o = Column.convertObject(o, this.iDataType);
            }
            return this.hList.containsKey(o);
        }
        if (this.iType == 3) {
            Result r = this.sSelect.getResult(0);
            Record n = r.rRoot;
            int type = r.iType[0];
            if (datatype != type) {
                o = Column.convertObject(o, type);
            }
            while (n != null) {
                Object o2 = n.data[0];
                if (o2 != null && o2.equals(o)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }
        throw Trace.error(15);
    }

    boolean test() throws SQLException {
        switch (this.iType) {
            case 4: {
                return true;
            }
            case 20: {
                Trace.assert(this.eArg2 == null, "Expression.test");
                return !this.eArg.test();
            }
            case 28: {
                return this.eArg.test() && this.eArg2.test();
            }
            case 29: {
                return this.eArg.test() || this.eArg2.test();
            }
            case 27: {
                String s = (String)this.eArg2.getValue(12);
                int type = this.eArg.iDataType;
                Like l = new Like(s, this.cLikeEscape, type == 100);
                String c = (String)this.eArg.getValue(12);
                return l.compare(c);
            }
            case 30: {
                return this.eArg2.testValueList(this.eArg.getValue(), this.eArg.iDataType);
            }
            case 31: {
                Result r = this.eArg.sSelect.getResult(1);
                return r.rRoot != null;
            }
        }
        Trace.check(this.eArg != null, 38);
        Object o = this.eArg.getValue();
        int type = this.eArg.iDataType;
        Trace.check(this.eArg2 != null, 38);
        Object o2 = this.eArg2.getValue(type);
        int result = Column.compare(o, o2, type);
        switch (this.iType) {
            case 21: {
                return result == 0;
            }
            case 23: {
                return result > 0;
            }
            case 22: {
                return result >= 0;
            }
            case 25: {
                return result <= 0;
            }
            case 24: {
                return result < 0;
            }
            case 26: {
                return result != 0;
            }
        }
        Trace.assert(false, "Expression.test2");
        return false;
    }
}

