/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Index;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Constraint {
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private int iType;
    private int iLen;
    private Table tMain;
    private int[] iColMain;
    private Index iMain;
    private Object[] oMain;
    private Table tRef;
    private int[] iColRef;
    private Index iRef;
    private Object[] oRef;

    Constraint(int type, Table t, int[] col) {
        this.iType = type;
        this.tMain = t;
        this.iColMain = col;
        this.iLen = col.length;
    }

    Constraint(int type, Table main, Table ref, int[] cmain, int[] cref) throws SQLException {
        this.iType = type;
        this.tMain = main;
        this.tRef = ref;
        this.iColMain = cmain;
        this.iColRef = cref;
        this.iLen = cmain.length;
        this.oMain = this.tMain.getNewRow();
        this.oRef = this.tRef.getNewRow();
        this.iMain = this.tMain.getIndexForColumns(cmain);
        this.iRef = this.tRef.getIndexForColumns(cref);
    }

    int getType() {
        return this.iType;
    }

    Table getMain() {
        return this.tMain;
    }

    Table getRef() {
        return this.tRef;
    }

    int[] getMainColumns() {
        return this.iColMain;
    }

    int[] getRefColumns() {
        return this.iColRef;
    }

    void replaceTable(Table old, Table n) throws SQLException {
        if (old == this.tMain) {
            this.tMain = n;
        } else if (old == this.tRef) {
            this.tRef = n;
        } else {
            Trace.assert(false, "could not replace");
        }
    }

    void checkInsert(Object[] row) throws SQLException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        int i = 0;
        while (i < this.iLen) {
            Object o = row[this.iColRef[i]];
            if (o == null) {
                return;
            }
            this.oMain[this.iColMain[i]] = o;
            ++i;
        }
        Trace.check(this.iMain.find(this.oMain) != null, 7);
    }

    void checkDelete(Object[] row) throws SQLException {
        if (this.iType == 0 || this.iType == 2) {
            return;
        }
        int i = 0;
        while (i < this.iLen) {
            Object o = row[this.iColMain[i]];
            if (o == null) {
                return;
            }
            this.oRef[this.iColRef[i]] = o;
            ++i;
        }
        Trace.check(this.iRef.find(this.oRef) == null, 7);
    }

    void checkUpdate(int[] col, Result deleted, Result inserted) throws SQLException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!this.isAffected(col, this.iColMain, this.iLen)) {
                    return;
                }
                Record r = deleted.rRoot;
                while (r != null) {
                    if (this.iMain.find(r.data) == null) {
                        this.checkDelete(r.data);
                    }
                    r = r.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!this.isAffected(col, this.iColMain, this.iLen)) {
                return;
            }
            Record r = inserted.rRoot;
            while (r != null) {
                this.checkInsert(r.data);
                r = r.next;
            }
        }
    }

    private boolean isAffected(int[] col, int[] col2, int len) {
        if (this.iType == 2) {
            return false;
        }
        int i = 0;
        while (i < col.length) {
            int c = col[i];
            int j = 0;
            while (j < len) {
                if (c == col2[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

