/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.cmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jboss.wsf.spi.tools.WSContractProvider;

public class WSProvide {
    private boolean generateSource = false;
    private boolean generateWsdl = false;
    private boolean quiet = false;
    private boolean showTraces = false;
    private boolean loadProvider = false;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private File outputDir = new File("output");
    private File resourceDir = null;
    private File sourceDir = null;
    public static String PROGRAM_NAME = System.getProperty("program.name", WSProvide.class.getSimpleName());

    public static void main(String[] stringArray) {
        WSProvide wSProvide = new WSProvide();
        String string = wSProvide.parseArguments(stringArray);
        System.exit(wSProvide.generate(string));
    }

    private String parseArguments(String[] stringArray) {
        int n;
        int n2;
        String string = "hwko:r:s:c:qtl";
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("wsdl", 0, null, 119), new LongOpt("keep", 0, null, 107), new LongOpt("output", 1, null, 111), new LongOpt("resource", 1, null, 114), new LongOpt("source", 1, null, 115), new LongOpt("classpath", 1, null, 99), new LongOpt("quiet", 0, null, 113), new LongOpt("show-traces", 0, null, 116), new LongOpt("load-provider", 0, null, 108)};
        Getopt getopt = new Getopt(PROGRAM_NAME, stringArray, string, longOptArray);
        while ((n2 = getopt.getopt()) != -1) {
            switch (n2) {
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 114: {
                    this.resourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 119: {
                    this.generateWsdl = true;
                    break;
                }
                case 116: {
                    this.showTraces = true;
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 99: {
                    this.processClassPath(getopt.getOptarg());
                    break;
                }
                case 108: {
                    this.loadProvider = true;
                    break;
                }
                case 104: {
                    WSProvide.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        if (this.loadProvider) {
            WSContractProvider wSContractProvider = WSContractProvider.newInstance(this.loader);
            System.out.println("WSContractProvider instance: " + wSContractProvider.getClass().getCanonicalName());
            System.exit(0);
        }
        if ((n = getopt.getOptind()) >= stringArray.length) {
            System.err.println("Error: endpoint implementation was not specified!");
            WSProvide.printHelp();
            System.exit(1);
        }
        return stringArray[n];
    }

    private int generate(String string) {
        try {
            this.loader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error: Could not load class [" + string + "]. Did you specify a valid --classpath?");
            return 1;
        }
        WSContractProvider wSContractProvider = WSContractProvider.newInstance(this.loader);
        wSContractProvider.setGenerateWsdl(this.generateWsdl);
        wSContractProvider.setGenerateSource(this.generateSource);
        wSContractProvider.setOutputDirectory(this.outputDir);
        if (this.resourceDir != null) {
            wSContractProvider.setResourceDirectory(this.resourceDir);
        }
        if (this.sourceDir != null) {
            wSContractProvider.setSourceDirectory(this.sourceDir);
        }
        if (!this.quiet) {
            wSContractProvider.setMessageStream(System.out);
        }
        try {
            wSContractProvider.provide(string);
            return 0;
        }
        catch (Throwable throwable) {
            System.err.println("Error: Could not generate. (use --show-traces to see full traces)");
            if (!this.showTraces) {
                String string2 = throwable.getMessage();
                if (string2 == null) {
                    string2 = throwable.getClass().getSimpleName();
                }
                System.err.println("Error: " + string2);
            } else {
                throwable.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private void processClassPath(String string) {
        String[] stringArray = string.split(File.pathSeparator);
        ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
        for (String string2 : stringArray) {
            try {
                arrayList.add(new File(string2).toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: a classpath entry was malformed: " + string2);
            }
        }
        this.loader = new URLClassLoader(arrayList.toArray(new URL[0]), this.loader);
    }

    private static void printHelp() {
        PrintStream printStream = System.out;
        printStream.println("WSProvideTask generates portable JAX-WS artifacts for an endpoint implementation.\n");
        printStream.println("usage: " + PROGRAM_NAME + " [options] <endpoint class name>\n");
        printStream.println("options: ");
        printStream.println("    -h, --help                  Show this help message");
        printStream.println("    -k, --keep                  Keep/Generate Java source");
        printStream.println("    -w, --wsdl                  Enable WSDL file generation");
        printStream.println("    -c, --classpath=<path>      The classpath that contains the endpoint");
        printStream.println("    -o, --output=<directory>    The directory to put generated artifacts");
        printStream.println("    -r, --resource=<directory>  The directory to put resource artifacts");
        printStream.println("    -s, --source=<directory>    The directory to put Java source");
        printStream.println("    -q, --quiet                 Be somewhat more quiet");
        printStream.println("    -t, --show-traces           Show full exception stack traces");
        printStream.println("    -l, --load-provider         Load the provider and exit (debug utility)");
        printStream.flush();
    }
}

