/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.cmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.spi.tools.WSContractConsumer;

public class WSConsume {
    private List<File> bindingFiles = new ArrayList<File>();
    private boolean generateSource = false;
    private File catalog = null;
    private String targetPackage = null;
    private String wsdlLocation = null;
    private boolean quiet = false;
    private boolean verbose = false;
    private boolean loadConsumer = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String target = null;
    public static String PROGRAM_NAME = System.getProperty("program.name", WSConsume.class.getName());

    public static void main(String[] stringArray) {
        WSConsume wSConsume = new WSConsume();
        URL uRL = wSConsume.parseArguments(stringArray);
        System.exit(wSConsume.importServices(uRL));
    }

    private URL parseArguments(String[] stringArray) {
        int n;
        int n2;
        String string = "b:c:p:w:o:s:t:khqvl";
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("binding", 1, null, 98), new LongOpt("catalog", 1, null, 99), new LongOpt("package", 1, null, 112), new LongOpt("wsdlLocation", 1, null, 119), new LongOpt("output", 1, null, 111), new LongOpt("source", 1, null, 115), new LongOpt("target", 1, null, 116), new LongOpt("keep", 0, null, 107), new LongOpt("help", 0, null, 104), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 118), new LongOpt("load-consumer", 0, null, 108)};
        Getopt getopt = new Getopt(PROGRAM_NAME, stringArray, string, longOptArray);
        while ((n2 = getopt.getopt()) != -1) {
            switch (n2) {
                case 98: {
                    this.bindingFiles.add(new File(getopt.getOptarg()));
                    break;
                }
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 99: {
                    this.catalog = new File(getopt.getOptarg());
                    break;
                }
                case 112: {
                    this.targetPackage = getopt.getOptarg();
                    break;
                }
                case 119: {
                    this.wsdlLocation = getopt.getOptarg();
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 116: {
                    this.target = getopt.getOptarg();
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 118: {
                    this.verbose = true;
                    break;
                }
                case 108: {
                    this.loadConsumer = true;
                    break;
                }
                case 104: {
                    WSConsume.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        if (this.loadConsumer) {
            WSContractConsumer wSContractConsumer = WSContractConsumer.newInstance();
            System.out.println("WSContractConsumer instance: " + wSContractConsumer.getClass().getCanonicalName());
            System.exit(0);
        }
        if ((n = getopt.getOptind()) >= stringArray.length) {
            System.err.println("Error: WSDL URL was not specified!");
            WSConsume.printHelp();
            System.exit(1);
        }
        URL uRL = null;
        try {
            try {
                uRL = new URL(stringArray[n]);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(stringArray[n]);
                uRL = file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Invalid URI: " + stringArray[n]);
            System.exit(1);
        }
        return uRL;
    }

    private int importServices(URL uRL) {
        WSContractConsumer wSContractConsumer = WSContractConsumer.newInstance();
        wSContractConsumer.setGenerateSource(this.generateSource);
        wSContractConsumer.setOutputDirectory(this.outputDir);
        if (this.sourceDir != null) {
            wSContractConsumer.setSourceDirectory(this.sourceDir);
        }
        if (!this.quiet) {
            wSContractConsumer.setMessageStream(System.out);
        }
        if (this.catalog != null) {
            wSContractConsumer.setCatalog(this.catalog);
        }
        if (this.targetPackage != null) {
            wSContractConsumer.setTargetPackage(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            wSContractConsumer.setWsdlLocation(this.wsdlLocation);
        }
        if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
            wSContractConsumer.setBindingFiles(this.bindingFiles);
        }
        if (this.target != null) {
            wSContractConsumer.setTarget(this.target);
        }
        try {
            wSContractConsumer.consume(uRL);
            return 0;
        }
        catch (Throwable throwable) {
            System.err.println("Error: Could not import. (use --verbose to see full traces)");
            if (!this.verbose) {
                String string = throwable.getMessage();
                if (string == null) {
                    string = throwable.getClass().getSimpleName();
                }
                System.err.println("Error: " + string);
            } else {
                throwable.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private static void printHelp() {
        PrintStream printStream = System.out;
        printStream.println("WSConsumeTask is a cmd line tool that generates portable JAX-WS artifacts from a WSDL file.\n");
        printStream.println("usage: " + PROGRAM_NAME + " [options] <wsdl-url>\n");
        printStream.println("options: ");
        printStream.println("    -h, --help                  Show this help message");
        printStream.println("    -b, --binding=<file>        One or more JAX-WS or JAXB binding files ");
        printStream.println("    -k, --keep                  Keep/Generate Java source");
        printStream.println("    -c  --catalog=<file>        Oasis XML Catalog file for entity resolution");
        printStream.println("    -p  --package=<name>        The target package for generated source");
        printStream.println("    -w  --wsdlLocation=<loc>    Value to use for @WebService.wsdlLocation");
        printStream.println("    -o, --output=<directory>    The directory to put generated artifacts");
        printStream.println("    -s, --source=<directory>    The directory to put Java source");
        printStream.println("    -t, --target=<2.0|2.1>      The JAX-WS specification target");
        printStream.println("    -q, --quiet                 Be somewhat more quiet");
        printStream.println("    -v, --verbose               Show full exception stack traces");
        printStream.println("    -l, --load-consumer         Load the consumer and exit (debug utility)");
        printStream.flush();
    }
}

