/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParserFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedServiceRefMetaData
extends ServiceRefMetaData {
    private static Logger log = Logger.getLogger(UnifiedServiceRefMetaData.class);
    private UnifiedVirtualFile vfsRoot;
    private String serviceRefName;
    private String serviceInterface;
    private String serviceRefType;
    private String wsdlFile;
    private String mappingFile;
    private QName serviceQName;
    private List<UnifiedPortComponentRefMetaData> portComponentRefs = new ArrayList<UnifiedPortComponentRefMetaData>();
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
    private UnifiedHandlerChainsMetaData handlerChains;
    private String serviceImplClass;
    private String configName;
    private String configFile;
    private String wsdlOverride;
    private String handlerChain;
    private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList<UnifiedCallPropertyMetaData>();
    private transient Object anElement;
    private transient boolean processed;

    public UnifiedServiceRefMetaData(UnifiedVirtualFile unifiedVirtualFile) {
        this.vfsRoot = unifiedVirtualFile;
    }

    public UnifiedServiceRefMetaData() {
    }

    @Override
    public void merge(ServiceRefMetaData serviceRefMetaData) {
        UnifiedServiceRefMetaData unifiedServiceRefMetaData = (UnifiedServiceRefMetaData)serviceRefMetaData;
        this.serviceImplClass = unifiedServiceRefMetaData.serviceImplClass;
        this.configName = unifiedServiceRefMetaData.configName;
        this.configFile = unifiedServiceRefMetaData.configFile;
        this.wsdlOverride = unifiedServiceRefMetaData.wsdlOverride;
        this.handlerChain = unifiedServiceRefMetaData.handlerChain;
        this.callProperties = unifiedServiceRefMetaData.callProperties;
        if (this.serviceQName == null && unifiedServiceRefMetaData.serviceQName != null) {
            this.serviceQName = unifiedServiceRefMetaData.serviceQName;
        }
        for (UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData : unifiedServiceRefMetaData.getPortComponentRefs()) {
            QName qName;
            String string = unifiedPortComponentRefMetaData.getServiceEndpointInterface();
            UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData2 = this.getPortComponentRef(string, qName = unifiedPortComponentRefMetaData.getPortQName());
            if (unifiedPortComponentRefMetaData2 == null) {
                log.warn((Object)("Cannot find port component ref: [sei=" + string + ",port=" + qName + "]"));
                if (string != null) {
                    this.addPortComponentRef(unifiedPortComponentRefMetaData);
                } else {
                    log.warn((Object)("Ingore port component ref without SEI declaration: " + unifiedPortComponentRefMetaData));
                }
                unifiedPortComponentRefMetaData2 = unifiedPortComponentRefMetaData;
            }
            unifiedPortComponentRefMetaData2.merge(unifiedPortComponentRefMetaData);
        }
    }

    public UnifiedVirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public void setVfsRoot(UnifiedVirtualFile unifiedVirtualFile) {
        this.vfsRoot = unifiedVirtualFile;
    }

    @Override
    public String getServiceRefName() {
        return this.serviceRefName;
    }

    @Override
    public void setServiceRefName(String string) {
        this.serviceRefName = string;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String string) {
        this.mappingFile = string;
    }

    public URL getMappingLocation() {
        URL uRL = null;
        if (this.mappingFile != null) {
            try {
                uRL = this.vfsRoot.findChild(this.mappingFile).toURL();
            }
            catch (Exception exception) {
                throw new WebServiceException("Cannot find jaxrcp-mapping-file: " + this.mappingFile, (Throwable)exception);
            }
        }
        return uRL;
    }

    public Collection<UnifiedPortComponentRefMetaData> getPortComponentRefs() {
        return this.portComponentRefs;
    }

    public UnifiedPortComponentRefMetaData getPortComponentRef(String string, QName qName) {
        UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData = null;
        for (UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData2 : this.portComponentRefs) {
            if (!unifiedPortComponentRefMetaData2.matches(string, qName)) continue;
            if (unifiedPortComponentRefMetaData != null) {
                log.warn((Object)("Multiple matching port component ref: [sei=" + string + ",port=" + qName + "]"));
            }
            unifiedPortComponentRefMetaData = unifiedPortComponentRefMetaData2;
        }
        return unifiedPortComponentRefMetaData;
    }

    public void addPortComponentRef(UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData) {
        this.portComponentRefs.add(unifiedPortComponentRefMetaData);
    }

    public List<UnifiedHandlerMetaData> getHandlers() {
        return this.handlers;
    }

    public void addHandler(UnifiedHandlerMetaData unifiedHandlerMetaData) {
        this.handlers.add(unifiedHandlerMetaData);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String string) {
        this.serviceInterface = string;
    }

    public String getServiceImplClass() {
        return this.serviceImplClass;
    }

    public void setServiceImplClass(String string) {
        this.serviceImplClass = string;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public void setServiceQName(QName qName) {
        this.serviceQName = qName;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(String string) {
        this.serviceRefType = string;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String string) {
        this.wsdlFile = string;
    }

    public URL getWsdlLocation() {
        URL uRL = null;
        if (this.wsdlOverride != null) {
            try {
                uRL = new URL(this.wsdlOverride);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = this.vfsRoot.findChild(this.wsdlOverride).toURL();
                }
                catch (Exception exception) {
                    throw new WebServiceException("Cannot find wsdl-override: " + this.wsdlOverride, (Throwable)exception);
                }
            }
        }
        if (uRL == null && this.wsdlFile != null) {
            try {
                uRL = this.vfsRoot.findChild(this.wsdlFile).toURL();
            }
            catch (Exception exception) {
                throw new WebServiceException("Cannot find wsdl-file: " + this.wsdlFile, (Throwable)exception);
            }
        }
        return uRL;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String string) {
        this.configName = string;
    }

    public String getWsdlOverride() {
        return this.wsdlOverride;
    }

    public void setWsdlOverride(String string) {
        this.wsdlOverride = string;
    }

    public List<UnifiedCallPropertyMetaData> getCallProperties() {
        return this.callProperties;
    }

    public void setCallProperties(List<UnifiedCallPropertyMetaData> list) {
        this.callProperties = list;
    }

    public void addCallProperty(UnifiedCallPropertyMetaData unifiedCallPropertyMetaData) {
        this.callProperties.add(unifiedCallPropertyMetaData);
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData) {
        this.handlerChains = unifiedHandlerChainsMetaData;
    }

    public String getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(String string) {
        this.handlerChain = string;
    }

    @Override
    public Object getAnnotatedElement() {
        return this.anElement;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    @Override
    public void setAnnotatedElement(Object object) {
        this.anElement = object;
    }

    @Override
    public void importStandardXml(Element element) {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory serviceRefMetaDataParserFactory = sPIProvider.getSPI(ServiceRefMetaDataParserFactory.class);
        serviceRefMetaDataParserFactory.getServiceRefMetaDataParser().importStandardXml(element, this);
    }

    @Override
    public void importJBossXml(Element element) {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory serviceRefMetaDataParserFactory = sPIProvider.getSPI(ServiceRefMetaDataParserFactory.class);
        serviceRefMetaDataParserFactory.getServiceRefMetaDataParser().importJBossXml(element, this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nUnifiedServiceRef");
        stringBuilder.append("\n serviceRefName=" + this.serviceRefName);
        stringBuilder.append("\n serviceInterface=" + this.serviceInterface);
        stringBuilder.append("\n serviceImplClass=" + this.serviceImplClass);
        stringBuilder.append("\n serviceRefType=" + this.serviceRefType);
        stringBuilder.append("\n serviceQName=" + this.serviceQName);
        stringBuilder.append("\n anElement=" + this.anElement);
        stringBuilder.append("\n wsdlFile=" + this.wsdlFile);
        stringBuilder.append("\n wsdlOverride=" + this.wsdlOverride);
        stringBuilder.append("\n mappingFile=" + this.mappingFile);
        stringBuilder.append("\n configName=" + this.configName);
        stringBuilder.append("\n configFile=" + this.configFile);
        stringBuilder.append("\n callProperties=" + this.callProperties);
        stringBuilder.append("\n processed=" + this.processed);
        stringBuilder.append("\n handlerChains=" + this.handlerChains);
        stringBuilder.append("\n handlerChain=" + this.handlerChain);
        for (UnifiedHandlerMetaData serviceRefElement : this.handlers) {
            stringBuilder.append(serviceRefElement.toString());
        }
        for (UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData : this.portComponentRefs) {
            stringBuilder.append(unifiedPortComponentRefMetaData.toString());
        }
        return stringBuilder.toString();
    }
}

