/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParserFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedPortComponentRefMetaData
extends ServiceRefElement {
    private UnifiedServiceRefMetaData serviceRefMetaData;
    private String serviceEndpointInterface;
    private Boolean enableMTOM = Boolean.FALSE;
    private String portComponentLink;
    private QName portQName;
    private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList<UnifiedCallPropertyMetaData>();
    private List<UnifiedStubPropertyMetaData> stubProperties = new ArrayList<UnifiedStubPropertyMetaData>();
    private String configName;
    private String configFile;

    public UnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData unifiedServiceRefMetaData) {
        this.serviceRefMetaData = unifiedServiceRefMetaData;
    }

    public void merge(UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData) {
        this.portQName = unifiedPortComponentRefMetaData.portQName;
        this.configName = unifiedPortComponentRefMetaData.configName;
        this.configFile = unifiedPortComponentRefMetaData.configFile;
        this.callProperties = unifiedPortComponentRefMetaData.callProperties;
        this.stubProperties = unifiedPortComponentRefMetaData.stubProperties;
    }

    public UnifiedServiceRefMetaData getServiceRefMetaData() {
        return this.serviceRefMetaData;
    }

    public Boolean getEnableMTOM() {
        return this.enableMTOM;
    }

    public void setEnableMTOM(Boolean bl) {
        this.enableMTOM = bl;
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(String string) {
        this.portComponentLink = string;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String string) {
        this.serviceEndpointInterface = string;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public void setPortQName(QName qName) {
        this.portQName = qName;
    }

    public List<UnifiedCallPropertyMetaData> getCallProperties() {
        return this.callProperties;
    }

    public void setCallProperties(List<UnifiedCallPropertyMetaData> list) {
        this.callProperties = list;
    }

    public void addCallProperty(UnifiedCallPropertyMetaData unifiedCallPropertyMetaData) {
        this.callProperties.add(unifiedCallPropertyMetaData);
    }

    public List<UnifiedStubPropertyMetaData> getStubProperties() {
        return this.stubProperties;
    }

    public void setStubProperties(List<UnifiedStubPropertyMetaData> list) {
        this.stubProperties = list;
    }

    public void addStubProperty(UnifiedStubPropertyMetaData unifiedStubPropertyMetaData) {
        this.stubProperties.add(unifiedStubPropertyMetaData);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String string) {
        this.configName = string;
    }

    public void importStandardXml(Element element) {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory serviceRefMetaDataParserFactory = sPIProvider.getSPI(ServiceRefMetaDataParserFactory.class);
        serviceRefMetaDataParserFactory.getServiceRefMetaDataParser().importStandardXml(element, this);
    }

    public void importJBossXml(Element element) {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory serviceRefMetaDataParserFactory = sPIProvider.getSPI(ServiceRefMetaDataParserFactory.class);
        serviceRefMetaDataParserFactory.getServiceRefMetaDataParser().importJBossXml(element, this);
    }

    public boolean matches(String string, QName qName) {
        if (string == null && qName == null) {
            throw new IllegalArgumentException("Cannot match against seiName=null && portName=null.");
        }
        boolean bl = false;
        if (qName != null) {
            bl = qName.equals(this.getPortQName());
        }
        if (!bl) {
            bl = string.equals(this.getServiceEndpointInterface());
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nUnifiedPortComponentRef");
        stringBuilder.append("\n serviceEndpointInterface=" + this.serviceEndpointInterface);
        stringBuilder.append("\n portQName=" + this.portQName);
        stringBuilder.append("\n enableMTOM=" + this.enableMTOM);
        stringBuilder.append("\n portComponentLink=" + this.portComponentLink);
        stringBuilder.append("\n callProperties=" + this.callProperties);
        stringBuilder.append("\n stubProperties=" + this.stubProperties);
        stringBuilder.append("\n configName=" + this.configName);
        stringBuilder.append("\n configFile=" + this.configFile);
        return stringBuilder.toString();
    }
}

