/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeamUtilities {
    private static final Log log = LogFactory.getLog((Class)SeamUtilities.class);
    private static Class seamManagerClass;
    private static Class[] seamClassArgs;
    private static Object[] seamInstanceArgs;
    private static Class[] seamGetEncodeMethodArgs;
    private static Object[] seamEncodeMethodArgs;
    private static Object[] seamMethodNoArgs;
    private static Method seamConversationIdMethodInstance;
    private static Method seamLongRunningMethodInstance;
    private static Method seamAppendConversationMethodInstance;
    private static Method seamInstanceMethod;
    private static Method seamPageContextGetPrefixInstance;
    private static Method seamConversationIdParameterMethod;
    private static Method seamBeforeRedirectMethodInstance;
    private static Object pageContextInstance;
    private static String versionedUrlParam;
    private static String conversationIdParameter;

    public static boolean isSeamEnvironment() {
        return seamManagerClass != null;
    }

    public static String encodeSeamConversationId(String uri) {
        int spos;
        if (!SeamUtilities.isSeamEnvironment()) {
            return uri;
        }
        String cleanedUrl = uri;
        if (versionedUrlParam == null) {
            SeamUtilities.getConversationIdParameterName();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SeamConversationURLParam: " + versionedUrlParam));
        }
        if ((spos = uri.indexOf(versionedUrlParam)) > 0) {
            cleanedUrl = uri.substring(0, spos);
            int epos = uri.indexOf("?", spos + 1);
            if (epos > 0) {
                cleanedUrl = cleanedUrl + uri.substring(epos);
            }
        }
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamInstanceArgs);
            if (seamAppendConversationMethodInstance != null) {
                SeamUtilities.seamEncodeMethodArgs[0] = cleanedUrl;
                cleanedUrl = (String)seamAppendConversationMethodInstance.invoke(seamManagerInstance, seamEncodeMethodArgs);
                seamBeforeRedirectMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Enabled redirect from: " + uri + ", to: " + cleanedUrl));
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.error((Object)"Exception encoding seam conversationId: ", (Throwable)e);
        }
        return cleanedUrl;
    }

    public static String getSeamConversationId() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdMethodInstance != null) {
                String conversationId = (String)seamConversationIdMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                Boolean is = (Boolean)seamLongRunningMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                if (is.booleanValue()) {
                    returnVal = conversationId;
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.error((Object)"Exception determining Seam ConversationId: ", (Throwable)e);
        }
        return returnVal;
    }

    public static String getPageContextKey() {
        String returnVal = "";
        if (!SeamUtilities.isSeamEnvironment()) {
            return returnVal;
        }
        try {
            if (seamConversationIdMethodInstance != null) {
                returnVal = (String)seamPageContextGetPrefixInstance.invoke(pageContextInstance, seamMethodNoArgs);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception fetching Page from ScopeType: ", (Throwable)e);
        }
        return returnVal;
    }

    private static void loadSeamEnvironment() {
        String versionId = "1.0.1";
        try {
            seamManagerClass = Class.forName("org.jboss.seam.core.Manager");
            Class<?> seamScopeTypeClass = Class.forName("org.jboss.seam.ScopeType");
            seamInstanceMethod = seamManagerClass.getMethod("instance", seamClassArgs);
            Field fieldInstance = seamScopeTypeClass.getField("PAGE");
            pageContextInstance = fieldInstance.get(seamScopeTypeClass);
            seamPageContextGetPrefixInstance = seamScopeTypeClass.getMethod("getPrefix", seamClassArgs);
            seamAppendConversationMethodInstance = seamManagerClass.getMethod("encodeConversationId", seamGetEncodeMethodArgs);
            seamConversationIdMethodInstance = seamManagerClass.getMethod("getCurrentConversationId", seamClassArgs);
            seamLongRunningMethodInstance = seamManagerClass.getMethod("isLongRunningConversation", seamClassArgs);
            seamConversationIdParameterMethod = seamManagerClass.getMethod("getConversationIdParameter", seamClassArgs);
            seamBeforeRedirectMethodInstance = seamManagerClass.getMethod("beforeRedirect", seamClassArgs);
            Class.forName("org.jboss.seam.util.Parameters");
            versionId = "1.1";
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.error((Object)"Exception loading seam environment: ", (Throwable)e);
        }
        if (seamManagerClass != null) {
            log.debug((Object)("Seam environment detected v" + versionId));
        }
    }

    public static String getConversationIdParameterName() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        if (conversationIdParameter != null) {
            return conversationIdParameter;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdParameterMethod != null) {
                conversationIdParameter = returnVal = (String)seamConversationIdParameterMethod.invoke(seamManagerInstance, seamMethodNoArgs);
                versionedUrlParam = "?" + conversationIdParameter;
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception fetching conversationId Parameter name: ", (Throwable)e);
        }
        return returnVal;
    }

    public static void updatePageFlow() {
    }

    static {
        seamClassArgs = new Class[0];
        seamInstanceArgs = new Object[0];
        seamGetEncodeMethodArgs = new Class[]{String.class};
        seamEncodeMethodArgs = new Object[1];
        seamMethodNoArgs = new Object[0];
        SeamUtilities.loadSeamEnvironment();
    }
}

