/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.jasper.compiler;

import com.icesoft.jasper.JasperException;
import com.icesoft.jasper.compiler.Localizer;
import com.icesoft.jasper.xmlparser.ParserUtils;
import com.icesoft.jasper.xmlparser.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.faces.context.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TldLocationsCache {
    private static Log log = LogFactory.getLog((Class)TldLocationsCache.class);
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet noTldJars = new HashSet();
    private Hashtable mappings;
    private boolean initialized;
    private ExternalContext ctxt;
    private boolean redeployMode;

    public TldLocationsCache(ExternalContext ctxt) {
        this(ctxt, true);
    }

    public TldLocationsCache(ExternalContext ctxt, boolean redeployMode) {
        this.ctxt = ctxt;
        this.redeployMode = redeployMode;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing ICEfaces TldLocationsCache");
            }
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processWebDotXml() throws Exception {
        block19: {
            is = null;
            is = this.ctxt.getResourceAsStream("/WEB-INF/web.xml");
            if (is != null) break block17;
            if (TldLocationsCache.log.isWarnEnabled()) {
                TldLocationsCache.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", "/WEB-INF/web.xml"));
            }
            var11_2 = null;
            if (is == null) ** break block18
            try {
                is.close();
            }
            catch (IOException e) {
                if (!TldLocationsCache.log.isDebugEnabled()) ** GOTO lbl-1000
                TldLocationsCache.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
lbl-1000:
            // 4 sources

            {
                block17: {
                    return;
                }
                webtld = new ParserUtils().parseXMLDocument("/WEB-INF/web.xml", is);
                jspConfig = webtld.findChild("jsp-config");
                if (jspConfig != null) {
                    webtld = jspConfig;
                }
                taglibs = webtld.findChildren("taglib");
                while (taglibs.hasNext()) {
                    taglib = (TreeNode)taglibs.next();
                    tagUri = null;
                    tagLoc = null;
                    child = taglib.findChild("taglib-uri");
                    if (child != null) {
                        tagUri = child.getBody();
                    }
                    if ((child = taglib.findChild("taglib-location")) != null) {
                        tagLoc = child.getBody();
                    }
                    if (tagLoc == null) continue;
                    if (TldLocationsCache.uriType(tagLoc) == 2) {
                        tagLoc = "/WEB-INF/" + tagLoc;
                    }
                    tagLoc2 = null;
                    if (tagLoc.endsWith(".jar")) {
                        tagLoc = this.ctxt.getResource(tagLoc).toString();
                        tagLoc2 = "META-INF/taglib.tld";
                    }
                    this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
                }
            }
            var11_3 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (TldLocationsCache.log.isDebugEnabled()) {
                        TldLocationsCache.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            break block19;
            catch (Throwable var10_16) {
                block16: {
                    var11_4 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (!TldLocationsCache.log.isDebugEnabled()) break block16;
                            TldLocationsCache.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                throw var10_16;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanJar(JarURLConnection conn, boolean ignore) throws JasperException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        if (this.redeployMode) {
            conn.setUseCaches(false);
        }
        jarFile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            IOException e2;
            Object var11_12;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            InputStream stream = jarFile.getInputStream(entry);
            try {
                String uri = this.getUriFromTld(resourcePath, stream);
                if (uri != null && this.mappings.get(uri) == null) {
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
                var11_12 = null;
                if (stream == null) continue;
            }
            catch (Throwable throwable) {
                var11_12 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug((Object)e2.getLocalizedMessage(), (Throwable)e2);
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException e2) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)e2.getLocalizedMessage(), (Throwable)e2);
            }
        }
        Object var14_15 = null;
        if (!this.redeployMode) return;
        if (jarFile == null) return;
        try {
            jarFile.close();
            return;
        }
        catch (IOException e) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return;
        {
            catch (IOException ex) {
                block21: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    if (!this.redeployMode && jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            if (!log.isDebugEnabled()) break block21;
                            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                if (!ignore) {
                    throw new JasperException(ex);
                }
                Object var14_16 = null;
                if (!this.redeployMode) return;
                if (jarFile == null) return;
                try {
                    jarFile.close();
                    return;
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (!this.redeployMode || jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) throw throwable;
                log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList == null) return;
        Iterator it = dirList.iterator();
        while (it.hasNext()) {
            String uri;
            String path;
            block7: {
                Throwable t2;
                Object var8_7;
                path = (String)it.next();
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                    var8_7 = null;
                    if (stream == null) break block7;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t2) {}
                stream.close();
            }
            if (uri == null || this.mappings.get(uri) != null) continue;
            this.mappings.put(uri, new String[]{path, null});
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            URL[] urls;
            if (!(loader instanceof URLClassLoader) || null == (urls = ((URLClassLoader)loader).getURLs())) continue;
            for (int i = 0; i < urls.length; ++i) {
                URLConnection conn = urls[i].openConnection();
                if (conn instanceof JarURLConnection) {
                    if (!this.needScanJar(loader, webappLoader, ((JarURLConnection)conn).getJarFile().getName())) continue;
                    this.scanJar((JarURLConnection)conn, true);
                    continue;
                }
                String urlStr = urls[i].toString();
                if (!urlStr.startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX) || !this.needScanJar(loader, webappLoader, urlStr)) continue;
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), true);
            }
        }
    }

    private boolean needScanJar(ClassLoader loader, ClassLoader webappLoader, String jarPath) {
        if (loader == webappLoader) {
            return true;
        }
        String jarName = jarPath;
        int slash = jarPath.lastIndexOf(47);
        if (slash >= 0) {
            jarName = jarPath.substring(slash + 1);
        }
        return !noTldJars.contains(jarName);
    }

    static {
        noTldJars.add("ant.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-cluster.jar");
        noTldJars.add("catalina-optional.jar");
        noTldJars.add("catalina-i18n-fr.jar");
        noTldJars.add("catalina-i18n-ja.jar");
        noTldJars.add("catalina-i18n-es.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-modeler.jar");
        noTldJars.add("commons-logging-api.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("commons-el.jar");
        noTldJars.add("jakarta-regexp-1.2.jar");
        noTldJars.add("jasper-compiler.jar");
        noTldJars.add("jasper-runtime.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("jkshm.jar");
        noTldJars.add("jkconfig.jar");
        noTldJars.add("naming-common.jar");
        noTldJars.add("naming-resources.jar");
        noTldJars.add("naming-factory.jar");
        noTldJars.add("naming-java.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("servlets-default.jar");
        noTldJars.add("servlets-invoker.jar");
        noTldJars.add("servlets-common.jar");
        noTldJars.add("servlets-webdav.jar");
        noTldJars.add("tomcat-util.jar");
        noTldJars.add("tomcat-http11.jar");
        noTldJars.add("tomcat-jni.jar");
        noTldJars.add("tomcat-jk.jar");
        noTldJars.add("tomcat-jk2.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
    }
}

