/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionLifetimeManager
implements HttpSessionListener,
ServletContextListener {
    private static Map sessions = new HashMap();
    private boolean run = false;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Thread poolingProcess = new Thread(){

            public void run() {
                while (SessionLifetimeManager.this.run) {
                    Iterator trackers = sessions.values().iterator();
                    while (trackers.hasNext()) {
                        ((Tracker)trackers.next()).invalidateIfExpired();
                    }
                    try {
                        1.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.run = true;
        poolingProcess.start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.run = false;
    }

    public void sessionCreated(HttpSessionEvent event) {
        sessions.put(event.getSession(), new Tracker(event.getSession()));
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        sessions.remove(event.getSession());
    }

    public static void touch(HttpSession session) {
        if (sessions.containsKey(session)) {
            ((Tracker)sessions.get(session)).touch();
        }
    }

    private class Tracker {
        private final HttpSession session;
        private long lastAccess;

        public Tracker(HttpSession session) {
            this.session = session;
            this.touch();
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
        }

        public void invalidateIfExpired() {
            if (this.isExpired()) {
                try {
                    this.session.invalidate();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        private boolean isExpired() {
            return (long)(this.session.getMaxInactiveInterval() * 1000) < System.currentTimeMillis() - this.lastAccess;
        }
    }
}

