/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.context.RequestMapWrapper;
import com.icesoft.faces.env.ServletEnvironmentRequest;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.xmlhttp.BlockingServlet;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesCommonlet;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import com.icesoft.faces.webapp.xmlhttp.ResponseStateManager;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.SeamUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFacesServlet
extends HttpServlet {
    private static final String COMPRESS_RESOURCES = "com.icesoft.faces.compressResources";
    private static final String SYNCHRONOUS_UPDATE = "com.icesoft.faces.synchronousUpdate";
    private static final String HEARTBEAT_INTERVAL = "com.icesoft.faces.heartbeatInterval";
    private static final String HEARTBEAT_TIMEOUT = "com.icesoft.faces.heartbeatTimeout";
    private static final String HEARTBEAT_RETRIES = "com.icesoft.faces.heartbeatRetries";
    private static final String CONNECTION_TIMEOUT = "com.icesoft.faces.connectionTimeout";
    private static final String CONNECTION_LOST_REDIRECT_URI = "com.icesoft.faces.connectionLostRedirectURI";
    private static final String JAVASCRIPT_BLOCKED_REDIRECT_URI = "com.icesoft.faces.javascriptBlockedRedirectURI";
    public static final String UPLOAD_MAX_FILE_SIZE = "com.icesoft.faces.uploadMaxFileSize";
    public static final String UPLOAD_NOTHING_KEY = "com.icesoft.faces.uploadNothing";
    public static final String CURRENT_VIEW_NUMBER = "com.icesoft.faces.currentViewNumber";
    public static final String FILENAME_KEY = "_filename";
    public static final String MIMETYPE_KEY = "_mimetype";
    private static final long STARTUP_TIME = System.currentTimeMillis();
    private static final long EXPIRATION_TIME = STARTUP_TIME + 2629743830L;
    private ServletConfig config;
    private PersistentFacesCommonlet commonlet;
    private int globalViewNumber = 1000;
    private long uploadMaxFileSize;
    private ResponseStateManager stateManager;
    private static final Log log = LogFactory.getLog((Class)PersistentFacesServlet.class);
    private long connectionTimeout;
    private long heartbeatRetries;
    private long heartbeatTimeout;
    private long heartbeatInterval;
    private boolean synchronousUpdate;
    private URI connectionLostRedirectURI;
    private URI javascriptBlockedRedirectURI;
    private boolean compressResources;
    private final String[] seamShortcutKeywords = new String[]{"actionMethod", "dataModelSelection"};

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.commonlet = new PersistentFacesCommonlet();
        this.commonlet.init(this.commonlet.getInitParams(this.config));
        ServletContext servletContext = config.getServletContext();
        try {
            this.commonlet.concurrentDOMViews = Boolean.valueOf(servletContext.getInitParameter("com.icesoft.faces.concurrentDOMViews"));
        }
        catch (NullPointerException e) {
            this.commonlet.concurrentDOMViews = false;
        }
        try {
            this.compressResources = Boolean.valueOf(servletContext.getInitParameter(COMPRESS_RESOURCES));
        }
        catch (NullPointerException e) {
            this.compressResources = false;
        }
        try {
            this.synchronousUpdate = Boolean.valueOf(servletContext.getInitParameter(SYNCHRONOUS_UPDATE));
        }
        catch (NullPointerException e) {
            this.synchronousUpdate = false;
        }
        try {
            this.heartbeatInterval = Long.parseLong(servletContext.getInitParameter(HEARTBEAT_INTERVAL));
        }
        catch (NumberFormatException e) {
            this.heartbeatInterval = 20000L;
        }
        try {
            this.heartbeatTimeout = Long.parseLong(servletContext.getInitParameter(HEARTBEAT_TIMEOUT));
        }
        catch (NumberFormatException e) {
            this.heartbeatTimeout = 3000L;
        }
        try {
            this.heartbeatRetries = Long.parseLong(servletContext.getInitParameter(HEARTBEAT_RETRIES));
        }
        catch (NumberFormatException e) {
            this.heartbeatRetries = 3L;
        }
        try {
            this.connectionTimeout = Long.parseLong(servletContext.getInitParameter(CONNECTION_TIMEOUT));
        }
        catch (NumberFormatException e) {
            this.connectionTimeout = 30000L;
        }
        try {
            this.connectionLostRedirectURI = URI.create(servletContext.getInitParameter(CONNECTION_LOST_REDIRECT_URI));
        }
        catch (IllegalArgumentException e) {
            this.connectionLostRedirectURI = null;
        }
        catch (NullPointerException e) {
            this.connectionLostRedirectURI = null;
        }
        try {
            this.javascriptBlockedRedirectURI = URI.create(servletContext.getInitParameter(JAVASCRIPT_BLOCKED_REDIRECT_URI));
        }
        catch (IllegalArgumentException e) {
            this.javascriptBlockedRedirectURI = null;
        }
        catch (NullPointerException e) {
            this.javascriptBlockedRedirectURI = null;
        }
        try {
            this.uploadMaxFileSize = Long.parseLong(servletContext.getInitParameter(UPLOAD_MAX_FILE_SIZE));
        }
        catch (NumberFormatException e) {
            this.uploadMaxFileSize = 0x200000L;
        }
        this.stateManager = ResponseStateManager.getResponseStateManager(servletContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("SYNCHRONOUS_UPDATE = " + this.synchronousUpdate));
            log.trace((Object)("HEARTBEAT_INTERVAL=" + this.heartbeatInterval + "; HEARTBEAT_TIMEOUT=" + this.heartbeatTimeout + "; HEARTBEAT_RETRIES=" + this.heartbeatRetries + "; CONNECTION_TIMEOUT=" + this.connectionTimeout + "; UPLOAD_MAX_FILE_SIZE=" + this.uploadMaxFileSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"service()");
        }
        if (this.redirectOnJavascriptBlocked(request, response)) {
            return;
        }
        HttpSession session = request.getSession();
        String iceID = (String)session.getAttribute("icefacesID");
        if (log.isTraceEnabled()) {
            log.trace((Object)("service()  session id: " + session.getId() + "  iceID: " + iceID));
        }
        if (iceID == null) {
            iceID = IdGenerator.create(this.config.getServletContext().getResource("/").getPath());
            session.setAttribute("icefacesID", (Object)iceID);
        }
        String string = iceID;
        synchronized (string) {
            block32: {
                boolean compress;
                ContextEventRepeater.iceFacesIdRetrieved(session, iceID);
                HttpServletRequest httpRequest = request;
                String requestURI = (String)httpRequest.getAttribute("javax.servlet.include.request_uri");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("service()  requestURI: " + requestURI));
                }
                if (null == requestURI) {
                    requestURI = httpRequest.getRequestURI();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("service()  requestURI2: " + requestURI));
                    }
                }
                boolean bl = compress = this.compressResources && request.getHeader("Accept-Encoding").indexOf("gzip") > -1;
                if (this.writeJSResource(requestURI, request, response, iceID, compress)) {
                    return;
                }
                if (this.writeCSSResource(requestURI, request, response, compress)) {
                    return;
                }
                if (this.writeIFrame(requestURI, response)) {
                    return;
                }
                this.setCacheControls((ServletResponse)response);
                int viewNumber = -1;
                if (this.commonlet.concurrentDOMViews) {
                    try {
                        int redirectViewNumber;
                        viewNumber = redirectViewNumber = Integer.parseInt(this.getCookie(request, "redirectViewNumber"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (-1 == viewNumber) {
                        viewNumber = this.getNextViewNumber();
                    }
                } else {
                    viewNumber = 1;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("service()  viewNumber: " + viewNumber));
                }
                ContextEventRepeater.viewNumberRetrieved(session, viewNumber);
                request.setAttribute("servletkey", (Object)"persistent");
                FacesContext facesContext = this.commonlet.getFacesContext(this.config.getServletContext(), request, response);
                Map map = request.getParameterMap();
                ExternalContext ec = facesContext.getExternalContext();
                if (ec instanceof BridgeExternalContext) {
                    ((BridgeExternalContext)ec).populateRequestParameters(BlockingServlet.convertParametersMap(map));
                }
                this.checkSeamRequestParameters(facesContext.getExternalContext().getRequestParameterMap());
                facesContext.getExternalContext().getRequestMap().put("servletkey", "persistent");
                facesContext.getExternalContext().getRequestParameterMap().put("viewNumber", String.valueOf(viewNumber));
                facesContext.getExternalContext().getSessionMap().put(CURRENT_VIEW_NUMBER, String.valueOf(viewNumber));
                Map requestMap = facesContext.getExternalContext().getRequestMap();
                this.primeRequestMap((ServletRequest)request, requestMap);
                Object requestAttribute = httpRequest.getAttribute("javax.servlet.include.request_uri");
                requestMap.remove("javax.servlet.include.request_uri");
                if (null != requestAttribute) {
                    requestMap.put("javax.servlet.include.request_uri", requestAttribute);
                }
                requestAttribute = httpRequest.getAttribute("javax.servlet.include.servlet_path");
                requestMap.remove("javax.servlet.include.servlet_path");
                if (null != requestAttribute) {
                    requestMap.put("javax.servlet.include.servlet_path", requestAttribute);
                }
                PersistentFacesState.setLocalInstance(facesContext.getExternalContext().getSessionMap(), String.valueOf(viewNumber));
                session.removeAttribute(DOMResponseWriter.getOldDOMKey(String.valueOf(viewNumber)));
                this.doClearSeamContexts();
                try {
                    try {
                        Lifecycle lifecycle = this.commonlet.getLifecycle();
                        FacesContext ctxt = PersistentFacesState.getInstance().facesContext;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("service()  FacesContext: " + ctxt));
                        }
                        String viewNumberString = String.valueOf(viewNumber);
                        ResponseState state = this.stateManager.getState(session, viewNumberString);
                        state.setFocusID(request.getParameter("focus"));
                        session.setAttribute(viewNumberString + "/" + ResponseState.STATE, (Object)state);
                        if (ctxt == null) {
                            lifecycle.execute(facesContext);
                            lifecycle.render(facesContext);
                        } else {
                            FacesContext facesContext2 = ctxt;
                            synchronized (facesContext2) {
                                lifecycle.execute(facesContext);
                                lifecycle.render(facesContext);
                            }
                        }
                        if (ec != null && ec instanceof BridgeExternalContext && ((BridgeExternalContext)ec).redirectRequested()) {
                            String url = ((BridgeExternalContext)ec).redirectTo();
                            log.debug((Object)("Response.redirect() to: " + url));
                            response.sendRedirect(url);
                        }
                        this.setupPersistentContext(this.config.getServletContext(), request, viewNumber);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) throw new ServletException((Throwable)e);
                        log.error((Object)("Exception executing lifecycle or setting up persistent context. " + e.getMessage()), (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                    Object var22_23 = null;
                    if (null == facesContext) break block32;
                }
                catch (Throwable throwable) {
                    Object var22_24 = null;
                    if (null != facesContext) {
                        facesContext.release();
                    }
                    PersistentFacesState.clearLocalInstance();
                    throw throwable;
                }
                facesContext.release();
            }
            PersistentFacesState.clearLocalInstance();
            return;
        }
    }

    private void doClearSeamContexts() {
        FacesContext fc = FacesContext.getCurrentInstance();
        fc.getExternalContext().getRequestMap().put("com.icesoft.faces.removeSeamContexts", Boolean.TRUE);
    }

    private boolean redirectOnJavascriptBlocked(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        if (uri.endsWith("/javascript-blocked")) {
            if (this.javascriptBlockedRedirectURI == null) {
                response.sendError(403, "Javascript not enabled.");
            } else {
                response.sendRedirect(this.javascriptBlockedRedirectURI.toString());
            }
            return true;
        }
        return false;
    }

    private void checkSeamRequestParameters(Map externalContextMap) {
        boolean seamEnabled = SeamUtilities.isSeamEnvironment();
        if (seamEnabled) {
            externalContextMap.put("com.icesoft.faces.shortcutLifecycle", Boolean.TRUE);
        }
    }

    private void setCacheControls(ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Cache-Control", "no-store");
        httpResponse.setHeader("Cache-Control", "must-revalidate");
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setDateHeader("Expires", 0L);
    }

    void setupPersistentContext(ServletContext context, HttpServletRequest request, int viewNumber) {
        ServletEnvironmentRequest envReq = new ServletEnvironmentRequest(request);
        BridgeExternalContext perExtContext = new BridgeExternalContext(context, envReq, null);
        BridgeFacesContext persistentContext = new BridgeFacesContext(perExtContext);
        perExtContext.getRequestParameterMap().put("viewNumber", String.valueOf(viewNumber));
        PersistentFacesState.resetInstance(perExtContext.getSessionMap(), String.valueOf(viewNumber), persistentContext);
    }

    private synchronized int getViewNumber() {
        return this.globalViewNumber;
    }

    private synchronized int getNextViewNumber() {
        ++this.globalViewNumber;
        return this.globalViewNumber;
    }

    String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    void primeRequestMap(ServletRequest request, Map requestMap) {
        if (requestMap instanceof RequestMapWrapper) {
            RequestMapWrapper wrapperMap = (RequestMapWrapper)requestMap;
            wrapperMap.clearMostly();
            wrapperMap.primeMap();
        }
    }

    private InputStream createConfigurationStream(String sessionID, String contextName) {
        return new ByteArrayInputStream(("configuration = {   sessionID: '" + sessionID + "'," + "   synchronous: " + this.synchronousUpdate + "," + "   redirectURI: " + (this.connectionLostRedirectURI == null ? "null," : "'" + this.connectionLostRedirectURI.toString() + "',") + "   connection: {" + "       context: '" + contextName + "'," + "       timeout: " + this.connectionTimeout + "," + "       heartbeat: {" + "           interval: " + this.heartbeatInterval + "," + "           timeout: " + this.heartbeatTimeout + "," + "           retries: " + this.heartbeatRetries + "       }" + "   }" + "};").getBytes());
    }

    private boolean writeJSResource(String requestURI, HttpServletRequest request, HttpServletResponse response, String sessionID, boolean compressed) throws IOException {
        if (requestURI.endsWith(".js")) {
            String prefix = "xmlhttp/";
            int position = requestURI.indexOf(prefix);
            String postfix = requestURI.substring(position + prefix.length());
            String enterpriseJS = "com/icesoft/faces/async/server/" + postfix;
            InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(enterpriseJS);
            if (resource == null) {
                String communityJS = "com/icesoft/faces/webapp/xmlhttp/" + postfix;
                resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(communityJS);
            }
            String contextName = requestURI.substring(0, requestURI.indexOf(request.getServletPath()));
            InputStream configurationStream = this.createConfigurationStream(sessionID, contextName);
            PersistentFacesServlet.writeResource(new SequenceInputStream(configurationStream, resource), request, response, compressed);
            return true;
        }
        return false;
    }

    private boolean writeCSSResource(String requestURI, HttpServletRequest request, HttpServletResponse response, boolean compressed) throws IOException {
        String prefix = "xmlhttp/css/";
        int position = requestURI.indexOf(prefix);
        if (position > -1) {
            String path = "com/icesoft/faces/resources/css/" + requestURI.substring(position + prefix.length());
            InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            if (resource == null) {
                log.debug((Object)(" restricted access or following path not exists " + path));
            } else {
                PersistentFacesServlet.writeResource(resource, request, response, compressed);
            }
            return true;
        }
        return false;
    }

    private boolean writeIFrame(String requestURI, HttpServletResponse response) throws IOException {
        if (requestURI.endsWith("blank.iface")) {
            response.getWriter().println("<html><body></body></html>");
            return true;
        }
        return false;
    }

    private static void writeResource(InputStream resource, HttpServletRequest request, HttpServletResponse response, boolean compressed) throws IOException {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince == -1L || STARTUP_TIME - ifModifiedSince > 1000L) {
            response.setHeader("Cache-Control", "private, max-age=86400");
            response.setDateHeader("Expires", EXPIRATION_TIME);
            response.setDateHeader("Last-Modified", STARTUP_TIME);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            if (compressed) {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gzip = new GZIPOutputStream(output);
                PersistentFacesServlet.copy(resource, gzip);
                gzip.finish();
            } else {
                PersistentFacesServlet.copy(resource, output);
            }
            byte[] resourceBytes = output.toByteArray();
            response.setContentLength(resourceBytes.length);
            response.getOutputStream().write(resourceBytes);
        } else {
            response.setStatus(304);
            response.setDateHeader("Expires", EXPIRATION_TIME);
        }
        response.flushBuffer();
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[2000];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
    }

    public void destroy() {
        this.commonlet.destroy();
        this.config = null;
    }
}

