/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.env.PortletEnvironmentRequest;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesCommonlet;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import com.icesoft.faces.webapp.xmlhttp.ResponseStateManager;
import com.icesoft.util.IdGenerator;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFacesPortlet
implements Portlet {
    private PortletConfig portletConfig;
    private PersistentFacesCommonlet commonlet;
    private String REDIRECT_URL = "com.icesoft.faces.redirectURL";
    public static final String PARAM_VIEW_PAGE = "ViewPage";
    public static final String DEFAULT_VIEW_PAGE = "default-view";
    public static final String DEFAULT_VIEW_ID = "index.jsf";
    public static final String REQUEST_SERVLET_PATH = "org.apache.portals.bridges.jsf.REQUEST_SERVLET_PATH";
    private ResponseStateManager stateManager;
    private static int viewNumber = 1000;
    private static final Log log = LogFactory.getLog((Class)PersistentFacesPortlet.class);

    public void init(PortletConfig config) throws PortletException {
        this.portletConfig = config;
        this.commonlet = new PersistentFacesCommonlet();
        this.commonlet.init(this.commonlet.getInitParams(this.portletConfig));
        this.stateManager = new ResponseStateManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        FacesContext facesContext = this.commonlet.getFacesContext(this.portletConfig.getPortletContext(), request, response);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("PersistentFacesPortlet.processAction: FacesContext =" + facesContext));
            log.debug((Object)("PersistentFacesPortlet.processAction: ExternalContext = " + externalContext));
        }
        PortletSession session = request.getPortletSession();
        PersistentFacesState.setLocalInstance(null, null);
        try {
            Lifecycle lifecycle = this.commonlet.getLifecycle();
            lifecycle.execute(facesContext);
            this.setupPersistentContext(externalContext, (PortletRequest)request);
        }
        catch (Exception e) {
            block10: {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    session.invalidate();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            String redirectURL = externalContext.getInitParameter(this.REDIRECT_URL);
            response.sendRedirect(redirectURL);
        }
        finally {
            facesContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("servletkey", (Object)"persistent");
        request.setAttribute("requestpathkey", (Object)request.getContextPath());
        PortletSession session = request.getPortletSession();
        FacesContext facesContext = this.commonlet.getFacesContext(this.portletConfig.getPortletContext(), request, response);
        String iceID = (String)session.getAttribute("icefacesID", 1);
        if (iceID == null) {
            iceID = IdGenerator.create(this.portletConfig.getPortletContext().getResource("/").getPath());
            session.setAttribute("icefacesID", (Object)iceID, 1);
        }
        ++viewNumber;
        BridgeExternalContext externalContext = (BridgeExternalContext)facesContext.getExternalContext();
        externalContext.getRequestMap().put("com.sun.faces.portlet.INIT", "com.sun.faces.portlet.INIT_VIEW");
        request.setAttribute("com.sun.faces.portlet.INIT", (Object)"com.sun.faces.portlet.INIT_VIEW");
        if (log.isDebugEnabled()) {
            log.debug((Object)("PersistentFacesPortlet.render: FacesContext =" + facesContext));
            log.debug((Object)("PersistentFacesPortlet.render: ExternalContext = " + (Object)((Object)externalContext)));
        }
        externalContext.getRequestMap().put("servletkey", "persistent");
        externalContext.getRequestParameterMap().put("viewNumber", String.valueOf(viewNumber));
        externalContext.getApplicationSessionMap().put("com.icesoft.faces.currentViewNumber", String.valueOf(viewNumber));
        PersistentFacesState.setLocalInstance(externalContext.getApplicationSessionMap(), String.valueOf(viewNumber));
        String viewId = null;
        String paramViewPage = this.portletConfig.getInitParameter(PARAM_VIEW_PAGE);
        if (null == paramViewPage) {
            paramViewPage = this.portletConfig.getInitParameter(DEFAULT_VIEW_PAGE);
        }
        viewId = null != paramViewPage ? paramViewPage.replaceAll("[.]jsp", ".jsf") : DEFAULT_VIEW_ID;
        request.setAttribute(REQUEST_SERVLET_PATH, (Object)viewId);
        if (externalContext instanceof BridgeExternalContext) {
            externalContext.setRequestServletPath(viewId);
        }
        try {
            Lifecycle lifecycle = this.commonlet.getLifecycle();
            lifecycle.execute(facesContext);
            lifecycle.render(facesContext);
            this.setupPersistentContext(externalContext, (PortletRequest)request);
            ResponseState state = this.stateManager.getState(session, String.valueOf(viewNumber));
            session.setAttribute(String.valueOf(viewNumber) + "/" + ResponseState.STATE, (Object)state, 1);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                session.invalidate();
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            facesContext.release();
        }
    }

    void setupPersistentContext(ExternalContext extContext, PortletRequest request) {
        PortletEnvironmentRequest envReq = new PortletEnvironmentRequest(request);
        BridgeExternalContext perExtContext = new BridgeExternalContext(extContext.getContext(), envReq, null);
        perExtContext.setRequestServletPath(extContext.getRequestServletPath());
        BridgeFacesContext persistentContext = new BridgeFacesContext(perExtContext);
        PersistentFacesState state = new PersistentFacesState(persistentContext);
        perExtContext.getRequestParameterMap().put("viewNumber", String.valueOf(viewNumber));
        PersistentFacesState.setInstance(perExtContext.getApplicationSessionMap(), String.valueOf(viewNumber), state);
        PersistentFacesState.setLocalInstance(perExtContext.getApplicationSessionMap(), String.valueOf(viewNumber));
    }

    public void destroy() {
        this.commonlet.destroy();
        this.portletConfig = null;
    }
}

