/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import java.util.HashMap;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletConfig;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFacesCommonlet {
    private static final Log log = LogFactory.getLog((Class)PersistentFacesCommonlet.class);
    private Application application;
    private Lifecycle lifecycle;
    private FacesContextFactory facesContextFactory;
    public static final String SERVLET_KEY = "servletkey";
    public static final String REQUEST_PATH_KEY = "requestpathkey";
    public static final String PERSISTENT = "persistent";
    public static final String CONCURRENT_DOM_VIEWS = "com.icesoft.faces.concurrentDOMViews";
    public static final String REMOVE_SEAM_CONTEXTS = "com.icesoft.faces.removeSeamContexts";
    public static final String SEAM_LIFECYCLE_SHORTCUT = "com.icesoft.faces.shortcutLifecycle";
    boolean concurrentDOMViews = false;

    void init(HashMap params) {
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.application = applicationFactory.getApplication();
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = (String)params.get("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("ICEfaces could not initialize JavaServer Faces. Please check that the JSF .jar files are installed correctly." + e.getMessage()), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    void destroy() {
        this.facesContextFactory = null;
        this.application = null;
        this.lifecycle = null;
    }

    HashMap getInitParams(ServletConfig config) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("javax.faces.LIFECYCLE_ID", config.getInitParameter("javax.faces.LIFECYCLE_ID"));
        return initParams;
    }

    HashMap getInitParams(PortletConfig config) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("javax.faces.LIFECYCLE_ID", config.getInitParameter("javax.faces.LIFECYCLE_ID"));
        return initParams;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public Application getApplication() {
        return this.application;
    }

    public FacesContextFactory getFacesContextFactory() {
        return this.facesContextFactory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response) {
        return this.facesContextFactory.getFacesContext(context, request, response, this.lifecycle);
    }
}

