/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.xmlhttp.Kicker;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import com.icesoft.faces.webapp.xmlhttp.SessionExpiredException;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class BlockingResponseState
implements ResponseState,
Serializable {
    protected static Log log = LogFactory.getLog((Class)BlockingResponseState.class);
    protected int maxNumberOfUpdates = 50;
    private Kicker kicker;
    private Object eventLock = new Object();
    private Collection updates = new ArrayList();
    private String focusID;
    protected boolean isCancelled = false;
    protected String iceID;
    protected String viewNumber;
    private final int maxUnflushed = 10;
    protected int unflushed = 0;
    protected HttpSession session;

    protected BlockingResponseState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingResponseState(HttpSession session, String iceID, String viewNumber) {
        if (iceID == null || viewNumber == null) {
            throw new IllegalArgumentException("iceID and viewNumber must be set");
        }
        this.session = session;
        this.iceID = iceID;
        String string = iceID;
        synchronized (string) {
            this.kicker = (Kicker)session.getAttribute(iceID + "/kicker");
            if (null == this.kicker) {
                this.kicker = new Kicker();
                session.setAttribute(iceID + "/kicker", (Object)this.kicker);
            }
        }
        this.viewNumber = viewNumber;
    }

    public Object getEventLock() {
        return this.eventLock;
    }

    public String getFocusID() {
        return this.focusID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(HttpServletRequest request) {
        long left = 0L;
        Kicker kicker = this.kicker;
        synchronized (kicker) {
            this.kicker.notifyAll();
            while (!this.isCancelled && !this.kicker.isKicked && (left = this.remainingMillis()) > 0L) {
                try {
                    this.kicker.wait(left);
                }
                catch (InterruptedException e) {}
            }
            this.kicker.isKicked = false;
        }
        if (this.remainingMillis() <= 0L) {
            throw new SessionExpiredException("Session timeout elapsed.");
        }
        if (this.isCancelled) {
            try {
                Thread.sleep(500L);
                log.debug((Object)"Cancelled block slept for browser abort");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.isCancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"DOMUpdate flushed");
        }
        Kicker kicker = this.kicker;
        synchronized (kicker) {
            ++this.unflushed;
            this.kicker.isKicked = true;
            this.kicker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Kicker kicker = this.kicker;
        synchronized (kicker) {
            this.kicker.isKicked = true;
            this.isCancelled = true;
            this.kicker.notifyAll();
        }
    }

    protected long remainingMillis() {
        long currentMillis = Calendar.getInstance().getTime().getTime();
        long accessedMillis = this.session.getLastAccessedTime();
        return (long)(this.session.getMaxInactiveInterval() * 1000) - (currentMillis - accessedMillis);
    }

    public void setFocusID(String focusID) {
        this.focusID = focusID;
    }

    public boolean hasHandler() {
        return false;
    }

    public void writeElement(Element element) {
        if (null == element) {
            return;
        }
        if (this.unflushed > 10) {
            throw new RuntimeException("viewNumber " + this.viewNumber + " update queue exceeded " + this.unflushed);
        }
        String nodeString = DOMUtils.nodeToString(element);
        this.addUpdate(element.getAttribute("id"), nodeString);
        if (log.isTraceEnabled()) {
            log.trace((Object)nodeString);
        }
    }

    public synchronized void serialize(Writer writer) throws IOException {
        Iterator i = this.updates.iterator();
        while (i.hasNext()) {
            ((Update)i.next()).serialize(writer);
        }
        this.updates.clear();
        this.unflushed = 0;
    }

    private synchronized void addUpdate(String address, String content) {
        this.updates.add(new Update(address, content));
    }

    private static class Update
    implements Serializable {
        private static final Pattern START_CDATA = Pattern.compile("<\\!\\[CDATA\\[");
        private static final Pattern END_CDATA = Pattern.compile("\\]\\]>");
        private String address;
        private String content;

        public Update(String address, String content) {
            this.address = address;
            this.content = content;
            this.content = START_CDATA.matcher(this.content).replaceAll("<!#cdata#");
            this.content = END_CDATA.matcher(this.content).replaceAll("##>");
        }

        public void serialize(Writer writer) throws IOException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("serialize()  address: " + this.address + "  content: " + this.content));
            }
            writer.write("<update address=\"" + this.address + "\"><![CDATA[" + this.content + "]]></update>");
        }
    }
}

