/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MessagesRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIMessages.class);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIMessages.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIMessages.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (domContext.isStreamWriting()) {
            this.writeStream(facesContext, uiComponent);
            return;
        }
        Iterator messagesIterator = null;
        boolean retrieveGlobalMessagesOnly = ((UIMessages)uiComponent).isGlobalOnly();
        messagesIterator = retrieveGlobalMessagesOnly ? facesContext.getMessages(null) : facesContext.getMessages();
        boolean tableLayout = false;
        String layout = (String)uiComponent.getAttributes().get("layout");
        if (layout != null && layout.toLowerCase().equals("table")) {
            tableLayout = true;
        }
        Element parentTarget = null;
        if (tableLayout) {
            if (!domContext.isInitialized()) {
                parentTarget = domContext.createElement("table");
                domContext.setRootNode(parentTarget);
                MessagesRenderer.setRootElementId(facesContext, parentTarget, uiComponent);
            } else {
                parentTarget = (Element)domContext.getRootNode();
                DOMContext.removeChildrenByTagName(parentTarget, "tr");
            }
        } else if (!domContext.isInitialized()) {
            Element list = domContext.createElement("ul");
            domContext.setRootNode(list);
            parentTarget = list;
            MessagesRenderer.setRootElementId(facesContext, list, uiComponent);
        } else {
            parentTarget = (Element)domContext.getRootNode();
            DOMContext.removeChildrenByTagName(parentTarget, "li");
        }
        FacesMessage nextFacesMessage = null;
        while (messagesIterator.hasNext()) {
            Text textNode;
            nextFacesMessage = (FacesMessage)messagesIterator.next();
            String[] styleAndStyleClass = MessagesRenderer.getStyleAndStyleClass(uiComponent, nextFacesMessage);
            String style = styleAndStyleClass[0];
            String styleClass = styleAndStyleClass[1];
            String[] summaryAndDetail = this.getSummaryAndDetail(nextFacesMessage);
            String summary = summaryAndDetail[0];
            String detail = summaryAndDetail[1];
            boolean showSummary = ((UIMessages)uiComponent).isShowSummary();
            boolean showDetail = ((UIMessages)uiComponent).isShowDetail();
            Node nextTableData = null;
            if (tableLayout) {
                Element tr = domContext.createElement("tr");
                Element td = domContext.createElement("td");
                tr.appendChild(td);
                parentTarget.appendChild(tr);
                nextTableData = td;
            }
            Element nextMessageSpan = domContext.createElement("span");
            if (tableLayout) {
                nextTableData.appendChild(nextMessageSpan);
            } else {
                Element li = domContext.createElement("li");
                parentTarget.appendChild(li);
                li.appendChild(nextMessageSpan);
            }
            if (null != styleClass) {
                nextMessageSpan.setAttribute("class", styleClass);
            }
            if (style != null) {
                nextMessageSpan.setAttribute("style", style);
            }
            boolean tooltip = this.getToolTipAttribute(uiComponent);
            if (showSummary && showDetail && tooltip) {
                nextMessageSpan.setAttribute("title", summary);
                textNode = domContext.getDocument().createTextNode(detail);
                nextMessageSpan.appendChild(textNode);
                continue;
            }
            if (showSummary) {
                textNode = domContext.getDocument().createTextNode(summary);
                nextMessageSpan.appendChild(textNode);
            }
            if (!showDetail) continue;
            textNode = domContext.getDocument().createTextNode(detail);
            nextMessageSpan.appendChild(textNode);
        }
        domContext.stepOver();
    }

    private void writeStream(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = domContext.createRootElement("span");
        Text text = domContext.createTextNode("List of Messages");
        Object style = uiComponent.getAttributes().get("style");
        if (style != null) {
            root.setAttribute("style", style.toString());
        }
        root.appendChild(text);
        domContext.streamWrite(facesContext, uiComponent);
        domContext.stepOver();
    }
}

