/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.facelets;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.facelets.D2DTagCompilationUnitFactory;
import com.icesoft.faces.facelets.D2DTextUnitFactory;
import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagCompilationUnitFactory;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.compiler.TextUnitFactory;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class D2DFaceletViewHandler
extends D2DViewHandler {
    public static final long DEFAULT_REFRESH_PERIOD = 2L;
    public static final String PARAM_REFRESH_PERIOD = "facelets.REFRESH_PERIOD";
    public static final String PARAM_SKIP_COMMENTS = "facelets.SKIP_COMMENTS";
    public static final String PARAM_VIEW_MAPPINGS = "facelets.VIEW_MAPPINGS";
    public static final String PARAM_LIBRARIES = "facelets.LIBRARIES";
    public static final String PARAM_DECORATORS = "facelets.DECORATORS";
    public static final String PARAM_RESOURCE_RESOLVER = "facelets.RESOURCE_RESOLVER";
    private static Log log = LogFactory.getLog((Class)D2DFaceletViewHandler.class);
    protected FaceletFactory faceletFactory;

    public D2DFaceletViewHandler() {
    }

    public D2DFaceletViewHandler(ViewHandler delegate) {
        super(delegate);
    }

    protected void faceletInitialize() {
        block3: {
            try {
                if (this.faceletFactory == null) {
                    SAXCompiler c = new SAXCompiler();
                    this.initializeCompiler((Compiler)c);
                    this.faceletFactory = this.createFaceletFactory((Compiler)c);
                }
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Failed initializing facelet instance", t);
            }
        }
    }

    protected void initializeCompiler(Compiler c) {
        String paramSkipComments;
        String paramDecorators;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ext = ctx.getExternalContext();
        String paramLibraries = ext.getInitParameter(PARAM_LIBRARIES);
        if (paramLibraries != null) {
            paramLibraries = paramLibraries.trim();
            String[] paramLibrariesArray = paramLibraries.split(";");
            for (int i = 0; i < paramLibrariesArray.length; ++i) {
                try {
                    URL url = ext.getResource(paramLibrariesArray[i]);
                    if (url == null) {
                        throw new FileNotFoundException(paramLibrariesArray[i]);
                    }
                    TagLibrary tagLibrary = TagLibraryConfig.create((URL)url);
                    c.addTagLibrary(tagLibrary);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded library: " + paramLibrariesArray[i]));
                    continue;
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Problem loading library: " + paramLibrariesArray[i]), (Throwable)e);
                }
            }
        }
        if ((paramDecorators = ext.getInitParameter(PARAM_DECORATORS)) != null) {
            paramDecorators = paramDecorators.trim();
            String[] paramDecoratorsArray = paramDecorators.split(";");
            for (int i = 0; i < paramDecoratorsArray.length; ++i) {
                try {
                    Class<?> tagDecoratorClass = Class.forName(paramDecoratorsArray[i]);
                    TagDecorator tagDecorator = (TagDecorator)tagDecoratorClass.newInstance();
                    c.addTagDecorator(tagDecorator);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded decorator: " + paramDecoratorsArray[i]));
                    continue;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Problem loading decorator: " + paramDecoratorsArray[i]), (Throwable)e);
                }
            }
        }
        if ((paramSkipComments = ext.getInitParameter(PARAM_SKIP_COMMENTS)) != null && paramSkipComments.equals("false")) {
            c.setTrimmingComments(false);
        }
        c.setTrimmingWhitespace(true);
        c.setTrimmingComments(true);
        c.setTextUnitFactory((TextUnitFactory)new D2DTextUnitFactory());
        c.setFallbackTagCompilationUnitFactory((TagCompilationUnitFactory)new D2DTagCompilationUnitFactory());
    }

    protected FaceletFactory createFaceletFactory(Compiler c) {
        FacesContext ctx;
        long refreshPeriod;
        block7: {
            refreshPeriod = 2L;
            ctx = FacesContext.getCurrentInstance();
            String paramRefreshPeriod = ctx.getExternalContext().getInitParameter(PARAM_REFRESH_PERIOD);
            if (paramRefreshPeriod != null && paramRefreshPeriod.length() > 0) {
                try {
                    refreshPeriod = Long.parseLong(paramRefreshPeriod);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)("Problem parsing refresh period: " + paramRefreshPeriod), (Throwable)nfe);
                }
            }
        }
        DefaultResourceResolver resourceResolver = null;
        String paramResourceResolver = ctx.getExternalContext().getInitParameter(PARAM_RESOURCE_RESOLVER);
        if (paramResourceResolver != null && paramResourceResolver.length() > 0) {
            try {
                Class<?> resourceResolverClass = Class.forName(paramResourceResolver, true, Thread.currentThread().getContextClassLoader());
                resourceResolver = (ResourceResolver)resourceResolverClass.newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Problem initializing ResourceResolver: " + paramResourceResolver, (Throwable)e);
            }
        }
        if (resourceResolver == null) {
            resourceResolver = new DefaultResourceResolver();
        }
        return new DefaultFaceletFactory(c, (ResourceResolver)resourceResolver, refreshPeriod);
    }

    protected String getRenderedViewId(FacesContext context, String actionId) {
        ExternalContext extCtx = context.getExternalContext();
        String viewId = actionId;
        if (extCtx.getRequestPathInfo() == null) {
            String facesSuffix = actionId.substring(actionId.lastIndexOf(46));
            String viewSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
            viewId = actionId.replaceFirst(facesSuffix, viewSuffix);
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderResponse(FacesContext context) throws IOException {
        block9: {
            if (log.isTraceEnabled()) {
                log.trace((Object)"renderResponse(FC)");
            }
            try {
                this.clearSession(context);
                UIViewRoot viewToRender = context.getViewRoot();
                String renderedViewId = this.getRenderedViewId(context, viewToRender.getViewId());
                viewToRender.setViewId(renderedViewId);
                if (viewToRender.getId() == null) {
                    viewToRender.setId(viewToRender.createUniqueId());
                }
                if (viewToRender.getChildCount() == 0) {
                    this.faceletInitialize();
                    Facelet f = null;
                    FaceletFactory.setInstance((FaceletFactory)this.faceletFactory);
                    try {
                        f = this.faceletFactory.getFacelet(viewToRender.getViewId());
                    }
                    finally {
                        FaceletFactory.setInstance(null);
                    }
                    f.apply(context, (UIComponent)viewToRender);
                    context.setViewRoot(viewToRender);
                    D2DFaceletViewHandler.verifyUniqueComponentIds((UIComponent)viewToRender, new HashMap());
                    this.tracePrintComponentTree(context);
                }
                this.createResponseWriter(context);
                this.renderResponse(context, (UIComponent)viewToRender);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)("Problem in renderResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        D2DFaceletViewHandler.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                D2DFaceletViewHandler.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                D2DFaceletViewHandler.removeTransient(d);
            }
        }
    }

    protected static void verifyUniqueComponentIds(UIComponent comp, HashMap ids) {
        if (!log.isErrorEnabled()) {
            return;
        }
        String id = comp.getId();
        if (id == null) {
            log.error((Object)("UIComponent has null id: " + comp));
        } else if (ids.containsKey(id)) {
            log.error((Object)("Multiple UIComponents found, which are wrongfully using the same id: " + id + ".  Most recent UIComponent: " + comp));
        } else {
            ids.put(id, id);
        }
        Iterator children = comp.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            D2DFaceletViewHandler.verifyUniqueComponentIds(child, ids);
        }
    }
}

