/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context.effects;

import com.icesoft.faces.context.effects.BlankEffect;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class LocalEffectEncoder {
    private static final String[] EVENTS = new String[]{"click", "dblclick", "mousedown", "mouseup", "mousemove", "mouseover", "mouseout", "change", "reset", "submit", "keypress", "keydown", "keyup"};
    private static String[] ATTRIBUTES = new String[EVENTS.length];
    private static final String ATTRIBUTE_PREFIX = "on";
    private static String[] EFFECTS = new String[EVENTS.length];
    private static final String EFFECT_SUFFIX = "effect";
    private static final Log log;

    public static void encodeLocalEffects(UIComponent comp, Element rootNode, FacesContext facesContext) {
        block5: {
            Map atts = comp.getAttributes();
            try {
                for (int i = 0; i < EVENTS.length; ++i) {
                    Effect fx = (Effect)atts.get(EFFECTS[i]);
                    if (fx == null && comp.getValueBinding(EFFECTS[i]) != null) {
                        fx = new BlankEffect();
                    }
                    if (fx == null) continue;
                    String value = JavascriptContext.applyEffect(fx, comp.getClientId(facesContext), facesContext);
                    String original = (String)atts.get(ATTRIBUTES[i]);
                    if (original == null) {
                        original = "";
                    }
                    rootNode.setAttribute(ATTRIBUTES[i], value + original);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        for (int index = 0; index < EVENTS.length; ++index) {
            LocalEffectEncoder.ATTRIBUTES[index] = ATTRIBUTE_PREFIX + EVENTS[index];
            LocalEffectEncoder.EFFECTS[index] = ATTRIBUTES[index] + EFFECT_SUFFIX;
        }
        log = LogFactory.getLog((Class)LocalEffectEncoder.class);
    }
}

