/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.ApplicationMap;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.RedirectException;
import com.icesoft.faces.context.RequestMapWrapper;
import com.icesoft.faces.context.RequestParameterValuesMap;
import com.icesoft.faces.context.SessionMap;
import com.icesoft.faces.context.portlet.PortletApplicationMap;
import com.icesoft.faces.context.portlet.PortletSessionMap;
import com.icesoft.faces.env.PortletEnvironmentResponse;
import com.icesoft.faces.env.ServletEnvironmentResponse;
import com.icesoft.faces.util.EnumerationIterator;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BridgeExternalContext
extends ExternalContext {
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String PATH_INFO_HACK = "com.icesoft.faces.fakePathInfo";
    public static final int UNKNOWN_ENVIRONMENT = -1;
    public static final int SERVLET_ENVIRONMENT = 1;
    public static final int PORTLET_ENVIRONMENT = 2;
    public static final String REQUEST_MAP = "com.icesoft.faces.context.BridgeExternalContext.REQUEST_MAP";
    private int currentEnvironment = 1;
    private ServletContext servletContext;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private HttpSession servletSession;
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private PortletSession portletSession;
    private String requestURI;
    private static final Log log = LogFactory.getLog((Class)BridgeExternalContext.class);
    private Map applicationMap;
    private Map sessionMap;
    private RequestMapWrapper requestMap;
    private Map requestParameterMap;
    private RequestParameterValuesMap requestParameterValuesMap;
    private Map requestHeaderMap;
    private Map responseCookieMap;
    String requestPathInfo;
    String requestServletPath;
    String redirectTo;
    boolean redirect;

    public BridgeExternalContext(Object context, Object request, Object response) {
        this.init(context, request, response);
    }

    private void init(Object context, Object request, Object response) {
        if (context instanceof ServletContext) {
            this.currentEnvironment = 1;
            this.servletContext = (ServletContext)context;
            this.servletRequest = (HttpServletRequest)request;
            this.servletResponse = (HttpServletResponse)response;
            this.servletSession = this.servletRequest.getSession();
            this.requestURI = this.servletRequest.getRequestURI();
        } else if (context instanceof PortletContext) {
            this.currentEnvironment = 2;
            this.portletContext = (PortletContext)context;
            this.portletRequest = (PortletRequest)request;
            this.portletResponse = (PortletResponse)response;
            this.portletSession = this.portletRequest.getPortletSession();
            this.requestURI = this.portletRequest.getContextPath();
        }
    }

    public Object getSession(boolean create) {
        switch (this.currentEnvironment) {
            case 1: {
                if (this.servletSession != null) {
                    return this.servletSession;
                }
                this.servletSession = this.servletRequest.getSession(create);
                return this.servletSession;
            }
            case 2: {
                if (this.portletSession != null) {
                    return this.portletSession;
                }
                this.portletSession = this.portletRequest.getPortletSession(create);
                return this.portletSession;
            }
        }
        return null;
    }

    public void setSession(Object session) {
        switch (this.currentEnvironment) {
            case 1: {
                this.servletSession = (HttpSession)session;
                break;
            }
            case 2: {
                this.portletSession = (PortletSession)session;
            }
        }
        this.sessionMap = null;
    }

    public Object getContext() {
        switch (this.currentEnvironment) {
            case 1: {
                return this.servletContext;
            }
            case 2: {
                return this.portletContext;
            }
        }
        return null;
    }

    public Object getRequest() {
        switch (this.currentEnvironment) {
            case 1: {
                return this.servletRequest;
            }
            case 2: {
                return this.portletRequest;
            }
        }
        return null;
    }

    public Object getResponse() {
        switch (this.currentEnvironment) {
            case 1: {
                if (this.servletResponse != null) {
                    return new ServletEnvironmentResponse(this.servletResponse);
                }
                return null;
            }
            case 2: {
                if (this.portletResponse != null) {
                    return new PortletEnvironmentResponse(this.portletResponse);
                }
                return null;
            }
        }
        return null;
    }

    public Map getApplicationMap() {
        if (null == this.applicationMap) {
            switch (this.currentEnvironment) {
                case 1: {
                    this.applicationMap = new ApplicationMap(this.servletContext);
                    break;
                }
                case 2: {
                    this.applicationMap = new PortletApplicationMap(this.portletContext);
                }
            }
        }
        return this.applicationMap;
    }

    public Map getSessionMap() {
        if (null != this.sessionMap) {
            return this.sessionMap;
        }
        switch (this.currentEnvironment) {
            case 1: {
                if (null != this.servletSession) {
                    this.sessionMap = new SessionMap(this.servletSession);
                    break;
                }
                this.sessionMap = new Hashtable();
                break;
            }
            case 2: {
                this.sessionMap = null != this.portletSession ? new PortletSessionMap(this.portletSession) : new Hashtable();
            }
        }
        return this.sessionMap;
    }

    public void clearRequestContext() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return;
        }
        switch (this.currentEnvironment) {
            case 1: {
                Enumeration e = this.servletRequest.getAttributeNames();
                while (e.hasMoreElements()) {
                    String el = (String)e.nextElement();
                    log.debug((Object)("Removing named element: " + el + " from Reused ExternalContext"));
                    this.servletRequest.removeAttribute(el);
                }
                break;
            }
        }
    }

    public void setSessionMap(Map sessionMap) {
        this.sessionMap = sessionMap;
    }

    public Map getApplicationSessionMap() {
        switch (this.currentEnvironment) {
            case 1: {
                return this.getSessionMap();
            }
            case 2: {
                if (null == this.portletSession) break;
                return new PortletSessionMap(this.portletSession, 1);
            }
        }
        return null;
    }

    public Map getRequestMap() {
        BridgeFacesContext facesContext = (BridgeFacesContext)FacesContext.getCurrentInstance();
        this.requestMap = (RequestMapWrapper)facesContext.getContextServletTable().get(REQUEST_MAP);
        if (null != this.requestMap) {
            this.requestMap.setExternalContext(this);
            return this.requestMap;
        }
        this.requestMap = new RequestMapWrapper(this);
        facesContext.getContextServletTable().put(REQUEST_MAP, this.requestMap);
        return this.requestMap;
    }

    public void resetRequestMap() {
        block3: {
            try {
                Map map = this.getRequestMap();
                Iterator keys = map.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    Object value = map.get(key);
                    if (!(value instanceof Boolean)) continue;
                    keys.remove();
                }
            }
            catch (IllegalStateException ise) {
                if (!SeamUtilities.isSeamEnvironment() || !this.redirect) break block3;
                throw new RedirectException(this.redirectTo);
            }
        }
    }

    public void clearRequestMap() {
        Map map = this.getRequestMap();
        map.clear();
    }

    public synchronized void populateRequestParameters(Map requestParameters) {
        Map valuesMap = this.getRequestParameterValuesMap();
        if (valuesMap == null) {
            this.requestParameterValuesMap = new RequestParameterValuesMap();
            valuesMap = this.requestParameterValuesMap;
        }
        valuesMap.clear();
        valuesMap.putAll(requestParameters);
        this.filterRequestParameterMap();
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap != null) {
            return this.requestParameterMap;
        }
        this.requestParameterMap = new Hashtable();
        return this.requestParameterMap;
    }

    private void filterRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new Hashtable();
        } else {
            this.requestParameterMap.clear();
        }
        Map requestParameterValuesMap = this.getRequestParameterValuesMap();
        Iterator parameterNames = requestParameterValuesMap.keySet().iterator();
        Object nextParameterName = null;
        String nextParameterValue = null;
        while (parameterNames.hasNext()) {
            nextParameterName = parameterNames.next();
            nextParameterValue = (String)requestParameterValuesMap.get(nextParameterName);
            nextParameterValue = ((String[])nextParameterValue)[0];
            this.requestParameterMap.put(nextParameterName, nextParameterValue);
        }
    }

    public Map getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        if (this.requestParameterMap != null) {
            return this.requestParameterMap.keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Map getRequestHeaderMap() {
        if (this.requestHeaderMap != null) {
            return this.requestHeaderMap;
        }
        this.requestHeaderMap = new Hashtable();
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        throw new UnsupportedOperationException();
    }

    public Map getRequestCookieMap() {
        throw new UnsupportedOperationException();
    }

    public Map getResponseCookieMap() {
        if (null != this.responseCookieMap) {
            return this.responseCookieMap;
        }
        this.responseCookieMap = new Hashtable();
        return this.responseCookieMap;
    }

    public void addCookie(Cookie cookie) {
        this.getResponseCookieMap().put(cookie.getName(), cookie);
    }

    public Locale getRequestLocale() {
        Locale loc = null;
        switch (this.currentEnvironment) {
            case 1: {
                loc = this.servletRequest.getLocale();
                break;
            }
            case 2: {
                loc = this.portletRequest.getLocale();
            }
        }
        return loc;
    }

    public Iterator getRequestLocales() {
        EnumerationIterator iter = null;
        switch (this.currentEnvironment) {
            case 1: {
                iter = new EnumerationIterator(this.servletRequest.getLocales());
                break;
            }
            case 2: {
                iter = new EnumerationIterator(this.portletRequest.getLocales());
            }
        }
        return iter;
    }

    public void setRequestPathInfo(String info) {
        this.requestPathInfo = info;
    }

    public String getRequestPathInfo() {
        String pathInfo = null;
        if ("true".equalsIgnoreCase(this.getInitParameter(PATH_INFO_HACK))) {
            return this.servletRequest.getServletPath();
        }
        switch (this.currentEnvironment) {
            case 1: {
                if (null != this.requestPathInfo) {
                    pathInfo = this.requestPathInfo;
                    break;
                }
                pathInfo = this.servletRequest.getPathInfo();
                break;
            }
            case 2: {
                pathInfo = null;
            }
        }
        return pathInfo;
    }

    public void setRequestURI(String path) {
        this.requestURI = path;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestContextPath() {
        String contextPath = null;
        switch (this.currentEnvironment) {
            case 1: {
                contextPath = this.servletRequest.getContextPath();
                break;
            }
            case 2: {
                contextPath = this.portletRequest.getContextPath();
            }
        }
        return contextPath;
    }

    public void setRequestServletPath(String path) {
        this.requestServletPath = path;
    }

    public String getRequestServletPath() {
        String servletPath = null;
        switch (this.currentEnvironment) {
            case 1: {
                if (null != this.requestServletPath) {
                    servletPath = this.requestServletPath;
                    break;
                }
                servletPath = this.servletRequest.getServletPath();
                break;
            }
            case 2: {
                servletPath = null != this.requestServletPath ? this.requestServletPath : null;
            }
        }
        return servletPath;
    }

    public String getInitParameter(String name) {
        if (name.equals("javax.faces.STATE_SAVING_METHOD")) {
            return null;
        }
        String initParam = null;
        switch (this.currentEnvironment) {
            case 1: {
                initParam = this.servletContext.getInitParameter(name);
                break;
            }
            case 2: {
                initParam = this.portletContext.getInitParameter(name);
            }
        }
        return initParam;
    }

    public Map getInitParameterMap() {
        HashMap initParameterMap = new HashMap();
        Enumeration names = null;
        switch (this.currentEnvironment) {
            case 1: {
                names = this.servletContext.getInitParameterNames();
                break;
            }
            case 2: {
                names = this.portletContext.getInitParameterNames();
            }
        }
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            initParameterMap.put(key, this.getInitParameter(key.toString()));
        }
        return initParameterMap;
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        Set paths = null;
        switch (this.currentEnvironment) {
            case 1: {
                paths = this.servletContext.getResourcePaths(path);
                break;
            }
            case 2: {
                paths = this.portletContext.getResourcePaths(path);
            }
        }
        return paths;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null) {
            throw new NullPointerException();
        }
        URL resource = null;
        switch (this.currentEnvironment) {
            case 1: {
                resource = this.servletContext.getResource(path);
                break;
            }
            case 2: {
                resource = this.portletContext.getResource(path);
            }
        }
        return resource;
    }

    public InputStream getResourceAsStream(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        InputStream resource = null;
        switch (this.currentEnvironment) {
            case 1: {
                resource = this.servletContext.getResourceAsStream(path);
                break;
            }
            case 2: {
                resource = this.portletContext.getResourceAsStream(path);
            }
        }
        return resource;
    }

    public String encodeActionURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        return url;
    }

    public String encodeResourceURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        String encodedURL = url;
        switch (this.currentEnvironment) {
            case 1: {
                if (null == this.servletResponse) break;
                encodedURL = this.servletResponse.encodeURL(url);
                break;
            }
            case 2: {
                encodedURL = this.portletResponse.encodeURL(url);
            }
        }
        return encodedURL;
    }

    public String encodeNamespace(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        switch (this.currentEnvironment) {
            case 1: {
                break;
            }
            case 2: {
                if (this.portletResponse instanceof ActionResponse) {
                    throw new IllegalStateException();
                }
                if (!(this.portletResponse instanceof RenderResponse)) break;
                StringBuffer buf = new StringBuffer(((RenderResponse)this.portletResponse).getNamespace());
                buf.append(name);
                name = buf.toString();
            }
        }
        return name;
    }

    public void dispatch(String path) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.servletRequest.getRequestDispatcher(path);
        try {
            requestDispatcher.forward((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw new FacesException((Throwable)se);
        }
    }

    public void redirect(String requestURI) throws IOException {
        this.redirectTo = SeamUtilities.encodeSeamConversationId(requestURI);
        this.redirect = true;
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String redirectTo() {
        return this.redirectTo;
    }

    public boolean redirectRequested() {
        return this.redirect;
    }

    public void redirectComplete() {
        this.redirect = false;
    }

    public void log(String message) {
        if (message == null) {
            message = "(no message)";
        }
        switch (this.currentEnvironment) {
            case 1: {
                this.servletContext.log(message);
                break;
            }
            case 2: {
                this.portletContext.log(message);
            }
        }
    }

    public void log(String message, Throwable throwable) {
        if (message == null) {
            message = "(no message)";
        }
        if (throwable == null) {
            StringBuffer buff = new StringBuffer(message);
            buff.append(" ");
            buff.append("[Throwable was null]");
            this.log(buff.toString());
        } else {
            switch (this.currentEnvironment) {
                case 1: {
                    this.servletContext.log(message, throwable);
                    break;
                }
                case 2: {
                    this.portletContext.log(message, throwable);
                }
            }
        }
    }

    public String getAuthType() {
        String authType = null;
        switch (this.currentEnvironment) {
            case 1: {
                authType = this.servletRequest.getAuthType();
                break;
            }
            case 2: {
                authType = this.portletRequest.getAuthType();
            }
        }
        return authType;
    }

    public String getRemoteUser() {
        String remoteUser = null;
        switch (this.currentEnvironment) {
            case 1: {
                remoteUser = this.servletRequest.getRemoteUser();
                break;
            }
            case 2: {
                remoteUser = this.portletRequest.getRemoteUser();
            }
        }
        return remoteUser;
    }

    public Principal getUserPrincipal() {
        Principal principal = null;
        switch (this.currentEnvironment) {
            case 1: {
                principal = this.servletRequest.getUserPrincipal();
                break;
            }
            case 2: {
                principal = this.portletRequest.getUserPrincipal();
            }
        }
        return principal;
    }

    public boolean isUserInRole(String role) {
        if (role == null) {
            throw new NullPointerException();
        }
        boolean inRole = false;
        switch (this.currentEnvironment) {
            case 1: {
                inRole = this.servletRequest.isUserInRole(role);
                break;
            }
            case 2: {
                inRole = this.portletRequest.isUserInRole(role);
            }
        }
        return inRole;
    }
}

