/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.RenderHub;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.faces.webapp.xmlhttp.TransientRenderingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RunnableRender
implements Runnable {
    private static Log log = LogFactory.getLog((Class)RenderHub.class);
    private Renderable renderable;

    public RunnableRender(Renderable renderable) {
        this.renderable = renderable;
    }

    public Renderable getRenderable() {
        return this.renderable;
    }

    public void run() {
        block9: {
            if (this.renderable == null) {
                return;
            }
            PersistentFacesState state = this.renderable.getState();
            if (state == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"state is null");
                }
                return;
            }
            try {
                state.render();
            }
            catch (RenderingException ex) {
                this.renderable.renderingException(ex);
                if (ex instanceof TransientRenderingException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"transient render exception", (Throwable)ex);
                    }
                }
                if (ex instanceof FatalRenderingException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"fatal render exception", (Throwable)ex);
                    }
                }
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"unknown render exception", (Throwable)ex);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RunnableRender) || this.renderable == null) {
            return false;
        }
        Renderable comparedRenderable = ((RunnableRender)obj).getRenderable();
        if (comparedRenderable == null) {
            return false;
        }
        PersistentFacesState comparedState = comparedRenderable.getState();
        if (comparedState == null) {
            return false;
        }
        PersistentFacesState myState = this.renderable.getState();
        if (myState == null) {
            return false;
        }
        return myState.equals(comparedState);
    }
}

