/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputtext;

import com.icesoft.faces.component.ext.HtmlInputText;
import com.icesoft.faces.component.ext.KeyEvent;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;

public class SelectInputText
extends HtmlInputText
implements NamingContainer {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.SelectInputText";
    private String styleClass;
    private String listVar = null;
    private Integer rows;
    private final int DEFAULT_MAX_MATCHS = 10;
    private String width;
    private final String DEFAULT_WIDTH = "150";
    private SelectItem selectedItem = null;
    List itemList;
    Map itemMap = new HashMap();
    private int index = -1;
    private List changedComponentIds = new ArrayList();

    public SelectInputText() {
        JavascriptContext.includeLib((String)"xmlhttp/ice-extras.js", (FacesContext)FacesContext.getCurrentInstance());
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public void decode(FacesContext facesContext) {
        super.decode(facesContext);
        this.setSelectedItem(facesContext);
        if (Util.isEventSource(facesContext, (UIComponent)this)) {
            this.queueEventIfEnterKeyPressed(facesContext);
        }
    }

    private void setSelectedItem(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(facesContext);
        String value = (String)requestMap.get(clientId);
        this.setSelectedItem(value);
    }

    private boolean hadFocus(FacesContext facesContext) {
        Object focusId = facesContext.getExternalContext().getRequestParameterMap().get(FormRenderer.getFocusElementId());
        boolean focus = false;
        if (focusId != null && focusId.toString().equals(this.getClientId(facesContext))) {
            focus = true;
        }
        this.setFocus(focus);
        return focus;
    }

    public Iterator getItemList() {
        if (this.itemList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.itemList.iterator();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.index >= 0) {
            return baseClientId + ':' + this.index++;
        }
        return baseClientId;
    }

    void resetId(UIComponent component) {
        String id = component.getId();
        component.setId(id);
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            this.resetId(kid);
        }
    }

    void populateItemList() {
        this.itemList = this.getSelectFacet() != null ? this.getListValue() : Util.getSelectItems(FacesContext.getCurrentInstance(), (UIComponent)this);
        Iterator items = this.itemList.iterator();
        SelectItem item = null;
        this.itemMap.clear();
        while (items.hasNext()) {
            item = (SelectItem)items.next();
            this.itemMap.put(item.getLabel(), item);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ValueChangeEvent) {
            this.populateItemList();
            this.setChangedComponentId(this.getClientId(FacesContext.getCurrentInstance()));
        }
    }

    public UIComponent getSelectFacet() {
        return this.getFacet("selectInputText");
    }

    public void setSelectedItem(String key) {
        this.selectedItem = (SelectItem)this.itemMap.get(key);
    }

    public SelectItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setRows(int rows) {
        this.rows = new Integer(rows);
    }

    public int getRows() {
        if (this.rows != null) {
            if (this.itemMap != null) {
                return this.itemMap.size() > 0 && this.itemMap.size() < this.rows ? this.itemMap.size() : this.rows.intValue();
            }
            return this.rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        return vb != null ? Integer.parseInt(vb.getValue(this.getFacesContext()).toString()) : 10;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setListVar(String listVar) {
        this.listVar = listVar;
    }

    public String getListVar() {
        if (this.listVar != null) {
            return this.listVar;
        }
        ValueBinding vb = this.getValueBinding("listVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setListValue(List listValue) {
        this.itemList = listValue;
    }

    public List getListValue() {
        ValueBinding vb = this.getValueBinding("listValue");
        return (List)vb.getValue(FacesContext.getCurrentInstance());
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : "150";
    }

    String getWidthAsStyle() {
        try {
            int width = Integer.parseInt(this.getWidth());
            return "width:" + width + "px;";
        }
        catch (NumberFormatException e) {
            return "width:" + this.getWidth().trim();
        }
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding vb = this.getValueBinding("styleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "iceSelInp";
    }

    public String getInputTextClass() {
        String base = this.getStyleClass();
        String className = "Text";
        if (this.isDisabled()) {
            className = className + "-dis";
        }
        return Util.appendNewStyleClass("iceSelInp", base, className);
    }

    public String getListClass() {
        String base = this.getStyleClass();
        String className = "List";
        if (this.isDisabled()) {
            className = className + "-dis";
        }
        return Util.appendNewStyleClass("iceSelInp", base, className);
    }

    public String getRowClass() {
        String base = this.getStyleClass();
        String className = "Row";
        if (this.isDisabled()) {
            className = className + "-dis";
        }
        return Util.appendNewStyleClass("iceSelInp", base, className);
    }

    public String getSelectedRowClass() {
        String base = this.getStyleClass();
        String className = "SelRow";
        if (this.isDisabled()) {
            className = className + "-dis";
        }
        return Util.appendNewStyleClass("iceSelInp", base, className);
    }

    void setChangedComponentId(Object id) {
        if (id == null) {
            this.changedComponentIds.clear();
        } else {
            this.changedComponentIds.add(id);
        }
    }

    boolean hasChanged() {
        return this.changedComponentIds.contains(this.getClientId(FacesContext.getCurrentInstance()));
    }

    private void queueEventIfEnterKeyPressed(FacesContext facesContext) {
        try {
            KeyEvent keyEvent = new KeyEvent((UIComponent)this, facesContext.getExternalContext().getRequestParameterMap());
            if (keyEvent.getKeyCode() == 13) {
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.styleClass, this.listVar, this.rows, this.width, this.selectedItem, this.itemList};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.styleClass = (String)values[1];
        this.listVar = (String)values[2];
        this.rows = (Integer)values[3];
        this.width = (String)values[4];
        this.selectedItem = (SelectItem)values[5];
        this.itemList = (List)values[6];
    }
}

