/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputprogress;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.outputprogress.OutputProgress;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OutputProgressRenderer
extends DomBasicInputRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element table;
        this.validateParameters(facesContext, uiComponent, OutputProgress.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            table = domContext.createRootElement("table");
            OutputProgressRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)uiComponent);
            table.setAttribute("cellpadding", "0");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("border", "0");
        }
        table = (Element)domContext.getRootNode();
        table.setAttribute("style", ((OutputProgress)uiComponent).getStyle());
        this.buildLayout(table, uiComponent, domContext);
        this.setPercentage(facesContext, uiComponent);
        if (PassThruAttributeRenderer.passThruAttributeExists((UIComponent)uiComponent)) {
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void setPercentage(FacesContext facesContext, UIComponent uiComponent) {
        String className;
        OutputProgress progressBar;
        String base;
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String space = "&nbsp;";
        if (domContext.isStreamWriting()) {
            space = "";
        }
        if ((base = (progressBar = (OutputProgress)uiComponent).getStyleClass()) == null) {
            base = "iceOutputProgress";
        }
        Text percentageText = progressBar.getTextNode();
        Element bgBar = progressBar.getBarNode();
        Element fillBar = (Element)bgBar.getFirstChild();
        String progressLabel = progressBar.getProgressLabel();
        int percentValue = progressBar.getValue();
        if (percentValue > 100) {
            percentValue = 100;
        }
        if (percentValue < 0) {
            percentValue = 0;
        }
        if (!progressBar.getIndeterminate()) {
            percentageText.setData(percentValue + " %");
        }
        if (percentValue < 100) {
            if (progressLabel != null && progressLabel.trim().length() > 0) {
                percentageText.setData(progressLabel);
            }
            if (progressBar.getIndeterminate()) {
                if (percentValue < 1) {
                    className = Util.appendNewStyleClass("iceOutputProgress", base, "IndeterminateInactiveClass");
                    fillBar.setAttribute("class", className);
                    percentageText.setData(space);
                } else {
                    className = Util.appendNewStyleClass("iceOutputProgress", base, "IndeterminateActiveClass");
                    fillBar.setAttribute("class", className);
                    fillBar.setAttribute("style", "position:absolute;width:100%");
                    if (progressLabel != null && progressLabel.trim().length() > 0) {
                        percentageText.setData(progressLabel);
                    } else {
                        percentageText.setData(space);
                    }
                }
            }
        } else {
            if (progressBar.getIndeterminate()) {
                className = Util.appendNewStyleClass("iceOutputProgress", base, "IndeterminateInactiveClass");
                fillBar.setAttribute("class", className);
                fillBar.setAttribute("style", "position:absolute;width:100%;");
            }
            if (progressBar.getProgressLabelComplete() != null) {
                percentageText.setData(progressBar.getProgressLabelComplete());
            }
        }
        if (!progressBar.getIndeterminate()) {
            Node node = fillBar.getFirstChild();
            if (node instanceof Text) {
                if (percentValue <= 0) {
                    fillBar.removeChild(node);
                }
            } else if (node == null && percentValue > 0) {
                Text nbsp4opera = domContext.createTextNode("&nbsp;");
                fillBar.appendChild(nbsp4opera);
            }
        }
        if (!progressBar.getIndeterminate()) {
            fillBar.setAttribute("style", "position:absolute;width:" + percentValue + "%;");
        }
    }

    private void buildLayout(Element table, UIComponent uiComponent, DOMContext domContext) {
        Element row2;
        String space = "&nbsp;";
        if (domContext.isStreamWriting()) {
            space = "";
        }
        Node node = table.getFirstChild();
        Element tbody = domContext.createElement("tbody");
        if (node != null) {
            table.replaceChild(tbody, node);
        } else {
            table.appendChild(tbody);
        }
        OutputProgress progressBar = (OutputProgress)uiComponent;
        String base = progressBar.getStyleClass();
        if (base == null) {
            base = "iceOutputProgress";
        }
        table.setAttribute("class", progressBar.getStyleClass());
        String textStyleClass = Util.appendNewStyleClass("iceOutputProgress", base, "Text");
        String bgStyleClass = Util.appendNewStyleClass("iceOutputProgress", base, "Background");
        String fillStyleClass = Util.appendNewStyleClass("iceOutputProgress", base, "Fill");
        Element row = domContext.createElement("tr");
        Element textTd = domContext.createElement("td");
        textTd.setAttribute("class", textStyleClass);
        Element barTd = domContext.createElement("td");
        tbody.appendChild(row);
        Text percentageText = null;
        percentageText = progressBar.getProgressLabel() != null ? domContext.createTextNode(space) : domContext.createTextNode("0 %");
        textTd.appendChild(percentageText);
        textTd.setAttribute("id", uiComponent.getClientId(FacesContext.getCurrentInstance()) + "percentageText");
        Element bgBar = domContext.createElement("div");
        bgBar.setAttribute("class", bgStyleClass);
        bgBar.setAttribute("style", "position:relative;");
        Element fillBar = domContext.createElement("div");
        fillBar.setAttribute("id", uiComponent.getClientId(FacesContext.getCurrentInstance()) + "bar");
        if (!progressBar.getIndeterminate()) {
            fillBar.setAttribute("class", fillStyleClass);
            fillBar.setAttribute("style", "position:absolute;width:0%");
        } else {
            fillBar.setAttribute("class", Util.appendNewStyleClass("iceOutputProgress", base, "IndeterminateInactiveClass"));
            fillBar.setAttribute("style", "position:absolute;width:100%;");
        }
        bgBar.appendChild(fillBar);
        Text nbsp4mozila = domContext.createTextNode(space);
        barTd.appendChild(bgBar);
        progressBar.setTextNode(percentageText);
        progressBar.setBarNode(bgBar);
        String textPosition = progressBar.getLabelPosition();
        if (!this.isValidTextPosition(textPosition.toString().toLowerCase())) {
            throw new FacesException("Please define valid textPosition [top|bottom|left|right|topcenter|bottomcenter|topright|bottomright|embed]");
        }
        if (textPosition.toString().equalsIgnoreCase("left")) {
            textTd.setAttribute("style", "vertical-align: middle;");
            row.appendChild(textTd);
            row.appendChild(barTd);
        }
        if (textPosition.toString().equalsIgnoreCase("right")) {
            textTd.setAttribute("style", "vertical-align: middle;");
            row.appendChild(barTd);
            row.appendChild(textTd);
        }
        if (textPosition.toString().toLowerCase().startsWith("top")) {
            row2 = domContext.createElement("tr");
            row.appendChild(textTd);
            row2.appendChild(barTd);
            tbody.appendChild(row2);
            if (textPosition.toString().equalsIgnoreCase("topcenter")) {
                textTd.setAttribute("align", "center");
            }
            if (textPosition.toString().equalsIgnoreCase("topright")) {
                textTd.setAttribute("align", "right");
            }
        }
        if (textPosition.toString().toLowerCase().startsWith("bottom")) {
            row2 = domContext.createElement("tr");
            row.appendChild(barTd);
            row2.appendChild(textTd);
            tbody.appendChild(row2);
            if (textPosition.toString().equalsIgnoreCase("bottomcenter")) {
                textTd.setAttribute("align", "center");
            }
            if (textPosition.toString().equalsIgnoreCase("bottomright")) {
                textTd.setAttribute("align", "right");
            }
        }
        if (textPosition.toString().equalsIgnoreCase("embed")) {
            Element embedDiv = domContext.createElement("div");
            embedDiv.setAttribute("class", textStyleClass);
            embedDiv.setAttribute("style", "text-align:center;position:relative;background-color:transparent;width:100%;z-index:1;");
            embedDiv.appendChild(percentageText);
            if (!progressBar.getIndeterminate()) {
                bgBar.appendChild(embedDiv);
            } else {
                fillBar.appendChild(embedDiv);
            }
            row.appendChild(barTd);
        } else {
            Text nbsp4opera = domContext.createTextNode(space);
            fillBar.appendChild(nbsp4opera);
            bgBar.appendChild(nbsp4mozila);
        }
    }

    private boolean isValidTextPosition(String textPosition) {
        String[] validPosition = new String[]{"top", "bottom", "left", "right", "topcenter", "bottomcenter", "topright", "bottomright", "embed"};
        for (int i = 0; i < validPosition.length; ++i) {
            if (!validPosition[i].equals(textPosition)) continue;
            return true;
        }
        return false;
    }
}

