/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.ext.HtmlCommandButton;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.outputchart.AbstractChart;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.DOMResponseWriter;
import java.beans.Beans;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.imageMap.ImageMapArea;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OutputChart
extends HtmlCommandButton {
    public static String AREA_CHART_TYPE = "area";
    public static String AREA_STACKED_CHART_TYPE = "areastacked";
    public static String BAR_CHART_TYPE = "bar";
    public static String BAR_CLUSTERED_CHART_TYPE = "barclustered";
    public static String BAR_STACKED_CHART_TYPE = "barstacked";
    public static String LINE_CHART_TYPE = "line";
    public static String PIE2D_CHART_TYPE = "pie2D";
    public static String PIE3D_CHART_TYPE = "pie3D";
    public static String POINT_CHART_TYPE = "point";
    public static String STOCK_CHART_TYPE = "stock";
    public static String CUSTOM_CHART_TYPE = "custom";
    public static String DEFAULT_CHART_TYPE = BAR_CHART_TYPE;
    private static int COMPONENT_ID = 0;
    private static int CLIENT_SIDE_IMAGE_MAP_KEY = 1;
    private static String DEFAULT_HEIGHT = "400";
    private static String DEFAULT_WIDTH = "400";
    private static String DEFAULT_CHART_TITLE = "Default Chart title";
    private static String DEFAULT_YAXIS_TITLE = "Default Y title";
    private static String DEFAULT_XAXIS_TITLE = "Default X title";
    private static String DEFAULT_DATA = "20, 30, 40";
    static String ICE_CHART_COMPONENT = "iceChartComponent";
    private int imageCounter = 0;
    private AbstractChart abstractChart;
    private String width;
    private String height;
    private boolean render = false;
    private FileOutputStream out;
    private String chartTitle;
    private Object data;
    private Object labels;
    private Object legendLabel;
    private Object colors;
    private Object shapes;
    private Object xaxisLabels;
    private String xaxisTitle;
    private String yaxisTitle;
    private String style = null;
    private String styleClass = null;
    private Object legendPlacement;
    private Object legendColumns;
    File folder = null;
    private Boolean renderOnSubmit;
    private MethodBinding renderOnSubmitMethodBinding;
    private String type = null;
    private String fileName = null;
    private File imageFile;
    private String parentFormId;

    public OutputChart() {
        this.setRendererType("com.icesoft.faces.OutputChartRenderer");
    }

    public Object getLabels() {
        if (this.labels != null) {
            return this.labels;
        }
        ValueBinding vb = this.getValueBinding("labels");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setLabels(Object labels) {
        this.labels = labels;
    }

    public Object getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        ValueBinding vb = this.getValueBinding("legendLabel");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setLegendLabel(Object legendLabel) {
        this.legendLabel = legendLabel;
    }

    public boolean isClientSideImageMap() {
        return this.getActionListener() != null && !this.getType().equalsIgnoreCase(AREA_CHART_TYPE) && !this.getType().equalsIgnoreCase(AREA_STACKED_CHART_TYPE);
    }

    public Object getData() {
        if (this.data != null) {
            return this.data;
        }
        ValueBinding vb = this.getValueBinding("data");
        if (vb != null) {
            return vb.getValue(this.getFacesContext());
        }
        if (!Beans.isDesignTime()) {
            this.setChartTitle(this.getChartTitle() + " with default data");
        }
        return DEFAULT_DATA;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getColors() {
        if (this.colors != null) {
            return this.colors;
        }
        ValueBinding vb = this.getValueBinding("colors");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setColors(Object colors) {
        this.colors = colors;
    }

    public Object getShapes() {
        if (this.shapes != null) {
            return this.shapes;
        }
        ValueBinding vb = this.getValueBinding("shapes");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setShapes(Object shapes) {
        this.shapes = shapes;
    }

    public String getXaxisTitle() {
        if (this.xaxisTitle != null) {
            return this.xaxisTitle;
        }
        ValueBinding vb = this.getValueBinding("xaxisTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_XAXIS_TITLE;
    }

    public void setXaxisTitle(String xaxisTitle) {
        this.xaxisTitle = xaxisTitle;
    }

    public String getYaxisTitle() {
        if (this.yaxisTitle != null) {
            return this.yaxisTitle;
        }
        ValueBinding vb = this.getValueBinding("yaxisTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_YAXIS_TITLE;
    }

    public void setYaxisTitle(String yaxisTitle) {
        this.yaxisTitle = yaxisTitle;
    }

    public Object getXaxisLabels() {
        if (this.xaxisLabels != null) {
            return this.xaxisLabels;
        }
        ValueBinding vb = this.getValueBinding("xaxisLabels");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setXaxisLabels(Object xaxisLabels) {
        this.xaxisLabels = xaxisLabels;
    }

    public String getChartTitle() {
        if (this.chartTitle != null) {
            return this.chartTitle;
        }
        ValueBinding vb = this.getValueBinding("chartTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_CHART_TITLE;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_WIDTH;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_HEIGHT;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setRenderOnSubmit(Object renderOnSubmit) {
        if (renderOnSubmit instanceof Boolean) {
            this.renderOnSubmit = (Boolean)renderOnSubmit;
        } else if (renderOnSubmit instanceof MethodBinding) {
            this.renderOnSubmitMethodBinding = (MethodBinding)renderOnSubmit;
        }
    }

    public Object getRenderOnSubmit() {
        if (this.renderOnSubmit != null) {
            return this.renderOnSubmit;
        }
        if (this.renderOnSubmitMethodBinding != null) {
            return (Boolean)this.renderOnSubmitMethodBinding.invoke(this.getFacesContext(), new Object[]{this});
        }
        return Boolean.FALSE;
    }

    public void setValueBinding(String s, ValueBinding vb) {
        if (s != null && s.equals("renderOnSubmit")) {
            MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(vb.getExpressionString(), new Class[]{OutputChart.class});
            this.setRenderOnSubmit(mb);
        } else {
            super.setValueBinding(s, vb);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!Beans.isDesignTime()) {
            try {
                if (this.abstractChart == null) {
                    this.abstractChart = AbstractChart.createChart((UIComponent)this);
                    if (this.getType().equalsIgnoreCase(CUSTOM_CHART_TYPE)) {
                        this.getRenderOnSubmit();
                    }
                    this.abstractChart.encode();
                } else if (((Boolean)this.getRenderOnSubmit()).booleanValue()) {
                    this.abstractChart.encode();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        super.encodeBegin(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
    }

    public void decode(FacesContext context) {
        ImageMapArea area;
        String[] submittedValue;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String chartComponentRequestIdentifier = (String)requestParameterMap.get(ICE_CHART_COMPONENT);
        if (chartComponentRequestIdentifier != null && (submittedValue = chartComponentRequestIdentifier.split("id-key"))[COMPONENT_ID].equals(this.getClientId(context)) && (area = (ImageMapArea)this.getGeneratedImageMapArea().get(submittedValue[CLIENT_SIDE_IMAGE_MAP_KEY])) != null) {
            this.setClickedImageMapArea(area);
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
        super.decode(context);
    }

    private String getChartFileName() {
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return this.getType() + this.getClientId(FacesContext.getCurrentInstance()).replaceAll(":", "") + req.getRequestedSessionId() + this.imageCounter++ + ".jpeg";
    }

    public String getPath() {
        String folder = "/";
        if (this.getFacesContext() != null && this.getFacesContext().getExternalContext() != null) {
            folder = DOMResponseWriter.isStreamWriting() ? "./web/chart/images" : ((ServletContext)this.getFacesContext().getExternalContext().getContext()).getRealPath("charts");
        }
        return folder;
    }

    public Chart getChart() {
        return this.abstractChart.getChart();
    }

    public void setChart(Chart chart) {
        this.abstractChart.setChart(chart);
    }

    public void render() {
        this.render = true;
    }

    public boolean isRender() {
        return this.render;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_CHART_TYPE;
    }

    public String getFileName() {
        return this.fileName;
    }

    OutputStream getNewOutputStream() {
        if (this.imageFile != null) {
            this.imageFile.delete();
        }
        this.imageFile = new File(this.getFolder(), this.getChartFileName());
        this.fileName = this.imageFile.getName();
        try {
            this.out = new FileOutputStream(this.imageFile);
            return this.out;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    File getFolder() {
        if (Beans.isDesignTime()) {
            this.folder = new File(this.getPath());
            return this.folder;
        }
        if (this.folder == null) {
            this.folder = new File(this.getPath());
            if (this.folder != null && !this.folder.exists()) {
                this.folder.mkdirs();
            }
        }
        return this.folder;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    Map getGeneratedImageMapArea() {
        return this.abstractChart.getGeneratedImageMapArea();
    }

    public ImageMapArea getClickedImageMapArea() {
        return this.abstractChart.getClickedImageMapArea();
    }

    public void setClickedImageMapArea(ImageMapArea clickedImageMapArea) {
        this.abstractChart.setClickedImageMapArea(clickedImageMapArea);
    }

    void generateClientSideImageMap(DOMContext domContext, Element map) {
        if (this.isClientSideImageMap()) {
            Iterator area = this.getGeneratedImageMapArea().values().iterator();
            while (area.hasNext()) {
                ImageMapArea areaMap = (ImageMapArea)area.next();
                Text areaNode = domContext.createTextNode(areaMap.toHTML("title ='" + areaMap.getLengendLabel() + "' href=\"return false;\" onclick=\"document.forms['" + this.getParentFormId() + "']['" + ICE_CHART_COMPONENT + "'].value='" + this.getClientId(this.getFacesContext()) + "id-key" + areaMap.hashCode() + "';iceSubmitPartial(document.forms['" + this.getParentFormId() + "'],this,event); return false;\""));
                map.appendChild(areaNode);
            }
        }
    }

    private String getParentFormId() {
        if (this.parentFormId != null) {
            return this.parentFormId;
        }
        UIComponent uiForm = FormRenderer.findForm((UIComponent)this);
        if (uiForm == null) {
            return null;
        }
        this.parentFormId = uiForm.getClientId(this.getFacesContext());
        return this.parentFormId;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding vb = this.getValueBinding("styleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "iceOutputChart";
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object getLegendPlacement() {
        if (this.legendPlacement != null) {
            return this.legendPlacement;
        }
        ValueBinding vb = this.getValueBinding("legendPlacement");
        return vb != null ? vb.getValue(this.getFacesContext()) : "bottom";
    }

    public void setLegendPlacement(Object legendPlacement) {
        this.legendPlacement = legendPlacement;
    }

    public Object getLegendColumns() {
        if (this.legendColumns != null) {
            return this.legendColumns;
        }
        ValueBinding vb = this.getValueBinding("legendColumns");
        return vb != null ? vb.getValue(this.getFacesContext()) : "0";
    }

    public void setLegendColumns(Object legendColumns) {
        this.legendColumns = legendColumns;
    }
}

