/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.ApplicationBaseLocator;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InputFileRenderer
extends DomBasicInputRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, InputFile.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        InputFile inputFile = (InputFile)uiComponent;
        if (domContext.isStreamWriting()) {
            this.writeStream(facesContext, uiComponent);
            return;
        }
        if (!domContext.isInitialized()) {
            Element table = domContext.createRootElement("table");
            table.setAttribute("style", "border:1px; width:400px");
            InputFileRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)uiComponent);
            Element tbody = domContext.createElement("tbody");
            table.appendChild(tbody);
            inputFile.setFirstTd(this.createRowColumn(domContext, "uploadTd", "height:60px;"));
            inputFile.setSecondTd(this.createRowColumn(domContext, "detailTd", ""));
            inputFile.getFirstTd().appendChild(this.getIframe(facesContext, uiComponent, domContext));
        }
        DOMContext.removeChildren((Node)inputFile.getFirstTd());
        inputFile.getFirstTd().appendChild(this.getIframe(facesContext, uiComponent, domContext));
        PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
        domContext.stepOver();
    }

    private Element createRowColumn(DOMContext domContext, String id, String style) {
        Element tr = domContext.createElement("tr");
        Element td = domContext.createElement("td");
        td.setAttribute("id", id);
        td.setAttribute("style", style);
        tr.appendChild(td);
        domContext.getRootNode().getFirstChild().appendChild(tr);
        return td;
    }

    private Element getIframe(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext) {
        InputFile inputFile = (InputFile)uiComponent;
        Element iframe = domContext.createElement("iframe");
        iframe.setAttribute("src", ApplicationBaseLocator.locate((FacesContext)facesContext) + "uploadHtml" + inputFile.getQueryString(facesContext));
        iframe.setAttribute("name", "fileUpload" + uiComponent.getClientId(facesContext));
        iframe.setAttribute("frameborder", "0");
        if (((InputFile)uiComponent).getStyle() != null) {
            iframe.setAttribute("style", ((InputFile)uiComponent).getStyle());
        }
        iframe.setAttribute("class", ((InputFile)uiComponent).getStyleClass());
        iframe.setAttribute("width", "400");
        iframe.setAttribute("height", "60");
        return iframe;
    }

    void writeStream(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        InputFile inputFile = (InputFile)uiComponent;
        Element root = domContext.createRootElement("div");
        root.setAttribute("style", inputFile.getStyle());
        root.setAttribute("class", inputFile.getStyleClass());
        Element upload = domContext.createElement("input");
        upload.setAttribute("type", "file");
        upload.setAttribute("class", inputFile.getInputTextClass());
        root.appendChild(upload);
        Element submit = domContext.createElement("input");
        submit.setAttribute("type", "submit");
        submit.setAttribute("class", inputFile.getButtonClass());
        submit.setAttribute("value", inputFile.getLabel());
        root.appendChild(submit);
        domContext.streamWrite(facesContext, uiComponent);
    }
}

