/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.FileUploadServlet;
import com.icesoft.faces.component.style.OutputStyle;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

public class InputFile
extends UICommand
implements Serializable {
    public static final String FILE_UPLOAD_COMPONENT_ID = "fileUploadComponentId";
    public static final String COMPONENT_TYPE = "com.icesoft.faces.File";
    public static final String RENDERER_TYPE = "com.icesoft.faces.Upload";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.File";
    public static final int DEFAULT = 0;
    public static final int UPLOADING = 1;
    public static final int SAVED = 2;
    public static final int INVALID = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int UNKNOWN_SIZE = 5;
    public static final String FILE_UPLOAD_PREFIX = "fileUpload";
    static final String ICE_UPLOAD_FILE = "uploadHtml";
    static final String SAVE_FLAG = "fileSave";
    private boolean register = false;
    private int status = 0;
    private FileInfo fileInfo = null;
    private File file = null;
    private Element firstTd = null;
    private Element secondTd = null;
    private Object baseClass = null;
    private String methodName = null;
    private Boolean disabled = null;
    private UIComponent parentForm = null;
    private String style = null;
    private String styleClass = null;
    private String label = null;
    FacesContext facesContext = FacesContext.getCurrentInstance();
    private Boolean readonly = null;
    private String enabledOnUserRole = null;
    private String renderedOnUserRole = null;
    private String alt = null;
    private boolean uniqueFolder = true;
    private boolean uniqueFolderSet = false;
    private MethodBinding progressListener = null;
    private String buttonClass = null;
    private boolean heartbeatStopped = false;
    private String maxlength = null;
    private String size = null;
    private String registrationId;
    private String cssFile = null;

    public String getComponentType() {
        return "com.icesoft.faces.File";
    }

    public String getRendererType() {
        return RENDERER_TYPE;
    }

    public String getFamily() {
        return "com.icesoft.faces.File";
    }

    boolean isRegister() {
        return this.register;
    }

    public void setRegister(FacesContext facesContext) {
        this.register = true;
        MethodBinding methodBinding = this.progressListener;
        if (methodBinding != null) {
            String elExpression = methodBinding.getExpressionString();
            String baseName = elExpression.substring(0, elExpression.lastIndexOf(46)) + "}";
            this.methodName = elExpression.substring(elExpression.lastIndexOf(46) + 1, elExpression.length() - 1);
            ValueBinding vb = FacesContext.getCurrentInstance().getApplication().createValueBinding(baseName);
            this.baseClass = vb.getValue(facesContext);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.getCssFile();
        if (!this.isRegister()) {
            UIComponent form = DomBasicRenderer.findForm((UIComponent)this);
            if (form != null) {
                this.setParentForm(form);
            }
            this.registerWithSession(context);
        }
    }

    public void decode(FacesContext context) {
        if (this.getStatus() != 0) {
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
    }

    public FileInfo getFileInfo() {
        if (this.fileInfo == null) {
            this.fileInfo = new FileInfo();
        }
        return this.fileInfo;
    }

    void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUniqueFolder(boolean uniqueFolder) {
        if (uniqueFolder != this.uniqueFolder) {
            this.uniqueFolder = uniqueFolder;
        }
        this.uniqueFolderSet = true;
    }

    public boolean isUniqueFolder() {
        if (this.uniqueFolderSet) {
            return this.uniqueFolder;
        }
        ValueBinding vb = this.getValueBinding("uniqueFolder");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        ValueBinding vb = this.getValueBinding("label");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Upload";
    }

    public MethodBinding getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(MethodBinding progressListener) {
        this.progressListener = progressListener;
    }

    public void setValueBinding(String name, ValueBinding vb) {
        if (name != null && name.equals("progressListener")) {
            MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(vb.getExpressionString(), new Class[]{EventObject.class});
            this.setProgressListener(mb);
            return;
        }
        super.setValueBinding(name, vb);
    }

    Element getFirstTd() {
        return this.firstTd;
    }

    void setFirstTd(Element firstTd) {
        this.firstTd = firstTd;
    }

    Element getSecondTd() {
        return this.secondTd;
    }

    void setSecondTd(Element secondTd) {
        this.secondTd = secondTd;
    }

    boolean fireEvent() {
        if (this.baseClass != null && this.methodName != null) {
            Class[] array = new Class[]{EventObject.class};
            Object[] methodArray = new Object[]{new EventObject(this)};
            try {
                Method m = this.baseClass.getClass().getMethod(this.methodName, array);
                m.invoke(this.baseClass, methodArray);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
        if (status != 0) {
            Map requestParameterMap = this.facesContext.getExternalContext().getRequestParameterMap();
            String formId = this.parentForm.getClientId(this.facesContext);
            requestParameterMap.put(formId, formId);
            this.parentForm.getAttributes().put("fileUploaded", "fileUploaded");
        }
        if (status == 1 && this.getFileInfo().getPercent() > 0 && this.getFileInfo().getPercent() < 90) {
            try {
                if (!this.isHeartbeatStopped()) {
                    String call = "var h = window.connection.heartbeat; if(h != null)h.stop();";
                    JavascriptContext.addJavascriptCall((FacesContext)this.facesContext, (String)call);
                    ((HttpSession)this.facesContext.getExternalContext().getSession(true)).setMaxInactiveInterval(600);
                    this.heartbeatStopped = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isDisabled() {
        if (!Util.isEnabledOnUserRole((UIComponent)this)) {
            return true;
        }
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isReadonly() {
        if (this.readonly != null) {
            return this.readonly;
        }
        ValueBinding vb = this.getValueBinding("readonly");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : false;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this.enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this.enabledOnUserRole != null) {
            return this.enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    UIComponent getParentForm() {
        return this.parentForm;
    }

    void setParentForm(UIComponent parentForm) {
        this.parentForm = parentForm;
    }

    void clearFormState() {
        if (this.parentForm != null && this.parentForm.getAttributes().containsKey(FILE_UPLOAD_PREFIX)) {
            this.parentForm.getAttributes().remove(FILE_UPLOAD_PREFIX);
        }
    }

    public void processUpdates(FacesContext context) {
        ValueBinding vb;
        super.processUpdates(context);
        this.clearFormState();
        if (this.getStatus() == 2 && (vb = this.getValueBinding("file")) != null) {
            vb.setValue(this.facesContext, (Object)this.getFile());
        }
        if (this.getStatus() != 0 && this.getStatus() != 2) {
            Exception ex;
            FileInfo fo = this.getFileInfo();
            String msg = "Exception processing updates";
            msg = fo == null ? "File info is null" : ((ex = fo.getException()) == null ? "Null exception" : ex.getMessage());
            FacesMessage message = new FacesMessage(msg);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this.setStatus(0);
        if (this.isHeartbeatStopped()) {
            String call = "var h = window.connection.heartbeat; if(h != null) {h.start();}";
            JavascriptContext.addJavascriptCall((FacesContext)this.facesContext, (String)call);
            this.heartbeatStopped = false;
        }
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "border:none; width:400px; height:50px; padding-top:0px;";
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getDisaledOREnabledClass((UIComponent)this, this.isDisabled(), this.styleClass, "styleClass", "iceFileUpload");
    }

    String getInputTextClass() {
        String result = "Text";
        if (this.isDisabled()) {
            result = result + "-dis";
        }
        return Util.appendNewStyleClass("iceFileUpload", this.styleClass, result);
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getButtonClass() {
        String result = "Button";
        if (this.buttonClass != null) {
            result = this.buttonClass;
        }
        if (this.isDisabled()) {
            result = result + "-dis";
        }
        if (result.equals("Button")) {
            return Util.appendNewStyleClass("iceFileUpload", this.styleClass, result);
        }
        return result;
    }

    public String getFilename() {
        return this.getFileInfo().getFileName();
    }

    public void setFilename(String filename) {
        this.getFileInfo().setFileName(filename);
    }

    public long getFilesize() {
        return this.getFileInfo().getSize();
    }

    public void setFilesize(long filesize) {
        this.getFileInfo().setSize(filesize);
    }

    public String getMimeType() {
        return this.getFileInfo().getContentType();
    }

    public void setMimeType(String mimeType) {
        this.getFileInfo().setContentType(mimeType);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[26];
        values[0] = super.saveState(context);
        values[1] = this.fileInfo;
        values[2] = this.firstTd;
        values[3] = this.secondTd;
        values[4] = this.baseClass;
        values[5] = this.methodName;
        values[6] = this.disabled;
        values[7] = this.parentForm;
        values[8] = this.style;
        values[9] = this.styleClass;
        values[10] = this.label;
        values[11] = this.facesContext;
        values[12] = this.readonly;
        values[13] = this.enabledOnUserRole;
        values[14] = this.renderedOnUserRole;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.fileInfo = (FileInfo)values[1];
        this.firstTd = (Element)values[2];
        this.secondTd = (Element)values[3];
        this.baseClass = values[4];
        this.methodName = (String)values[5];
        this.disabled = (Boolean)values[6];
        this.parentForm = (UIForm)values[7];
        this.style = (String)values[8];
        this.styleClass = (String)values[9];
        this.label = (String)values[10];
        this.facesContext = (FacesContext)values[11];
        this.readonly = (Boolean)values[12];
        this.enabledOnUserRole = (String)values[13];
        this.renderedOnUserRole = (String)values[14];
    }

    private boolean isHeartbeatStopped() {
        return this.heartbeatStopped;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueBinding vb = this.getValueBinding("alt");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public String getMaxlength() {
        if (this.maxlength != null) {
            return this.maxlength;
        }
        ValueBinding vb = this.getValueBinding("maxlength");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueBinding vb = this.getValueBinding("size");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    String getRegistrationId() {
        if (this.registrationId == null) {
            this.registrationId = FILE_UPLOAD_PREFIX + this.getClientId(this.facesContext) + this.hashCode();
        }
        return this.registrationId;
    }

    String getQueryString(FacesContext facesContext) {
        String inputTextClass = this.getInputTextClass();
        String buttonClass = this.getButtonClass();
        String label = this.getLabel();
        boolean uniqueFolder = this.isUniqueFolder();
        String queryString = "?fileUploadComponentId=" + this.getRegistrationId() + "&disabled=" + this.isDisabled() + "&inputTextClass=" + inputTextClass + "&buttonClass=" + buttonClass + "&label=" + label + "&uniqueFolder=" + uniqueFolder + "&cssFile=" + this.getCssFile();
        return queryString;
    }

    void registerWithSession(FacesContext facesContext) {
        if (!facesContext.getExternalContext().getSessionMap().containsKey(this.getRegistrationId())) {
            facesContext.getExternalContext().getSessionMap().put(this.getRegistrationId(), this);
            this.setRegister(facesContext);
        }
    }

    public long getSizeMax() {
        return FileUploadServlet.uploadMaxFileSize;
    }

    public String getCssFile() {
        if (this.cssFile == null) {
            this.cssFile = "./xmlhttp/css/xp/xp.css";
            UIViewRoot root = this.getFacesContext().getViewRoot();
            this.setCssFile((UIComponent)root);
        }
        return this.cssFile;
    }

    private void setCssFile(UIComponent component) {
        if (component instanceof OutputStyle) {
            this.cssFile = this.cssFile + (this.cssFile != null ? ", " : "");
            this.cssFile = this.cssFile + component.getAttributes().get("href").toString();
        }
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            this.setCssFile((UIComponent)children.next());
        }
    }
}

