/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.DiskFileUpload;
import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;

public class FileUploadServlet
extends com.icesoft.faces.webapp.xmlhttp.FileUploadServlet {
    public static final String UPLOAD_DIRECTORY = "com.icesoft.faces.uploadDirectory";
    public static final String UPLOAD_MAX_FILE_SIZE = "com.icesoft.faces.uploadMaxFileSize";
    public static final String UPLOAD_DIRECTORY_ABSOLUTE = "com.icesoft.faces.uploadDirectoryAbsolute";
    static long uploadMaxFileSize;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        try {
            uploadMaxFileSize = Long.parseLong(servletContext.getInitParameter(UPLOAD_MAX_FILE_SIZE));
        }
        catch (NumberFormatException e) {
            uploadMaxFileSize = 0xA00000L;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.sendOutput(response, this.getHtml(request));
    }

    private String getComponentId(HttpServletRequest request) {
        return request.getParameter("fileUploadComponentId").toString();
    }

    private String getDisabled(HttpServletRequest request) {
        String disabledParam = request.getParameter("disabled");
        if (disabledParam != null && disabledParam.toString().equalsIgnoreCase("true")) {
            return "disabled";
        }
        return "";
    }

    private String getCSSFile(HttpServletRequest request) {
        String cssFile = request.getParameter("cssFile");
        if (cssFile != null) {
            return cssFile.toString();
        }
        return null;
    }

    private String getInputTextClass(HttpServletRequest request) {
        if (request.getParameter("inputTextClass") != null) {
            return "class='" + request.getParameter("inputTextClass").toString() + "'";
        }
        return null;
    }

    private String getButtonClass(HttpServletRequest request) {
        if (request.getParameter("buttonClass") != null) {
            return "class='" + request.getParameter("buttonClass").toString() + "'";
        }
        return null;
    }

    private String getLabel(HttpServletRequest request) {
        if (request.getParameter("label") != null) {
            return request.getParameter("label").toString();
        }
        return "Upload";
    }

    private boolean isUniqueFolder(HttpServletRequest request) {
        return request.getParameter("uniqueFolder") != null && request.getParameter("uniqueFolder").trim().equalsIgnoreCase("true");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isMultipart = FileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            this.processMultipartContent(request, response);
        }
        this.sendOutput(response, this.getHtml(request));
    }

    private void processMultipartContent(HttpServletRequest request, HttpServletResponse response) {
        PersistentFacesState state = PersistentFacesState.getInstance();
        HttpSession session = request.getSession(true);
        DiskFileUpload upload = new DiskFileUpload(session);
        upload.setSizeMax(uploadMaxFileSize);
        try {
            List items = upload.parseRequest(request);
            this.SaveFile(items, request, this.config, session);
        }
        catch (FileUploadBase.SizeLimitExceededException limitExcep) {
            if (log.isDebugEnabled()) {
                log.debug((Object)limitExcep.getMessage());
            }
            this.execute(session, state);
        }
        catch (FileUploadException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            this.execute(session, state);
        }
    }

    private void SaveFile(List itemList, HttpServletRequest request, ServletConfig config, HttpSession session) {
        Iterator files = itemList.iterator();
        PersistentFacesState state = PersistentFacesState.getInstance();
        String componentId = null;
        InputFile inputFile = null;
        while (files.hasNext()) {
            FileItem item = (FileItem)files.next();
            if (item.isFormField()) {
                componentId = item.getString();
                if (session.getAttribute(componentId) == null) continue;
                inputFile = (InputFile)session.getAttribute(componentId);
                inputFile.fireEvent();
                continue;
            }
            if (item.isFormField() || item.getName() == null || item.getName().trim().length() <= 0) continue;
            String fileName = null;
            String FILE_SEPARATOR = System.getProperty("file.separator");
            int fileSeparatorIndex = item.getName().lastIndexOf(FILE_SEPARATOR);
            if (fileSeparatorIndex < 0) {
                fileSeparatorIndex = item.getName().lastIndexOf("\\");
            }
            fileName = fileSeparatorIndex > 0 ? item.getName().substring(fileSeparatorIndex + 1) : item.getName();
            inputFile.getFileInfo().setFileName(fileName);
            inputFile.getFileInfo().setContentType(item.getContentType());
            inputFile.getFileInfo().setPhysicalPath(this.getPath(request));
            try {
                File uploadFolder = new File(this.getPath(request));
                if (!uploadFolder.exists()) {
                    uploadFolder.mkdirs();
                }
                File file = new File(uploadFolder, fileName);
                item.write(file);
                inputFile.setFile(file);
                inputFile.setStatus(2);
                this.execute(session, state);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
            }
        }
        this.persistentStateClearInstance();
    }

    private String getPath(HttpServletRequest request) {
        String relativeDir = this.config.getServletContext().getInitParameter(UPLOAD_DIRECTORY);
        if (null == relativeDir) {
            relativeDir = "";
        }
        boolean absolute = false;
        String param = this.config.getServletContext().getInitParameter(UPLOAD_DIRECTORY_ABSOLUTE);
        if (param != null) {
            absolute = Boolean.valueOf(param);
        }
        String sessionId = request.getRequestedSessionId();
        String FILE_SEPARATOR = System.getProperty("file.separator");
        String dir = relativeDir;
        if (!absolute) {
            dir = this.config.getServletContext().getRealPath(relativeDir);
        }
        if (this.isUniqueFolder(request)) {
            dir = dir + FILE_SEPARATOR + sessionId;
        }
        return dir;
    }

    private void sendOutput(HttpServletResponse response, String output) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(output);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            e.printStackTrace();
        }
    }

    private String getHtml(HttpServletRequest request) {
        String link = "";
        if (this.getCSSFile(request) != null) {
            String[] links = this.getCSSFile(request).split(",");
            for (int i = 0; i < links.length; ++i) {
                link = link + "<link rel='stylesheet' type='text/css' href='" + links[i] + "'/>";
            }
        }
        String html = "<HTML><HEAD>" + link + "<SCRIPT LANGUAGE='javascript'>function mySubmit(frm) {frm.fileName.value = frm.inputFileField.value ; return true;} </SCRIPT>" + "</HEAD><BODY>" + "<FORM action='" + "uploadHtml" + "?" + request.getQueryString() + "' enctype='multipart/form-data' id='fileUploadForm' method='post' onsubmit='return mySubmit(this)'>" + "<DIV id='submit' style='position:absolute;'>" + "<INPUT name='fileName' type='hidden' value='test'/>" + "<INPUT name='" + "fileUploadComponentId" + "' type='hidden' value='" + this.getComponentId(request) + "'/>" + "<INPUT name='inputFileField' " + this.getInputTextClass(request) + " type='file'" + this.getDisabled(request) + " />" + "<INPUT type='submit' " + this.getButtonClass(request) + " value='" + this.getLabel(request) + "' " + this.getDisabled(request) + "/>" + "</DIV>" + "</FORM></BODY></HTML>";
        return html;
    }
}

