/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.taglib;

import com.icesoft.faces.component.IceExtended;
import com.icesoft.faces.component.ext.HtmlInputText;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.EffectBuilder;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static Log log = LogFactory.getLog((Class)Util.class);

    public static boolean isRenderedOnUserRole(UIComponent component) {
        String userRole = component instanceof IceExtended ? ((IceExtended)component).getRenderedOnUserRole() : (String)component.getAttributes().get("renderedOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabledOnUserRole(UIComponent component) {
        String userRole = component instanceof IceExtended ? ((IceExtended)component).getEnabledOnUserRole() : (String)component.getAttributes().get("enabledOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentPartialSubmit(UIComponent uiComponent) {
        UIComponent form = DomBasicRenderer.findForm((UIComponent)uiComponent);
        return form instanceof IceExtended && ((IceExtended)form).getPartialSubmit();
    }

    public static List getSelectItems(FacesContext context, UIComponent uiComponent) {
        ArrayList<Object> selectItems = new ArrayList<Object>();
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            Object selectItemsValue;
            UIComponent nextSelectItemChild = (UIComponent)children.next();
            if (nextSelectItemChild instanceof UISelectItem) {
                Object selectItemValue = ((UISelectItem)nextSelectItemChild).getValue();
                if (selectItemValue != null && selectItemValue instanceof SelectItem) {
                    selectItems.add(selectItemValue);
                    continue;
                }
                selectItems.add(new SelectItem(((UISelectItem)nextSelectItemChild).getItemValue(), ((UISelectItem)nextSelectItemChild).getItemLabel(), ((UISelectItem)nextSelectItemChild).getItemDescription(), ((UISelectItem)nextSelectItemChild).isItemDisabled()));
                continue;
            }
            if (!(nextSelectItemChild instanceof UISelectItems) || (selectItemsValue = ((UISelectItems)nextSelectItemChild).getValue()) == null) continue;
            if (selectItemsValue instanceof SelectItem) {
                selectItems.add(selectItemsValue);
                continue;
            }
            if (selectItemsValue instanceof Collection) {
                Iterator selectItemsIterator = ((Collection)selectItemsValue).iterator();
                while (selectItemsIterator.hasNext()) {
                    selectItems.add(selectItemsIterator.next());
                }
                continue;
            }
            if (selectItemsValue instanceof SelectItem[]) {
                SelectItem[] selectItemArray = (SelectItem[])selectItemsValue;
                for (int i = 0; i < selectItemArray.length; ++i) {
                    selectItems.add(selectItemArray[i]);
                }
                continue;
            }
            if (!(selectItemsValue instanceof Map)) continue;
            Iterator selectItemIterator = ((Map)selectItemsValue).keySet().iterator();
            while (selectItemIterator.hasNext()) {
                Object nextValue;
                Object nextKey = selectItemIterator.next();
                if (nextKey == null || (nextValue = ((Map)selectItemsValue).get(nextKey)) == null) continue;
                selectItems.add(new SelectItem((Object)nextValue.toString(), nextKey.toString()));
            }
        }
        return selectItems;
    }

    public static void addEffect(String effect, UIComponent panel) {
        if (effect != null) {
            if (Util.isValueReference(effect)) {
                ValueBinding vb = Util.getValueBinding(effect);
                panel.setValueBinding("effect", vb);
            } else {
                Effect fx = (Effect)panel.getAttributes().get("effect");
                if (fx == null) {
                    fx = EffectBuilder.build((String)effect);
                    panel.getAttributes().put("effect", fx);
                }
            }
        }
    }

    public static void addVisible(String visible, UIComponent panel) {
        if (visible != null) {
            if (Util.isValueReference(visible)) {
                ValueBinding vb = Util.getValueBinding(visible);
                panel.setValueBinding("visible", vb);
            } else {
                Boolean boolVisible = new Boolean(visible);
                panel.getAttributes().put("visible", boolVisible);
            }
        }
    }

    public static void addLocalEffect(String effect, String name, UIComponent panel) {
        if (effect != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("AddLocalEffect. String [" + effect + "] name [" + name + "] class [" + panel.getClass().getName() + "]"));
            }
            if (Util.isValueReference(effect)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Adding Value Binding");
                }
                ValueBinding vb = Util.getValueBinding(effect);
                panel.setValueBinding(name, vb);
            } else {
                Effect fx;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Adding Literal String");
                }
                if ((fx = (Effect)panel.getAttributes().get(name)) == null) {
                    fx = EffectBuilder.build((String)effect);
                    panel.getAttributes().put(name, fx);
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"AddLocalEffect. Effect is null");
        }
    }

    public static boolean isValueReference(String v) {
        if (v == null) {
            return false;
        }
        return v.startsWith("#{") && v.endsWith("}");
    }

    public static String stripPx(String s) {
        if (s == null) {
            return null;
        }
        int i = s.indexOf("px");
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    public static String getDisaledOREnabledClass(UIComponent uiComponent, boolean disabled, String styleClass, String styleClassAsString, String defaultStyleClass) {
        if (disabled) {
            return Util.getClassName(uiComponent, styleClass, styleClassAsString, defaultStyleClass) + "-dis";
        }
        return Util.getClassName(uiComponent, styleClass, styleClassAsString, defaultStyleClass);
    }

    public static String getClassName(UIComponent uiComponent, String styleClass, String styleClassAsString, String defaultStyleClass) {
        if (styleClass != null) {
            return styleClass;
        }
        ValueBinding vb = uiComponent.getValueBinding(styleClassAsString);
        return vb != null ? (String)vb.getValue(FacesContext.getCurrentInstance()) : defaultStyleClass;
    }

    public static String getApplicationBase(FacesContext facesContext) {
        Object sessionBase = facesContext.getExternalContext().getSession(true);
        Object requestBase = facesContext.getExternalContext().getRequest();
        String base = facesContext.getExternalContext().getInitParameter("war-name");
        if (base == null) {
            if (requestBase instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)requestBase;
                String context = request.getContextPath();
                String uri = request.getRequestURI();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Context [" + context + "] URI [" + uri + "]"));
                }
                if (null == uri) {
                    return "/";
                }
                int i = uri.indexOf(context);
                base = "./";
                if ((i += context.length() + 1) < uri.length()) {
                    String remain = uri.substring(i);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Remain [" + remain + "]"));
                    }
                    char[] ar = remain.toCharArray();
                    for (int c = 0; c < ar.length; ++c) {
                        if (ar[c] != '/') continue;
                        base = base + "../";
                    }
                }
            } else {
                base = "/";
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning URL [" + base + "]"));
        }
        return base;
    }

    public static String appendNewStyleClass(String baseDefault, String base, String styleClass) {
        String result = baseDefault + styleClass;
        if (log.isTraceEnabled()) {
            log.trace((Object)("baseDefault [" + baseDefault + "] base [" + base + "] styleClass [" + styleClass + "]"));
            log.trace((Object)("Base Result is [" + result + "]"));
        }
        if (base == null) {
            return result;
        }
        if (!baseDefault.equals(base)) {
            result = result + " " + base + styleClass;
            if (log.isTraceEnabled()) {
                log.trace((Object)("new Base, Appending Style [" + result + "]"));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Original Base, result [" + result + "]"));
        }
        return result;
    }

    public static ValueBinding getValueBinding(String valueRef) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().createValueBinding(valueRef);
    }

    public static boolean isEventSource(FacesContext facesContext, UIComponent uiComponent) {
        Object componenetId;
        Object focusId = facesContext.getExternalContext().getRequestParameterMap().get(FormRenderer.getFocusElementId());
        if (focusId != null) {
            if (focusId.toString().equals(uiComponent.getClientId(facesContext))) {
                ((HtmlInputText)uiComponent).setFocus(true);
            } else {
                ((HtmlInputText)uiComponent).setFocus(false);
            }
        }
        if ((componenetId = facesContext.getExternalContext().getRequestParameterMap().get("ice.event.captured")) != null) {
            return componenetId.toString().equals(uiComponent.getClientId(facesContext));
        }
        return false;
    }
}

