/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;

public class SetTopRule
extends Rule {
    protected String methodName = null;
    protected String paramType = null;
    protected boolean useExactMatch = false;

    public SetTopRule(Digester digester, String methodName) {
        this(methodName);
    }

    public SetTopRule(Digester digester, String methodName, String paramType) {
        this(methodName, paramType);
    }

    public SetTopRule(String methodName) {
        this(methodName, null);
    }

    public SetTopRule(String methodName, String paramType) {
        this.methodName = methodName;
        this.paramType = paramType;
    }

    public boolean isExactMatch() {
        return this.useExactMatch;
    }

    public void setExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    public void end() throws Exception {
        Object child = this.digester.peek(0);
        Object parent = this.digester.peek(1);
        if (Digester.log.isDebugEnabled()) {
            if (child == null) {
                Digester.log.debug((Object)("[SetTopRule]{" + this.digester.match + "} Call [NULL CHILD]." + this.methodName + "(" + parent + ")"));
            } else {
                Digester.log.debug((Object)("[SetTopRule]{" + this.digester.match + "} Call " + child.getClass().getName() + "." + this.methodName + "(" + parent + ")"));
            }
        }
        IntrospectionUtils.callMethod1(child, this.methodName, parent, this.paramType, this.digester.getClassLoader());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetTopRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramType=");
        sb.append(this.paramType);
        sb.append("]");
        return sb.toString();
    }
}

