/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.log;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.httpclient.log.Log;

public class SimpleLog
implements Log {
    protected static final Properties _simplelogProps = new Properties();
    protected static boolean _showlogname = false;
    protected static boolean _showtime = false;
    protected static DateFormat _df = null;
    protected int _logLevel = 40000;
    protected String _name = null;

    public SimpleLog(String name) {
        this._name = name;
        String lvl = _simplelogProps.getProperty("httpclient.simplelog.log." + this._name);
        int i = String.valueOf(name).lastIndexOf(".");
        while (null == lvl && i > -1) {
            name = name.substring(0, i);
            lvl = _simplelogProps.getProperty("httpclient.simplelog.log." + name);
            i = String.valueOf(name).lastIndexOf(".");
        }
        if (null == lvl) {
            lvl = _simplelogProps.getProperty("httpclient.simplelog.defaultlog");
        }
        if ("debug".equalsIgnoreCase(lvl)) {
            this._logLevel = 10000;
        } else if ("info".equalsIgnoreCase(lvl)) {
            this._logLevel = 20000;
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this._logLevel = 30000;
        } else if ("error".equalsIgnoreCase(lvl)) {
            this._logLevel = 40000;
        } else if ("fatal".equalsIgnoreCase(lvl)) {
            this._logLevel = 50000;
        }
    }

    protected void log(int type, Object message, Throwable t) {
        if (this._logLevel <= type) {
            StringBuffer buf = new StringBuffer();
            if (_showtime) {
                buf.append(_df.format(new Date()));
                buf.append(" ");
            }
            switch (type) {
                case 10000: {
                    buf.append("[DEBUG] ");
                    break;
                }
                case 20000: {
                    buf.append("[INFO] ");
                    break;
                }
                case 30000: {
                    buf.append("[WARN] ");
                    break;
                }
                case 40000: {
                    buf.append("[ERROR] ");
                    break;
                }
                case 50000: {
                    buf.append("[FATAL] ");
                }
            }
            if (_showlogname) {
                buf.append(String.valueOf(this._name)).append(" - ");
            }
            buf.append(String.valueOf(message));
            if (t != null) {
                buf.append(" <");
                buf.append(t.toString());
                buf.append(">");
                t.printStackTrace();
            }
            System.out.println(buf.toString());
        }
    }

    public final void debug(Object message) {
        this.log(10000, message, null);
    }

    public final void debug(Object message, Throwable t) {
        this.log(10000, message, t);
    }

    public final void info(Object message) {
        this.log(20000, message, null);
    }

    public final void info(Object message, Throwable t) {
        this.log(20000, message, t);
    }

    public final void warn(Object message) {
        this.log(30000, message, null);
    }

    public final void warn(Object message, Throwable t) {
        this.log(30000, message, t);
    }

    public final void error(Object message) {
        this.log(40000, message, null);
    }

    public final void error(Object message, Throwable t) {
        this.log(40000, message, t);
    }

    public final void fatal(Object message) {
        this.log(50000, message, null);
    }

    public final void fatal(Object message, Throwable t) {
        this.log(50000, message, t);
    }

    public final boolean isDebugEnabled() {
        return this._logLevel <= 10000;
    }

    public final boolean isInfoEnabled() {
        return this._logLevel <= 20000;
    }

    public final void setLevel(int level) {
        this._logLevel = level;
    }

    public final int getLevel() {
        return this._logLevel;
    }

    static {
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (null == name || !name.startsWith("httpclient.")) continue;
            _simplelogProps.setProperty(name, System.getProperty(name));
        }
        InputStream in = ClassLoader.getSystemResourceAsStream("simplelog.properties");
        if (null != in) {
            try {
                _simplelogProps.load(in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        _showlogname = "true".equalsIgnoreCase(_simplelogProps.getProperty("httpclient.simplelog.showlogname", "true"));
        _showtime = "true".equalsIgnoreCase(_simplelogProps.getProperty("httpclient.simplelog.showdate", "true"));
        if (_showtime) {
            _df = new SimpleDateFormat(_simplelogProps.getProperty("httpclient.simplelog.dateformat", "yyyy/MM/dd HH:mm:ss:SSS zzz"));
        }
    }
}

