/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

class LocationDialog
extends JDialog {
    public static final int ACCEPT_ALL = 8;
    public static final int DIRECTORIES_ONLY = 4;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int FILES_ONLY = 1;
    public static final int SELECTION_MULTI = 16;
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String DELIMETER = "|";
    private static final String EMPTY_STRING = "".intern();
    protected FileFilter fileFilter;
    protected JComboBox locationComboBox;
    protected List filters = Collections.EMPTY_LIST;
    protected ResourceBundle bundle;
    protected int maxHistoryItems = 10;
    protected int state;
    private boolean _disposed;
    private int _chooserProperties;

    LocationDialog(Frame owner, String title, String text, String history) {
        super(owner);
        this.initialize(title, text, history);
        this.setLocationRelativeTo(owner);
    }

    LocationDialog(Dialog owner, String title, String text, String history) {
        super(owner);
        this.initialize(title, text, history);
        this.setLocationRelativeTo(owner);
    }

    public static LocationDialog create(Window parent, String title, String text, String history) {
        if (parent instanceof Frame) {
            return new LocationDialog((Frame)parent, title, text, history);
        }
        if (parent instanceof Dialog) {
            return new LocationDialog((Dialog)parent, title, text, history);
        }
        throw new IllegalArgumentException("unknown parent type -- " + parent);
    }

    public static String loadHistory(File file) {
        if (file.exists() && file.isFile()) {
            try {
                return (String)IoHelper.deserialize(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return EMPTY_STRING;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void storeHistory(File file, String urls) {
        ObjectOutputStream out = null;
        out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeObject(urls);
        Object var5_3 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                ex.printStackTrace();
                Object var5_4 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setFileChooserProperties(int mask) {
        this._chooserProperties = mask;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public String getHistoryString() {
        return this.getHistoryString(this.getLocations(), this.getSelectedLocation());
    }

    public Object[] getLocations() {
        Object[] result = new Object[this.locationComboBox.getItemCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.locationComboBox.getItemAt(i);
            ++i;
        }
        return result;
    }

    public int getOption() {
        return this.state;
    }

    public Object getSelectedLocation() {
        return this.locationComboBox.getSelectedItem();
    }

    public void addFilter(FileFilter filter) {
        this.addFilter(filter, false);
    }

    public void addFilter(FileFilter filter, boolean standard) {
        if (this.filters.isEmpty()) {
            this.filters = new ArrayList(4);
        }
        if (standard) {
            this.filters.add(0, filter);
        } else {
            this.filters.add(filter);
        }
    }

    public void dispose() {
        super.dispose();
        if (!this._disposed) {
            this.locationComboBox = null;
            this.fileFilter = null;
            this.filters.clear();
            this.filters = null;
            this._disposed = true;
        }
    }

    protected JFileChooser createFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.getTitle());
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        this.setupFileChooser(chooser, this._chooserProperties);
        this.setCurrentDirectory(chooser);
        int i = this.filters.size() - 1;
        while (i >= 0) {
            if (i == 0) {
                chooser.setFileFilter((FileFilter)this.filters.get(i));
            } else {
                chooser.addChoosableFileFilter((FileFilter)this.filters.get(i));
            }
            --i;
        }
        return chooser;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        JButton okButton = SwingHelper.createButton(this.bundle.getString("BTN_OK"), false);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocationDialog.this.state = 0;
                LocationDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(okButton, c);
        panel.add(okButton);
        JButton cancelButton = SwingHelper.createButton(this.bundle.getString("BTN_CANCEL"), false);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocationDialog.this.state = 2;
                LocationDialog.this.setVisible(false);
            }
        });
        c.insets.left = 5;
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(cancelButton, c);
        panel.add(cancelButton);
        JButton browseButton = SwingHelper.createButton(this.bundle.getString("BTN_DLG_BROWSE"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LocationDialog.this.createFileChooser();
                switch (SwingHelper.showJFileChooser(chooser, LocationDialog.this, LocationDialog.this.bundle.getString("BTN_OK"))) {
                    case 0: {
                        File file = chooser.getSelectedFile();
                        String item = file.getAbsolutePath();
                        LocationDialog.this.locationComboBox.removeItem(item);
                        LocationDialog.this.locationComboBox.insertItemAt(item, 0);
                        LocationDialog.this.locationComboBox.setSelectedIndex(0);
                        int items = LocationDialog.this.locationComboBox.getItemCount();
                        if (items <= LocationDialog.this.maxHistoryItems) break;
                        LocationDialog.this.locationComboBox.removeItemAt(items - 1);
                    }
                }
                LocationDialog.this.fileFilter = chooser.getFileFilter();
            }
        });
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(browseButton, c);
        panel.add(browseButton);
        return panel;
    }

    private void setCurrentDirectory(JFileChooser chooser) {
        String item = (String)this.locationComboBox.getSelectedItem();
        if (item != null) {
            File file = new File(item);
            if (file.exists()) {
                this.setCurrentDirectory(chooser, file);
            } else {
                String[] urls = this.getHistoryUrls(this.locationComboBox);
                int i = 0;
                while (i < urls.length) {
                    file = new File(urls[i]);
                    if (file.exists()) {
                        this.setCurrentDirectory(chooser, file);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void setCurrentDirectory(JFileChooser chooser, File file) {
        if (!file.isDirectory()) {
            chooser.setCurrentDirectory(file.getParentFile());
        } else {
            chooser.setCurrentDirectory(file);
        }
    }

    private String getHistoryString(Object[] urls, Object selectedUrl) {
        StringBuffer buf = new StringBuffer(300);
        buf.append(selectedUrl);
        buf.append(DELIMETER);
        int maxItems = 10;
        int i = 0;
        while (i < urls.length && i < maxItems) {
            if (urls[i] == selectedUrl) {
                --maxItems;
            } else {
                buf.append(urls[i]);
                buf.append(DELIMETER);
            }
            ++i;
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private String[] getHistoryUrls(String history) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(history, DELIMETER);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    private String[] getHistoryUrls(JComboBox combo) {
        String[] result = new String[combo.getItemCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)combo.getItemAt(i);
            ++i;
        }
        return result;
    }

    private void initialize(String title, String text, String history) {
        this.setTitle(title);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(350, 80));
        this.bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        Container contentPane = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(this.bundle.getString("LBL_OPEN"));
        c.insets.top = 5;
        c.insets.left = 5;
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        layout.setConstraints(label, c);
        contentPane.add(label);
        String[] urls = this.getHistoryUrls(history);
        this.locationComboBox = new JComboBox<String>(urls);
        this.locationComboBox.setEditable(true);
        if (urls.length > 0) {
            this.locationComboBox.setToolTipText(urls[0]);
        }
        this.locationComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                switch (ev.getStateChange()) {
                    case 1: {
                        LocationDialog.this.locationComboBox.setToolTipText((String)LocationDialog.this.locationComboBox.getSelectedItem());
                    }
                }
            }
        });
        c.insets.left = 10;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        layout.setConstraints(this.locationComboBox, c);
        contentPane.add(this.locationComboBox);
        JPanel buttonPanel = this.getButtonPanel();
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 10;
        c.insets.bottom = 5;
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(buttonPanel, c);
        contentPane.add(buttonPanel);
        this.pack();
    }

    private void setupFileChooser(JFileChooser chooser, int mask) {
        switch (mask) {
            case 1: {
                chooser.setFileSelectionMode(0);
            }
            case 2: {
                chooser.setFileSelectionMode(2);
                break;
            }
            case 4: {
                chooser.setFileSelectionMode(1);
                break;
            }
            case 16: {
                chooser.setMultiSelectionEnabled(true);
                break;
            }
            case 8: {
                chooser.setAcceptAllFileFilterUsed(true);
            }
        }
    }
}

