/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.tools.WsdlServiceGenerator;
import org.jbpm.bpel.xml.ProblemCollector;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.xml.Problem;

public class GenerateWsdlServiceTask
extends Task {
    private String processfile;
    private File outputdir;
    private String servicefile;
    private String bindingfile;

    public void execute() throws BuildException {
        ProcessArchive archive;
        try {
            archive = this.readProcessArchive();
        }
        catch (IOException e) {
            throw new BuildException("could not read process archive: " + this.processfile, (Throwable)e);
        }
        BpelProcessDefinition definition = (BpelProcessDefinition)archive.parseProcessDefinition();
        if (Problem.containsProblemsOfLevel((Collection)archive.getProblems(), (int)2)) {
            throw new BuildException("process definition is invalid");
        }
        WsdlServiceGenerator generator = new WsdlServiceGenerator();
        if (this.outputdir == null) {
            this.outputdir = new File(System.getProperty("user.dir"));
        }
        generator.setOutputDirectory(this.outputdir);
        if (this.bindingfile != null) {
            generator.setBindingFile(this.bindingfile);
        }
        if (this.servicefile != null) {
            generator.setServiceFile(this.servicefile);
        }
        ProblemCollector collector = new ProblemCollector();
        generator.setProblemHandler((ProblemHandler)collector);
        generator.generateWsdlService(definition);
        if (Problem.containsProblemsOfLevel((Collection)collector.getProblems(), (int)2)) {
            throw new BuildException("could not generate service definition");
        }
    }

    private ProcessArchive readProcessArchive() throws IOException {
        ProcessArchive processArchive;
        FileInputStream processStream = new FileInputStream(this.processfile);
        try {
            ProcessArchive processArchive2;
            processArchive = processArchive2 = new ProcessArchive(new ZipInputStream(processStream));
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((InputStream)processStream).close();
            throw throwable;
        }
        ((InputStream)processStream).close();
        return processArchive;
    }

    public void setProcessfile(String processfile) {
        this.processfile = processfile;
    }

    public void setServicefile(String serviceFile) {
        this.servicefile = serviceFile;
    }

    public void setBindingfile(String bindingFile) {
        this.bindingfile = bindingFile;
    }

    public void setOutputdir(File outputdir) {
        this.outputdir = outputdir;
    }
}

