/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.bpel.tools.JBossModuleDeployer;
import org.jbpm.bpel.tools.ModuleDeployer;

public class ModuleDeployHelper {
    private static final String DEFAULT_TARGET_SERVER = "jboss";

    public void deploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().deploy(url);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().undeploy(url);
    }

    public boolean isTargetServerJBoss() {
        String targetServer = System.getProperty("jbossws.target.server", DEFAULT_TARGET_SERVER);
        return DEFAULT_TARGET_SERVER.equals(targetServer);
    }

    public boolean isTargetServerTomcat() {
        String targetServer = System.getProperty("jbossws.target.server", DEFAULT_TARGET_SERVER);
        return "tomcat".equals(targetServer);
    }

    public MBeanServerConnection getServer() throws NamingException {
        InitialContext iniCtx = new InitialContext();
        MBeanServerConnection server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
        return server;
    }

    private ModuleDeployer getDeployer() {
        if (this.isTargetServerJBoss()) {
            return new JBossModuleDeployer();
        }
        throw new IllegalStateException("Unsupported target server");
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        URL url;
        block3: {
            try {
                url = new URL(archive);
            }
            catch (MalformedURLException ignore) {
                File file = new File(archive);
                if (file.exists()) {
                    url = file.toURL();
                }
                url = this.getClass().getClassLoader().getResource(archive);
                if (url != null) break block3;
                throw new IllegalArgumentException("Cannot obtain URL for archive: " + archive);
            }
        }
        return url;
    }
}

