/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class SerializableInputStream
extends InputStream
implements Serializable {
    static final long serialVersionUID = 3364193722688048342L;
    private byte[] data = null;
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public SerializableInputStream(InputStream ins) throws IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        int dat = ins.read();
        while (dat != -1) {
            byteList.add(new Byte((byte)dat));
            dat = ins.read();
        }
        this.data = new byte[byteList.size()];
        int counter = 0;
        Iterator itr = byteList.iterator();
        while (itr.hasNext()) {
            this.data[counter++] = (Byte)itr.next();
        }
        ins.close();
        this.buf = this.data;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public void close() throws IOException {
        System.err.println("close()");
    }

    public synchronized void reset() throws IOException {
        System.err.println("reset()");
    }

    public boolean markSupported() {
        System.err.println("markSupported()");
        return false;
    }

    public synchronized void mark(int readlimit) {
        System.err.println("mark(int readlimit)");
    }

    public long skip(long n) throws IOException {
        System.err.println("skip(long n)");
        return 0L;
    }

    public int read(byte[] b) throws IOException {
        System.err.println("read(byte b[])");
        return this.read(b, 0, this.data.length);
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }
}

