/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Jbpm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.init")
public class Init {
    private static final String NAME = Seam.getComponentName(Init.class);
    public static final String COMPONENT_CLASSES = NAME + ".componentClasses";
    public static final String MANAGED_PERSISTENCE_CONTEXTS = NAME + ".managedPersistenceContexts";
    public static final String MANAGED_SESSIONS = NAME + ".managedSessions";
    public static final String MANAGED_DATA_SOURCES = NAME + ".managedDataSources";
    public static final String JNDI_PATTERN = NAME + ".jndiPattern";
    private String[] managedPersistenceContexts = new String[0];
    private String[] managedSessions = new String[0];
    private String[] componentClasses = new String[0];
    private boolean isClientSideConversations = false;
    private boolean jbpmInstalled;
    private String jndiPattern;
    private Map<String, FactoryMethod> factories = new HashMap<String, FactoryMethod>();
    private Map<String, List<ObserverMethod>> observers = new HashMap<String, List<ObserverMethod>>();

    public String[] getManagedPersistenceContexts() {
        return this.managedPersistenceContexts;
    }

    public void setManagedPersistenceContexts(String[] managedPersistenceContexts) {
        this.managedPersistenceContexts = managedPersistenceContexts;
    }

    public String[] getManagedSessions() {
        return this.managedSessions;
    }

    public void setManagedSessions(String[] managedSessions) {
        this.managedSessions = managedSessions;
    }

    public String[] getComponentClasses() {
        return this.componentClasses;
    }

    public void setComponentClasses(String[] componentClasses) {
        this.componentClasses = componentClasses;
        this.jbpmInstalled = false;
        for (String className : componentClasses) {
            if (!Jbpm.class.getName().equals(className)) continue;
            this.jbpmInstalled = true;
        }
    }

    public static Init instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        Init init = (Init)Contexts.getApplicationContext().get(Init.class);
        return init;
    }

    public boolean isClientSideConversations() {
        return this.isClientSideConversations;
    }

    public void setClientSideConversations(boolean isClientSideConversations) {
        this.isClientSideConversations = isClientSideConversations;
    }

    public FactoryMethod getFactory(String variable) {
        return this.factories.get(variable);
    }

    public void addFactoryMethod(String variable, Method method, Component component) {
        this.factories.put(variable, new FactoryMethod(method, component));
    }

    public List<ObserverMethod> getObservers(String eventType) {
        return this.observers.get(eventType);
    }

    public void addObserverMethod(String eventType, Method method, Component component) {
        List<ObserverMethod> observerList = this.observers.get(eventType);
        if (observerList == null) {
            observerList = new ArrayList<ObserverMethod>();
            this.observers.put(eventType, observerList);
        }
        observerList.add(new ObserverMethod(method, component));
    }

    public boolean isJbpmInstalled() {
        return this.jbpmInstalled;
    }

    public String getJndiPattern() {
        return this.jndiPattern;
    }

    public void setJndiPattern(String jndiPattern) {
        this.jndiPattern = jndiPattern;
    }

    public static class ObserverMethod {
        public Method method;
        public Component component;

        ObserverMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
        }
    }

    public static class FactoryMethod {
        public Method method;
        public Component component;

        FactoryMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
        }
    }
}

