/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="events")
public class Events {
    private static final Log log = LogFactory.getLog(Events.class);
    private final Map<String, List<MethodBinding>> listeners = new HashMap<String, List<MethodBinding>>();

    @Create
    public void initialize() throws DocumentException {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/events.xml");
        if (stream == null) {
            log.info((Object)"no events.xml file found");
        } else {
            log.info((Object)"reading events.xml");
            SAXReader saxReader = new SAXReader();
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(stream);
            List elements = doc.getRootElement().elements("event");
            for (Element event : elements) {
                String type = event.attributeValue("type");
                ArrayList<MethodBinding> methodBindings = new ArrayList<MethodBinding>();
                this.listeners.put(type, methodBindings);
                List actions = event.elements("action");
                for (Element action : actions) {
                    String actionExpression = action.attributeValue("expression");
                    MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(actionExpression, null);
                    methodBindings.add(methodBinding);
                }
            }
        }
    }

    public void addListener(String type, String methodBindingExpression) {
        MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(methodBindingExpression, null);
        List<MethodBinding> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList<MethodBinding>();
            this.listeners.put(type, list);
        }
        list.add(methodBinding);
    }

    public void raiseEvent(String type) {
        List<Init.ObserverMethod> observers;
        log.debug((Object)("Processing event:" + type));
        List<MethodBinding> list = this.listeners.get(type);
        if (list != null) {
            for (MethodBinding listener : list) {
                listener.invoke(FacesContext.getCurrentInstance(), null);
            }
        }
        if ((observers = Init.instance().getObservers(type)) != null) {
            for (Init.ObserverMethod observer : observers) {
                Object listener = Component.getInstance(observer.component.getName(), true);
                Component.callComponentMethod(observer.component, listener, observer.method);
            }
        }
    }

    public static Events instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Events)Component.getInstance(Events.class, ScopeType.APPLICATION, true);
    }
}

