/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InheritableAnnotationHolder;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class ClassInfoImpl
extends InheritableAnnotationHolder
implements ClassInfo {
    private static final long serialVersionUID = 3545798779904340792L;
    protected String name;
    protected Class type;
    protected int modifiers;
    protected InterfaceInfo[] interfaces;
    protected MethodInfo[] methods;
    protected FieldInfo[] fields;
    protected HashMap fieldMap;
    protected ClassInfo superclass;
    protected ConstructorInfo[] constructors;

    public static MethodInfo findMethod(MethodInfo[] methods, String name, TypeInfo[] parameters) {
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || methods[i].getParameterTypes().length != parameters.length) continue;
            boolean ok = true;
            for (int j = 0; j < parameters.length; ++j) {
                if (parameters[j].equals(methods[i].getParameterTypes()[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return methods[i];
        }
        return null;
    }

    public ClassInfoImpl() {
    }

    public ClassInfoImpl(String name) {
        this.name = name;
    }

    public ClassInfoImpl(String name, int modifiers, InterfaceInfo[] interfaces, ClassInfoImpl superclass) {
        this.name = name;
        this.modifiers = modifiers;
        this.interfaces = interfaces;
        this.superclass = superclass;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setInterfaces(InterfaceInfo[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setDeclaredMethods(MethodInfoImpl[] methods) {
        this.methods = methods;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                methods[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredFields(FieldInfoImpl[] fields) {
        this.fields = fields;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredConstructors(ConstructorInfoImpl[] constructors) {
        this.constructors = constructors;
        if (constructors != null) {
            for (int i = 0; i < constructors.length; ++i) {
                constructors[i].declaringClass = this;
            }
        }
    }

    public void setSuperclass(ClassInfo superInfo) {
        this.superclass = superInfo;
    }

    public boolean isInterface() {
        return false;
    }

    public InterfaceInfo[] getInterfaces() {
        return this.interfaces;
    }

    public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
        return ClassInfoImpl.findMethod(this.methods, name, parameters);
    }

    public MethodInfo[] getDeclaredMethods() {
        return this.methods;
    }

    public FieldInfo getDeclaredField(String name) {
        return (FieldInfo)this.fieldMap.get(name);
    }

    public FieldInfo[] getDeclaredFields() {
        return this.fields;
    }

    public ConstructorInfo[] getDeclaredConstructors() {
        return this.constructors;
    }

    public ClassInfo getSuperclass() {
        return this.superclass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassInfoImpl)) {
            return false;
        }
        ClassInfoImpl other = (ClassInfoImpl)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

