/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvalidConfigurationException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.tm.remoting.Invocation;

public class ClientInvocationHandler
implements InvocationHandler,
Externalizable {
    static final long serialVersionUID = 2253923354553253502L;
    public static final char TRANSACTION_FACTORY = 'F';
    public static final char COORDINATOR = 'C';
    public static final char TERMINATOR = 'T';
    public static final char RESOURCE = 'R';
    public static final char RECOVERY_COORDINATOR = 'V';
    public static final char SYNCHRONIZATION = 'S';
    private char interfaceCode;
    private long targetObjectId;
    private InvokerLocator[] locators;
    private Client client;
    private String stringRepresentation;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$TransactionFactory;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Coordinator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Terminator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Resource;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Synchronization;
    static /* synthetic */ Class class$java$lang$Object;

    public ClientInvocationHandler() {
    }

    public ClientInvocationHandler(Class interf, InvokerLocator[] locators) throws Exception {
        this(interf, 0L, locators);
    }

    public ClientInvocationHandler(Class interf, long targetObjectId, InvokerLocator[] locators) throws Exception {
        this(ClientInvocationHandler.getInterfaceCode(interf), targetObjectId, locators);
    }

    public ClientInvocationHandler(char interfaceCode, InvokerLocator[] locators) throws Exception {
        this(interfaceCode, 0L, locators);
    }

    public ClientInvocationHandler(char interfaceCode, long targetObjectId, InvokerLocator[] locators) throws Exception {
        if (interfaceCode != 'F' && interfaceCode != 'C' && interfaceCode != 'T' && interfaceCode != 'R' && interfaceCode != 'V' && interfaceCode != 'S') {
            throw new IllegalArgumentException();
        }
        if (locators.length == 0) {
            throw new IllegalArgumentException();
        }
        this.interfaceCode = interfaceCode;
        this.targetObjectId = targetObjectId;
        this.locators = locators;
    }

    Class getClientInterface() {
        switch (this.interfaceCode) {
            case 'F': {
                return class$org$jboss$tm$remoting$interfaces$TransactionFactory == null ? (class$org$jboss$tm$remoting$interfaces$TransactionFactory = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.TransactionFactory")) : class$org$jboss$tm$remoting$interfaces$TransactionFactory;
            }
            case 'C': {
                return class$org$jboss$tm$remoting$interfaces$Coordinator == null ? (class$org$jboss$tm$remoting$interfaces$Coordinator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Coordinator")) : class$org$jboss$tm$remoting$interfaces$Coordinator;
            }
            case 'T': {
                return class$org$jboss$tm$remoting$interfaces$Terminator == null ? (class$org$jboss$tm$remoting$interfaces$Terminator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Terminator")) : class$org$jboss$tm$remoting$interfaces$Terminator;
            }
            case 'R': {
                return class$org$jboss$tm$remoting$interfaces$Resource == null ? (class$org$jboss$tm$remoting$interfaces$Resource = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Resource")) : class$org$jboss$tm$remoting$interfaces$Resource;
            }
            case 'V': {
                return class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator == null ? (class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.RecoveryCoordinator")) : class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator;
            }
            case 'S': {
                return class$org$jboss$tm$remoting$interfaces$Synchronization == null ? (class$org$jboss$tm$remoting$interfaces$Synchronization = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Synchronization")) : class$org$jboss$tm$remoting$interfaces$Synchronization;
            }
        }
        throw new RuntimeException("Illegal value in field interfaceCode");
    }

    private static char getInterfaceCode(Class interf) {
        if (interf == (class$org$jboss$tm$remoting$interfaces$TransactionFactory == null ? (class$org$jboss$tm$remoting$interfaces$TransactionFactory = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.TransactionFactory")) : class$org$jboss$tm$remoting$interfaces$TransactionFactory)) {
            return 'F';
        }
        if (interf == (class$org$jboss$tm$remoting$interfaces$Coordinator == null ? (class$org$jboss$tm$remoting$interfaces$Coordinator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Coordinator")) : class$org$jboss$tm$remoting$interfaces$Coordinator)) {
            return 'C';
        }
        if (interf == (class$org$jboss$tm$remoting$interfaces$Terminator == null ? (class$org$jboss$tm$remoting$interfaces$Terminator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Terminator")) : class$org$jboss$tm$remoting$interfaces$Terminator)) {
            return 'T';
        }
        if (interf == (class$org$jboss$tm$remoting$interfaces$Resource == null ? (class$org$jboss$tm$remoting$interfaces$Resource = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Resource")) : class$org$jboss$tm$remoting$interfaces$Resource)) {
            return 'R';
        }
        if (interf == (class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator == null ? (class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.RecoveryCoordinator")) : class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator)) {
            return 'V';
        }
        if (interf == (class$org$jboss$tm$remoting$interfaces$Synchronization == null ? (class$org$jboss$tm$remoting$interfaces$Synchronization = ClientInvocationHandler.class$("org.jboss.tm.remoting.interfaces.Synchronization")) : class$org$jboss$tm$remoting$interfaces$Synchronization)) {
            return 'S';
        }
        throw new IllegalArgumentException("argument is not a DTM interface");
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object savedException = null;
        if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = ClientInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object)) {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return this.toString();
            }
            if (methodName.equals("hashCode")) {
                return new Integer(this.toString().hashCode());
            }
            if (methodName.equals("equals")) {
                return new Boolean(this.toString().equals(args[0].toString()));
            }
        }
        if (this.client != null) {
            try {
                return this.client.invoke((Object)new Invocation(this.targetObjectId, method, args));
            }
            catch (CannotConnectException e) {
                this.client = null;
            }
        }
        Invocation invocation = new Invocation(this.targetObjectId, method, args);
        for (int i = 0; i < this.locators.length; ++i) {
            try {
                this.client = new Client(this.locators[i], "DTM");
                return this.client.invoke((Object)invocation);
            }
            catch (CannotConnectException e) {
                this.client = null;
                savedException = e;
                continue;
            }
            catch (InvalidConfigurationException e) {
                this.client = null;
                savedException = e;
            }
        }
        throw new RemoteException(savedException.getClass().getName(), (Throwable)savedException);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.interfaceCode = in.readChar();
        this.targetObjectId = in.readLong();
        int len = in.readShort();
        if (len < 1) {
            throw new IOException("ObjectInput does not contain a valid ClientInvocationHandler");
        }
        this.locators = new InvokerLocator[len];
        for (int i = 0; i < len; ++i) {
            this.locators[i] = new InvokerLocator(in.readUTF());
        }
        this.client = null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeChar(this.interfaceCode);
        out.writeLong(this.targetObjectId);
        out.writeShort(this.locators.length);
        for (int i = 0; i < this.locators.length; ++i) {
            out.writeUTF(this.locators[i].getLocatorURI());
        }
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.interfaceCode + Long.toHexString(this.targetObjectId) + ',' + this.locators[0].getLocatorURI();
        }
        for (int i = 1; i < this.locators.length; ++i) {
            this.stringRepresentation = this.stringRepresentation + '|' + this.locators[i].getLocatorURI();
        }
        return this.stringRepresentation;
    }

    public static ClientInvocationHandler fromString(String s) throws Exception {
        InvokerLocator locator;
        String locatorURI;
        int oidEndIndex = s.indexOf(44);
        if (oidEndIndex == -1) {
            throw new IllegalArgumentException();
        }
        String oidString = s.substring(1, oidEndIndex);
        int uriStartIndex = oidEndIndex + 1;
        int uriEndIndex = s.indexOf(124, uriStartIndex);
        if (uriEndIndex == -1) {
            String locatorURI2 = s.substring(uriStartIndex);
            InvokerLocator locator2 = new InvokerLocator(locatorURI2);
            return new ClientInvocationHandler(s.charAt(0), Long.parseLong(oidString, 16), new InvokerLocator[]{locator2});
        }
        ArrayList<InvokerLocator> locatorList = new ArrayList<InvokerLocator>();
        while (uriEndIndex != -1) {
            locatorURI = s.substring(uriStartIndex, uriEndIndex);
            locator = new InvokerLocator(locatorURI);
            locatorList.add(locator);
            uriStartIndex = uriEndIndex + 1;
            uriEndIndex = s.indexOf(124, uriStartIndex);
        }
        locatorURI = s.substring(uriStartIndex);
        locator = new InvokerLocator(locatorURI);
        locatorList.add(locator);
        InvokerLocator[] locators = locatorList.toArray(new InvokerLocator[0]);
        return new ClientInvocationHandler(s.charAt(0), Long.parseLong(oidString, 16), locators);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

