/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.ResultSet;
import org.postgresql.jdbc2.Connection;
import org.postgresql.util.PSQLException;

public class Statement
extends org.postgresql.Statement
implements java.sql.Statement {
    Connection connection;
    java.sql.ResultSet result = null;
    SQLWarning warnings = null;
    int timeout = 0;
    boolean escapeProcessing = true;
    private Vector batch = null;
    int resultsettype;
    int concurrency;
    int maxrows = 0;

    public Statement(Connection connection) {
        this.connection = connection;
        this.resultsettype = 1004;
        this.concurrency = 1007;
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        while (this.result != null && !((ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public void close() throws SQLException {
        java.sql.ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            resultSet.close();
        }
        this.result = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxrows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        java.sql.ResultSet resultSet;
        if (this.escapeProcessing) {
            string = this.connection.EscapeSQL(string);
        }
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = this.connection.ExecSQL(string, this);
        ((org.postgresql.jdbc2.ResultSet)this.result).setStatement(this);
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        if (this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet()) {
            return this.result;
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((ResultSet)((Object)this.result)).getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((ResultSet)((Object)this.result)).getStatusString();
    }

    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        this.batch.addElement(string);
    }

    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.removeAllElements();
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null || this.batch.isEmpty()) {
            throw new PSQLException("postgresql.stat.batch.empty");
        }
        int n = this.batch.size();
        int[] nArray = new int[n];
        int n2 = 0;
        this.execute("begin");
        try {
            n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.executeUpdate((String)this.batch.elementAt(n2));
                ++n2;
            }
            this.execute("commit");
        }
        catch (SQLException sQLException) {
            this.execute("abort");
            throw new PSQLException("postgresql.stat.batch.error", new Integer(n2), this.batch.elementAt(n2));
        }
        return nArray;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public int getFetchSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultsettype;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFetchSize(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setResultSetConcurrency(int n) throws SQLException {
        this.concurrency = n;
    }

    public void setResultSetType(int n) throws SQLException {
        this.resultsettype = n;
    }

    public int getInsertedOID() throws SQLException {
        if (this.result != null) {
            return ((ResultSet)((Object)this.result)).getInsertedOID();
        }
        return 0;
    }
}

