/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.log.ProcessLog;

public class LoggingSession {
    JbpmSession jbpmSession;
    Session session;
    private static final Log log = LogFactory.getLog((Class)LoggingSession.class);

    public LoggingSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public LoggingSession(Session session) {
        this.session = session;
        this.jbpmSession = new JbpmSession(session);
    }

    public Map findLogsByProcessInstance(long processInstanceId) {
        HashMap tokenLogs = new HashMap();
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            this.collectTokenLogs(tokenLogs, processInstance.getRootToken());
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get logs for process instance '" + processInstanceId + "'", e);
        }
        return tokenLogs;
    }

    private void collectTokenLogs(Map tokenLogs, Token token) {
        tokenLogs.put(token, this.findLogsByToken(token.getId()));
        Map children = token.getChildren();
        if (children != null && !children.isEmpty()) {
            Iterator iter = children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                this.collectTokenLogs(tokenLogs, child);
            }
        }
    }

    public List findLogsByToken(long tokenId) {
        List result = null;
        try {
            Token token = (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
            Query query = this.session.getNamedQuery("LoggingSession.findLogsByToken");
            query.setEntity("token", (Object)token);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get logs for token '" + tokenId + "'", e);
        }
        return result;
    }

    public void saveProcessLog(ProcessLog processLog) {
        try {
            this.session.save((Object)processLog);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't save process log '" + processLog + "'", e);
        }
    }

    public ProcessLog loadProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.load(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process log '" + processLogId + "'", e);
        }
        return processLog;
    }

    public ProcessLog getProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.get(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process log '" + processLogId + "'", e);
        }
        return processLog;
    }
}

