/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;

public class NewProcessInstanceCommand
implements Command {
    private static final long serialVersionUID = 1L;
    String processDefinitionName = null;
    long processDefinitionId = 0L;
    String actorId = null;
    Map variables = null;
    boolean createStartTask = false;

    public Object execute(JbpmContext jbpmContext) throws Exception {
        if (this.actorId != null) {
            jbpmContext.setActorId(this.actorId);
        }
        ProcessInstance processInstance = null;
        if (this.processDefinitionName != null) {
            processInstance = jbpmContext.newProcessInstance(this.processDefinitionName);
        } else {
            ProcessDefinition processDefinition = jbpmContext.getGraphSession().loadProcessDefinition(this.processDefinitionId);
            processInstance = new ProcessInstance(processDefinition);
        }
        Serializable result = null;
        result = this.createStartTask ? processInstance.getTaskMgmtInstance().createStartTaskInstance() : processInstance;
        if (this.variables != null) {
            ContextInstance contextInstance = processInstance.getContextInstance();
            Iterator iter = this.variables.keySet().iterator();
            while (iter.hasNext()) {
                String variableName = (String)iter.next();
                contextInstance.setVariable(variableName, this.variables.get(variableName));
            }
        }
        jbpmContext.save(processInstance);
        return result;
    }

    public String getActorId() {
        return this.actorId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public long getProcessId() {
        return this.processDefinitionId;
    }

    public void setProcessId(long processId) {
        this.processDefinitionId = processId;
    }

    public String getProcessName() {
        return this.processDefinitionName;
    }

    public void setProcessName(String processName) {
        this.processDefinitionName = processName;
    }

    public boolean isCreateStartTask() {
        return this.createStartTask;
    }

    public void setCreateStartTask(boolean createStartTask) {
        this.createStartTask = createStartTask;
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }
}

