/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.db.JbpmSchema;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ChangeProcessInstanceVersionCommand
implements Command {
    private static final long serialVersionUID = 2277080393930008224L;
    private long processId;
    private int newVersion;
    private static final Log log = LogFactory.getLog((Class)JbpmSchema.class);
    private transient JbpmContext jbpmContext = null;
    private Map nameMapping;

    public ChangeProcessInstanceVersionCommand() {
    }

    public ChangeProcessInstanceVersionCommand(long processId, int newVersion) {
        this.processId = processId;
        this.newVersion = newVersion;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        ProcessInstance pi = jbpmContext.getGraphSession().loadProcessInstance(this.processId);
        this.changeTokenVersion(jbpmContext, pi.getRootToken());
        ProcessDefinition oldDef = pi.getProcessDefinition();
        ProcessDefinition newDef = jbpmContext.getGraphSession().findProcessDefinition(oldDef.getName(), this.newVersion);
        log.debug((Object)("changes process id " + pi.getId() + " from version " + pi.getProcessDefinition().getVersion() + " to new version " + newDef.getVersion()));
        pi.setProcessDefinition(newDef);
        log.debug((Object)("process id " + pi.getId() + " changed to version " + pi.getProcessDefinition().getVersion()));
        return null;
    }

    private void changeTokenVersion(JbpmContext jbpmContext, Token token) {
        Node oldNode = token.getNode();
        ProcessDefinition oldDef = token.getProcessInstance().getProcessDefinition();
        ProcessDefinition newDef = jbpmContext.getGraphSession().findProcessDefinition(oldDef.getName(), this.newVersion);
        Node newNode = newDef.findNode(this.getNewNodeName(oldNode));
        if (newNode == null) {
            throw new JbpmException("node with name '" + this.getNewNodeName(oldNode) + "' not found in new process definition");
        }
        log.debug((Object)("change token id " + token.getId() + " from version " + oldDef.getVersion() + " to new version " + newDef.getVersion()));
        token.setNode(newNode);
        Iterator iter = this.getTasksForToken(token).iterator();
        while (iter.hasNext()) {
            TaskInstance ti = (TaskInstance)iter.next();
            Task oldTask = ti.getTask();
            Query q = jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskForNode");
            q.setString("taskName", oldTask.getName());
            q.setLong("taskNodeId", newNode.getId());
            Task newTask = (Task)q.uniqueResult();
            if (newTask == null) {
                throw new JbpmException("node '" + newNode.getName() + "' has no Task configured! Check the new process definition");
            }
            ti.setTask(newTask);
            log.debug((Object)("change dependent task-instance with id " + oldTask.getId()));
        }
        Iterator childIter = token.getChildren().values().iterator();
        while (childIter.hasNext()) {
            this.changeTokenVersion(jbpmContext, (Token)childIter.next());
        }
    }

    private String getNewNodeName(Node oldNode) {
        String oldName = oldNode.getName();
        if (this.nameMapping.containsKey(oldName)) {
            return (String)this.nameMapping.get(oldName);
        }
        return oldName;
    }

    private List getTasksForToken(Token token) {
        Query query = this.jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
        query.setLong("tokenId", token.getId());
        return query.list();
    }
}

